/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.config;

import carbonconfiglib.gui.api.IArrayNode;
import carbonconfiglib.gui.api.ICompoundNode;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.widgets.CarbonButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public class BooleanElement
extends ConfigElement {
    private Button trueButton;
    private Button falseButton;

    public BooleanElement(IValueNode value) {
        super(value);
    }

    public BooleanElement(IArrayNode array, IValueNode value) {
        super(array, value);
    }

    public BooleanElement(ICompoundNode compound, IValueNode value) {
        super(compound, value);
    }

    @Override
    public void init() {
        super.init();
        int width = this.isArray() ? 72 : (this.isCompound() ? 52 : 36);
        this.trueButton = this.addChild(new CarbonButton(0, 0, width, 18, (Component)new TranslatableComponent("gui.carbonconfig.boolean.true"), this::onTrue), this.isArray() ? ConfigElement.GuiAlign.CENTER : ConfigElement.GuiAlign.RIGHT, this.isArray() ? width / 2 : width + (this.isCompound() ? 1 : 0));
        this.falseButton = this.addChild(new CarbonButton(0, 0, width + (this.isCompound() ? 1 : 0), 18, (Component)new TranslatableComponent("gui.carbonconfig.boolean.false"), this::onFalse), this.isArray() ? ConfigElement.GuiAlign.CENTER : ConfigElement.GuiAlign.RIGHT, this.isArray() ? -(width / 2) : 0);
        this.updateData();
    }

    private void updateData() {
        boolean isTrue = Boolean.parseBoolean(this.value.get());
        this.trueButton.f_93623_ = !isTrue;
        this.falseButton.f_93623_ = isTrue;
    }

    @Override
    public void tick() {
        super.tick();
        this.updateData();
    }

    protected void onTrue(Button button) {
        this.value.set("true");
    }

    protected void onFalse(Button button) {
        this.value.set("false");
    }
}

