/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.worldgen.vein;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import org.gtreimagined.gtlib.material.Material;

public class VeinSavedData
extends SavedData {
    public final HashMap<ChunkPos, Map<Material, LongList>> ores = new HashMap();
    private final ServerLevel serverLevel;

    public VeinSavedData(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VeinSavedData(ServerLevel serverLevel, CompoundTag nbt) {
        this(serverLevel);
        ListTag list = nbt.m_128437_("veinInfo", 10);
        for (Tag tag : list) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag compoundTag = (CompoundTag)tag;
            ChunkPos chunkPos = new ChunkPos(compoundTag.m_128454_("p"));
            ListTag listTag = compoundTag.m_128437_("d", 10);
            Object2ObjectOpenHashMap materialMap = new Object2ObjectOpenHashMap();
            listTag.forEach(arg_0 -> VeinSavedData.lambda$new$1((Map)materialMap, arg_0));
            HashMap<ChunkPos, Map<Material, LongList>> hashMap = this.ores;
            synchronized (hashMap) {
                this.ores.put(chunkPos, (Map<Material, LongList>)materialMap);
            }
        }
    }

    public static VeinSavedData getOrCreate(ServerLevel serverLevel) {
        VeinSavedData data = (VeinSavedData)serverLevel.m_8895_().m_164858_(tag -> new VeinSavedData(serverLevel, (CompoundTag)tag), "antimatter_ore_veins");
        if (data == null) {
            data = (VeinSavedData)serverLevel.m_8895_().m_164861_(tag -> new VeinSavedData(serverLevel, (CompoundTag)tag), () -> new VeinSavedData(serverLevel), "gtlib_ore_veins");
        } else {
            serverLevel.m_8895_().m_164855_("gtlib_ore_veins", (SavedData)data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag oilList = new ListTag();
        HashMap<ChunkPos, Map<Material, LongList>> hashMap = this.ores;
        synchronized (hashMap) {
            for (Map.Entry<ChunkPos, Map<Material, LongList>> entry : this.ores.entrySet()) {
                CompoundTag tag = new CompoundTag();
                tag.m_128356_("p", entry.getKey().m_45588_());
                ListTag listTag = new ListTag();
                entry.getValue().forEach((m, l) -> {
                    ListTag positions = new ListTag();
                    l.forEach(p -> positions.add((Object)LongTag.m_128882_((long)p)));
                    CompoundTag data = new CompoundTag();
                    data.m_128359_("material", m.getId());
                    data.m_128365_("positions", (Tag)positions);
                    listTag.add((Object)data);
                });
                tag.m_128365_("d", (Tag)listTag);
                oilList.add((Object)tag);
            }
        }
        compoundTag.m_128365_("veinInfo", (Tag)oilList);
        return compoundTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Material, LongList> geOresInChunk(int chunkX, int chunkZ) {
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        HashMap<ChunkPos, Map<Material, LongList>> hashMap = this.ores;
        synchronized (hashMap) {
            if (!this.ores.containsKey(chunkPos)) {
                this.ores.put(chunkPos, (Map<Material, LongList>)new Object2ObjectOpenHashMap());
                this.m_77762_();
            }
            return this.ores.get(chunkPos);
        }
    }

    public Map<Material, LongList> getOresInChunkAtY(int chunkX, int chunkZ, int y) {
        Map<Material, LongList> map = this.geOresInChunk(chunkX, chunkZ);
        Object2ObjectOpenHashMap map2 = new Object2ObjectOpenHashMap();
        map.forEach((arg_0, arg_1) -> VeinSavedData.lambda$getOresInChunkAtY$9(y, (Map)map2, arg_0, arg_1));
        return map2;
    }

    public boolean addOreToChunk(int chunkX, int chunkZ, Material material, BlockPos pos) {
        Map<Material, LongList> map = this.geOresInChunk(chunkX, chunkZ);
        if (!map.containsKey(material) || !map.get(material).contains(pos.m_121878_())) {
            map.computeIfAbsent(material, l -> new LongArrayList()).add(pos.m_121878_());
            this.m_77762_();
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$getOresInChunkAtY$9(int y, Map map2, Material k, LongList v) {
        v.forEach(l -> {
            BlockPos pos = BlockPos.m_122022_((long)l);
            if (pos.m_123342_() == y) {
                map2.computeIfAbsent(k, k1 -> new LongArrayList()).add(l);
            }
        });
    }

    private static /* synthetic */ void lambda$new$1(Map materialMap, Tag t) {
        if (t instanceof CompoundTag) {
            CompoundTag compoundTag1 = (CompoundTag)t;
            Material mat = Material.get(compoundTag1.m_128461_("material"));
            ListTag positions = compoundTag1.m_128437_("positions", 4);
            LongArrayList longList = new LongArrayList();
            positions.forEach(arg_0 -> VeinSavedData.lambda$new$0((LongList)longList, arg_0));
            materialMap.put(mat, longList);
        }
    }

    private static /* synthetic */ void lambda$new$0(LongList longList, Tag l) {
        longList.add(((LongTag)l).m_7046_());
    }
}

