/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.worldgen.smallore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.worldgen.smallore.SmallOre;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmallOreBuilder {
    @Nullable
    private Material material;
    @Nullable
    private Integer amountPerChunk;
    @Nullable
    private Integer maxY;
    @Nullable
    private Integer minY;
    ResourceLocation id;
    List<ResourceKey<Level>> dimensions = new ArrayList<ResourceKey<Level>>();
    List<String> biomes = new ArrayList<String>();
    boolean biomeBlacklist = true;

    public SmallOreBuilder(@NotNull ResourceLocation id) {
        this.id = id;
    }

    public final SmallOre buildMaterial() {
        if (this.id == null) {
            throw new RuntimeException("id is required");
        }
        if (this.amountPerChunk == null) {
            throw new RuntimeException("weight is required");
        }
        if (this.material == null) {
            throw new RuntimeException("material is required");
        }
        return new SmallOre(this.id, this.material, this.minY != null ? this.minY : Integer.MIN_VALUE, this.maxY != null ? this.maxY : Integer.MAX_VALUE, this.amountPerChunk, this.dimensions, this.biomes, this.biomeBlacklist);
    }

    public final SmallOreBuilder withMaterial(Material material) {
        this.material = material;
        return this;
    }

    public final SmallOreBuilder withAmountPerChunk(int amountPerChunk) {
        this.amountPerChunk = amountPerChunk;
        return this;
    }

    public final SmallOreBuilder atHeight(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
        return this;
    }

    public final SmallOreBuilder withBiomes(String ... biomes) {
        if (this.biomes.isEmpty() && biomes.length > 0) {
            this.biomeBlacklist = false;
        }
        Collections.addAll(this.biomes, biomes);
        return this;
    }

    public final SmallOreBuilder inDimension(ResourceKey<Level> dimension) {
        this.dimensions.add(dimension);
        return this;
    }

    public final SmallOreBuilder inDimensions(List<ResourceKey<Level>> dimension) {
        this.dimensions.addAll(dimension);
        return this;
    }

    @SafeVarargs
    public final SmallOreBuilder inDimensions(ResourceKey<Level> ... dimensions) {
        Collections.addAll(this.dimensions, dimensions);
        return this;
    }

    public final SmallOreBuilder setBiomeBlacklist(boolean blacklist) {
        this.biomeBlacklist = blacklist;
        return this;
    }
}

