/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.worldgen.smallore;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.util.TagUtils;
import org.gtreimagined.gtlib.worldgen.IWorldgenObject;

public record SmallOre(ResourceLocation id, Material material, int minY, int maxY, int amountPerChunk, List<ResourceKey<Level>> dimensions, List<String> biomes, boolean biomeBlacklist) implements IWorldgenObject<SmallOre>
{
    public static final Codec<SmallOre> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(SmallOre::id), (App)Material.CODEC.fieldOf("material").forGetter(SmallOre::material), (App)Codec.INT.fieldOf("minY").forGetter(SmallOre::minY), (App)Codec.INT.fieldOf("maxY").forGetter(SmallOre::maxY), (App)Codec.INT.fieldOf("amountPerChunk").forGetter(SmallOre::amountPerChunk), (App)ResourceKey.m_195966_((ResourceKey)Registry.f_122819_).listOf().fieldOf("dimensions").forGetter(SmallOre::dimensions), (App)Codec.STRING.listOf().optionalFieldOf("biomes", List.of()).forGetter(SmallOre::biomes), (App)Codec.BOOL.optionalFieldOf("biomeBlacklist", (Object)true).forGetter(SmallOre::biomeBlacklist)).apply((Applicative)instance, SmallOre::new));

    @Override
    public boolean isBiomeValid(Holder<Biome> biome) {
        if (this.biomes.isEmpty()) {
            return this.biomeBlacklist;
        }
        Predicate<String> predicate = s -> {
            if (s.contains("#")) {
                return biome.m_203656_(TagUtils.getBiomeTag(new ResourceLocation(s.replace("#", ""))));
            }
            return biome.m_203565_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(s)));
        };
        return this.biomeBlacklist ? this.biomes.stream().anyMatch(predicate) : this.biomes.stream().noneMatch(predicate);
    }

    @Override
    public ResourceLocation getLoc() {
        return this.id;
    }

    @Override
    public String getSubDirectory() {
        return "small_ores";
    }

    @Override
    public Codec<SmallOre> getCodec() {
        return CODEC;
    }

    @Override
    public List<ResourceKey<Level>> getDimensions() {
        return this.dimensions;
    }
}

