/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.tool.armor;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.tool.IGTArmor;
import org.gtreimagined.gtlib.tool.armor.MaterialArmor;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class GTArmorType
implements IGTObject {
    private final String domain;
    private final String id;
    private final List<Component> tooltip = new ObjectArrayList();
    private final boolean repairable;
    private final int durabilityFactor;
    private final int extraArmor;
    private final float extraToughness;
    private final float extraKnockback;
    private final CreativeModeTab itemGroup;
    private EquipmentSlot slot;
    private SoundEvent event;
    int overlayLayers;
    @Nullable
    private IMaterialTag materialRequirement;

    public GTArmorType(String domain, String id, int durabilityFactor, int extraArmor, float extraToughness, float extraKnockback, EquipmentSlot slot) {
        this.domain = domain;
        this.id = id;
        this.repairable = true;
        this.durabilityFactor = durabilityFactor;
        this.extraArmor = extraArmor;
        this.extraToughness = extraToughness;
        this.extraKnockback = extraKnockback;
        this.itemGroup = Ref.TAB_TOOLS;
        this.slot = slot;
        this.event = SoundEvents.f_11677_;
        this.overlayLayers = 0;
        GTAPI.register(GTArmorType.class, this);
    }

    public List<IGTArmor> instantiateTools() {
        ArrayList<IGTArmor> armors = new ArrayList<IGTArmor>();
        MaterialTags.ARMOR.all().forEach(m -> armors.add(new MaterialArmor(this.domain, this, (Material)m, this.slot, this.prepareInstantiation(this.domain))));
        return armors;
    }

    public List<IGTArmor> instantiateTools(String domain, Supplier<Item.Properties> properties) {
        ArrayList<IGTArmor> armors = new ArrayList<IGTArmor>();
        MaterialTags.ARMOR.all().forEach(m -> armors.add(new MaterialArmor(domain, this, (Material)m, this.slot, (Item.Properties)properties.get())));
        return armors;
    }

    private Item.Properties prepareInstantiation(String domain) {
        if (domain.isEmpty()) {
            Utils.onInvalidData("An GTArmorType was instantiated with an empty domain name!");
        }
        Item.Properties properties = new Item.Properties().m_41491_(this.itemGroup);
        if (!this.repairable) {
            properties.setNoRepair();
        }
        return properties;
    }

    public GTArmorType setOverlayLayers(int overlayLayers) {
        this.overlayLayers = overlayLayers;
        return this;
    }

    public GTArmorType setEvent(SoundEvent event) {
        this.event = event;
        return this;
    }

    public GTArmorType setArmorSlot(EquipmentSlot slot) {
        this.slot = slot;
        return this;
    }

    public GTArmorType setToolTip(Component ... tooltip) {
        this.tooltip.addAll(Arrays.asList(tooltip));
        return this;
    }

    public GTArmorType setPrimaryRequirement(IMaterialTag tag) {
        if (tag == null) {
            Utils.onInvalidData(StringUtils.capitalize((String)this.id) + " GTArmorType was set to have no primary material requirement even when it was explicitly called!");
        }
        this.materialRequirement = tag;
        return this;
    }

    public ItemStack getToolStack(Material primary) {
        IGTArmor armor = GTAPI.get(IGTArmor.class, primary.getId() + "_" + this.id, this.domain);
        return Objects.requireNonNull(armor).asItemStack();
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Generated
    public List<Component> getTooltip() {
        return this.tooltip;
    }

    @Generated
    public boolean isRepairable() {
        return this.repairable;
    }

    @Generated
    public int getDurabilityFactor() {
        return this.durabilityFactor;
    }

    @Generated
    public int getExtraArmor() {
        return this.extraArmor;
    }

    @Generated
    public float getExtraToughness() {
        return this.extraToughness;
    }

    @Generated
    public float getExtraKnockback() {
        return this.extraKnockback;
    }

    @Generated
    public CreativeModeTab getItemGroup() {
        return this.itemGroup;
    }

    @Generated
    public EquipmentSlot getSlot() {
        return this.slot;
    }

    @Generated
    public SoundEvent getEvent() {
        return this.event;
    }

    @Generated
    public int getOverlayLayers() {
        return this.overlayLayers;
    }
}

