/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.structure;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.structure.BlockInfo;
import org.gtreimagined.gtlib.structure.Pattern;
import org.gtreimagined.gtlib.util.Utils;

public class PatternBuilder {
    private List<String[]> slices = new ObjectArrayList();
    private Object2ObjectMap<String, BlockInfo> elementLookup = new Object2ObjectOpenHashMap();
    private Component description = Utils.translatable("", new Object[0]);
    private final Int2ObjectMap<List<Pattern.PonderTooltip>> ponderTooltipMap = new Int2ObjectOpenHashMap();
    float scale = 1.0f;

    public PatternBuilder of(String ... slices) {
        this.slices.add(slices);
        return this;
    }

    public PatternBuilder of(int i) {
        this.slices.add(this.slices.get(i));
        return this;
    }

    public PatternBuilder of(int i, String ... slices) {
        this.slices.set(i, slices);
        return this;
    }

    public PatternBuilder at(String key, BlockInfo value) {
        this.elementLookup.put((Object)key, (Object)value);
        return this;
    }

    public PatternBuilder at(String key, BlockState blockState) {
        return this.at(key, new BlockInfo(blockState));
    }

    public PatternBuilder at(String key, Machine<?> machine, Tier tier, Direction frontSide) {
        BlockMachine block = machine.getBlockState(tier);
        BlockState state = block.getType().isVerticalFacingAllowed() ? (BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)(frontSide.m_122434_() == Direction.Axis.Y ? frontSide : frontSide.m_122424_())) : (BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)frontSide);
        return this.at(key, new BlockInfo(state));
    }

    public PatternBuilder scale(float scale) {
        this.scale = scale;
        return this;
    }

    public PatternBuilder tip(int x, int y, int z, String tip) {
        ((List)this.ponderTooltipMap.computeIfAbsent(y, i -> new ArrayList())).add(new Pattern.PonderTooltip(x, z, tip));
        return this;
    }

    public PatternBuilder shallowCopy() {
        PatternBuilder builder = new PatternBuilder();
        builder.slices = new ObjectArrayList(this.slices);
        builder.elementLookup = new Object2ObjectOpenHashMap(this.elementLookup);
        builder.description = this.description;
        return builder;
    }

    public PatternBuilder description(String description) {
        return this.description((Component)Utils.translatable(description, new Object[0]));
    }

    public PatternBuilder description(Component description) {
        this.description = description;
        return this;
    }

    public Pattern build() {
        return new Pattern(this.bakeArray(), this.description, this.scale, this.ponderTooltipMap);
    }

    private BlockInfo[][][] bakeArray() {
        BlockInfo[][][] blockInfos = new BlockInfo[this.slices.size()][][];
        for (int i = 0; i < blockInfos.length; ++i) {
            String[] aisleEntry = this.slices.get(i);
            BlockInfo[][] aisleData = new BlockInfo[aisleEntry.length][];
            for (int j = 0; j < aisleData.length; ++j) {
                String columnEntry = aisleEntry[j];
                BlockInfo[] columnData = new BlockInfo[columnEntry.length()];
                for (int k = 0; k < columnData.length; ++k) {
                    columnData[k] = (BlockInfo)this.elementLookup.getOrDefault((Object)("" + columnEntry.charAt(k)), (Object)BlockInfo.EMPTY);
                }
                aisleData[j] = columnData;
            }
            blockInfos[i] = aisleData;
        }
        return blockInfos;
    }
}

