/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.recipe.container;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.gtreimagined.gtlib.recipe.BaseRecipeSerializer;

public class MirroredShapedRecipe
extends ShapedRecipe {
    public static final Serializer INSTANCE = new Serializer();
    private final boolean mirrored;

    public static void init() {
    }

    public MirroredShapedRecipe(ResourceLocation resourceLocation, String string, int i, int j, NonNullList<Ingredient> nonNullList, ItemStack itemStack, boolean mirrored) {
        super(resourceLocation, string, i, j, nonNullList, itemStack);
        this.mirrored = mirrored;
    }

    public RecipeSerializer<?> m_7707_() {
        return INSTANCE;
    }

    public boolean m_5818_(CraftingContainer inv, Level level) {
        for (int i = 0; i <= inv.m_39347_() - this.m_44220_(); ++i) {
            for (int j = 0; j <= inv.m_39346_() - this.m_44221_(); ++j) {
                if (this.m_44170_(inv, i, j, false)) {
                    return true;
                }
                if (!this.mirrored || !this.m_44170_(inv, i, j, true)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Serializer
    extends BaseRecipeSerializer<MirroredShapedRecipe> {
        public Serializer() {
            super("gtlib", "mirrored_shaped");
        }

        public MirroredShapedRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String string = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map map = ShapedRecipe.m_44210_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] strings = this.shrink(ShapedRecipe.m_44196_((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int i = strings[0].length();
            int j = strings.length;
            NonNullList nonNullList = ShapedRecipe.m_44202_((String[])strings, (Map)map, (int)i, (int)j);
            ItemStack itemStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            boolean mirrored = GsonHelper.m_13855_((JsonObject)json, (String)"mirrored", (boolean)false);
            return new MirroredShapedRecipe(recipeId, string, i, j, (NonNullList<Ingredient>)nonNullList, itemStack, mirrored);
        }

        String[] shrink(String ... toShrink) {
            int i = Integer.MAX_VALUE;
            int j = 0;
            int k = 0;
            int l = 0;
            for (int m = 0; m < toShrink.length; ++m) {
                String string = toShrink[m];
                i = Math.min(i, Serializer.firstNonSpace(string));
                int n = Serializer.lastNonSpace(string);
                j = Math.max(j, n);
                if (n < 0) {
                    if (k == m) {
                        ++k;
                    }
                    ++l;
                    continue;
                }
                l = 0;
            }
            if (toShrink.length == l) {
                return new String[0];
            }
            String[] strings = new String[toShrink.length - l - k];
            for (int o = 0; o < strings.length; ++o) {
                strings[o] = toShrink[o + k].substring(i, j + 1);
            }
            return strings;
        }

        private static int firstNonSpace(String entry) {
            int i;
            for (i = 0; i < entry.length() && entry.charAt(i) == ' '; ++i) {
            }
            return i;
        }

        private static int lastNonSpace(String entry) {
            int i;
            for (i = entry.length() - 1; i >= 0 && entry.charAt(i) == ' '; --i) {
            }
            return i;
        }

        public MirroredShapedRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            int j = buffer.m_130242_();
            String string = buffer.m_130277_();
            NonNullList nonNullList = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            nonNullList.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ItemStack itemStack = buffer.m_130267_();
            boolean mirrored = buffer.readBoolean();
            return new MirroredShapedRecipe(recipeId, string, i, j, (NonNullList<Ingredient>)nonNullList, itemStack, mirrored);
        }

        public void toNetwork(FriendlyByteBuf buffer, MirroredShapedRecipe recipe) {
            buffer.m_130130_(recipe.m_44220_());
            buffer.m_130130_(recipe.m_44221_());
            buffer.m_130070_(recipe.m_6076_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_());
            buffer.writeBoolean(recipe.mirrored);
        }
    }
}

