/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.pipe;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.GTLib;
import org.gtreimagined.gtlib.GTRemapping;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.block.GTItemBlock;
import org.gtreimagined.gtlib.blockentity.BlockEntityTickable;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.pipe.PipeCoverHandler;
import org.gtreimagined.gtlib.client.GTLibModelManager;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.cover.CoverReplacements;
import org.gtreimagined.gtlib.cover.ICover;
import org.gtreimagined.gtlib.cover.IHaveCover;
import org.gtreimagined.gtlib.data.GTLibMaterials;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.builder.GTBlockModelBuilder;
import org.gtreimagined.gtlib.datagen.builder.GTItemModelBuilder;
import org.gtreimagined.gtlib.datagen.builder.VariantBlockStateBuilder;
import org.gtreimagined.gtlib.datagen.providers.GTBlockStateProvider;
import org.gtreimagined.gtlib.datagen.providers.GTItemModelProvider;
import org.gtreimagined.gtlib.dynamic.BlockDynamic;
import org.gtreimagined.gtlib.dynamic.ModelConfig;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.IMaterialObject;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.pipe.PipeItemBlock;
import org.gtreimagined.gtlib.pipe.PipeShapeKey;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.PipeType;
import org.gtreimagined.gtlib.registration.IColorHandler;
import org.gtreimagined.gtlib.registration.IItemBlockProvider;
import org.gtreimagined.gtlib.registration.ISharedGTObject;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockPipe<T extends PipeType<T>>
extends BlockDynamic
implements IItemBlockProvider,
EntityBlock,
IColorHandler,
IMaterialObject,
SimpleWaterloggedBlock,
ISharedGTObject {
    protected T type;
    protected PipeSize size;
    protected final int modelId;
    protected Texture side;
    protected Texture overlay;
    protected Texture[] faces;
    protected static Map<PipeSize, Cache<Integer, VoxelShape>> pipeShapes = new Object2ObjectLinkedOpenHashMap();
    protected static Map<PipeSize, Cache<PipeShapeKey, VoxelShape>> shapes = new Object2ObjectLinkedOpenHashMap();
    public static final BooleanProperty TICKING = BooleanProperty.m_61465_((String)"ticking");

    public BlockPipe(String prefix, T type, PipeSize size, int modelId) {
        this(prefix, type, size, modelId, ((PipeType)type).getMaterial() == GTLibMaterials.Wood ? BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)net.minecraft.world.level.material.Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(1.0f, 3.0f) : BlockBehaviour.Properties.m_60939_((net.minecraft.world.level.material.Material)Data.WRENCH_MATERIAL).m_60913_(1.0f, 3.0f).m_60999_());
    }

    public BlockPipe(String prefix, T type, PipeSize size, int modelId, BlockBehaviour.Properties properties) {
        super(((PipeType)type).domain, prefix + "_" + size.getId(), size.ordinal() < 6 ? properties.m_60955_().m_60988_() : properties);
        pipeShapes.computeIfAbsent(size, s -> CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build());
        shapes.computeIfAbsent(size, s -> CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).maximumSize(1000L).build());
        this.type = type;
        this.size = size;
        this.side = new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_side");
        this.overlay = new Texture("gtlib", "block/empty");
        this.faces = new Texture[]{new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_vtiny"), new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_tiny"), new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_small"), new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_normal"), new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_large"), new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_huge"), new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_quadruple"), new Texture(((PipeType)type).getMaterial().getSet().getDomain(), ((PipeType)type).getMaterial().getSet().getPath() + "/pipe/pipe_nonuple")};
        GTAPI.register(BlockPipe.class, this);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TICKING, (Comparable)Boolean.valueOf(false)));
        this.modelId = modelId;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("covers")) {
            CompoundTag covers = stack.m_41783_().m_128469_("covers");
            if (!Screen.m_96638_()) {
                tooltip.add((Component)Utils.translatable("gtlib.tooltip.more", new Object[0]));
            } else {
                tooltip.add((Component)Utils.translatable("gtlib.tooltip.cover.covers_on_item", new Object[0]));
                byte sides = covers.m_128445_("vs");
                for (int i = 0; i < Ref.DIRS.length; ++i) {
                    Tier tier;
                    if ((sides & 1 << i) <= 0) continue;
                    Direction dir = Direction.m_122376_((int)i);
                    String domain = covers.m_128461_(dir.m_122411_() + "d");
                    String id = covers.m_128461_(dir.m_122411_() + "i");
                    ResourceLocation location = new ResourceLocation(domain, id);
                    if (GTRemapping.getCoverRemappingMap().containsKey(location)) {
                        location = GTRemapping.getCoverRemappingMap().get(location);
                    }
                    CoverFactory factory = GTAPI.get(CoverFactory.class, location);
                    Tier tier2 = tier = covers.m_128441_(dir.m_122411_() + "t") ? GTAPI.get(Tier.class, covers.m_128461_(dir.m_122411_() + "t")) : null;
                    if (factory == null) continue;
                    ItemStack item = factory.getItem(tier);
                    Component itemTip = item.m_41619_() ? Utils.translatable("cover." + domain + "." + id, new Object[0]) : item.m_41786_();
                    tooltip.add((Component)Utils.translatable("gtlib.tooltip.cover.stack", dir.m_122433_(), itemTip));
                }
            }
        }
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        List list = super.m_7381_(state, builder);
        BlockEntity tileentity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (tileentity instanceof BlockEntityPipe) {
            BlockEntityPipe pipe = (BlockEntityPipe)tileentity;
            if (!list.isEmpty()) {
                pipe.coverHandler.ifPresent(c -> c.writeToStack((ItemStack)list.get(0)));
            }
            pipe.addInventoryDrops(list);
        }
        return list;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_155947_() && state.m_60713_(newState.m_60734_()) && state.equals(newState.m_61124_((Property)TICKING, (Comparable)Boolean.valueOf((Boolean)newState.m_61143_((Property)TICKING) == false)))) {
            worldIn.m_46747_(pos);
        } else if (!state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public Cache<Integer, VoxelShape> getPipeShapes() {
        return pipeShapes.get(this.size);
    }

    protected Cache<PipeShapeKey, VoxelShape> getShapes() {
        return shapes.get(this.size);
    }

    public VoxelShape makeShapes(short which) {
        float offset = 0.0625f * (float)this.size.ordinal();
        VoxelShape shape = Shapes.m_83064_((AABB)this.size.getAABB());
        if ((which & 1) > 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)(0.4375 - (double)offset), (double)0.0, (double)(0.4375 - (double)offset), (double)(0.5625 + (double)offset), (double)(0.4375 - (double)offset), (double)(0.5625 + (double)offset)));
        }
        if ((which & 2) > 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)(0.4375 - (double)offset), (double)(0.5625 + (double)offset), (double)(0.4375 - (double)offset), (double)(0.5625 + (double)offset), (double)1.0, (double)(0.5625 + (double)offset)));
        }
        if ((which & 4) > 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)(0.4375 - (double)offset), (double)(0.4375 - (double)offset), (double)0.0, (double)(0.5625 + (double)offset), (double)(0.5625 + (double)offset), (double)(0.4375 - (double)offset)));
        }
        if ((which & 8) > 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)(0.4375 - (double)offset), (double)(0.4375 - (double)offset), (double)(0.5625 + (double)offset), (double)(0.5625 + (double)offset), (double)(0.5625 + (double)offset), (double)1.0));
        }
        if ((which & 0x10) > 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)(0.4375 - (double)offset), (double)(0.4375 - (double)offset), (double)(0.4375 - (double)offset), (double)(0.5625 + (double)offset), (double)(0.5625 + (double)offset)));
        }
        if ((which & 0x20) > 0) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)(0.5625 + (double)offset), (double)(0.4375 - (double)offset), (double)(0.4375 - (double)offset), (double)1.0, (double)(0.5625 + (double)offset), (double)(0.5625 + (double)offset)));
        }
        return shape;
    }

    public int getRGB() {
        return ((PipeType)this.type).getMaterial().getRGB();
    }

    public Texture getFace() {
        return this.faces[this.size.ordinal()];
    }

    @Override
    public GTItemBlock getItemBlock() {
        return new PipeItemBlock(this);
    }

    public GTToolType getToolType() {
        return GTTools.WRENCH;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntityPipe<?> tile = BlockPipe.getTilePipe((BlockGetter)worldIn, pos);
        if (tile != null && !worldIn.m_5776_()) {
            tile.coverHandler.ifPresent(c -> c.readFromStack(stack));
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_("co")) {
                tile.setPipeColor(stack.m_41783_().m_128451_("co"));
            }
            for (Direction side : Ref.DIRS) {
                BlockEntityPipe<?> neighbour = tile.getPipe(side);
                if (neighbour == null || !neighbour.connects(side.m_122424_()) || neighbour.blocksSide(side.m_122424_()) || tile.blocksSide(side)) continue;
                tile.setConnection(side);
            }
        }
    }

    public boolean onBlockPlacedTo(Level world, BlockPos pos, Direction face) {
        BlockEntityPipe<?> tile = BlockPipe.getTilePipe((BlockGetter)world, pos);
        if (tile != null && !world.m_5776_()) {
            if (!world.m_8055_(pos.m_142300_(face.m_122424_())).m_155947_()) {
                return false;
            }
            BlockEntityPipe<?> side = tile.getPipe(face.m_122424_());
            if (side != null && side.blocksSide(face)) {
                return false;
            }
            tile.setConnection(face.m_122424_());
            return true;
        }
        return false;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntityPipe tile;
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (!worldIn.f_46443_ && (tile = (BlockEntityPipe)worldIn.m_7702_(pos)) != null) {
            tile.onBlockUpdate(fromPos);
        }
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        BlockEntityPipe tile;
        if (!world.m_5776_() && (tile = (BlockEntityPipe)world.m_7702_(pos)) != null) {
            tile.onBlockUpdate(neighbor);
        }
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity entity = blockAccess.m_7702_(pos);
        if (entity instanceof BlockEntityPipe) {
            BlockEntityPipe pipe = (BlockEntityPipe)entity;
            return pipe.getWeakRedstonePower(side == null ? null : side.m_122424_());
        }
        return super.m_6378_(blockState, blockAccess, pos, side);
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity entity = blockAccess.m_7702_(pos);
        if (entity instanceof BlockEntityPipe) {
            BlockEntityPipe pipe = (BlockEntityPipe)entity;
            return pipe.getStrongRedstonePower(side == null ? null : side.m_122424_());
        }
        return super.m_6376_(blockState, blockAccess, pos, side);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        this.onNeighborChange(stateIn, (LevelReader)worldIn, currentPos, facingPos);
        return stateIn;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntityPipe tile = (BlockEntityPipe)world.m_7702_(pos);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        if (!world.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            GTToolType type;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() instanceof IHaveCover) {
                factory = ((IHaveCover)stack.m_41720_()).getCover();
                dir = Utils.getInteractSide(hit);
                ok = tile.getCoverHandler().map(i -> i.placeCover(player, Utils.getInteractSide(hit), stack, factory.get().get((ICoverHandler<?>)i, ((IHaveCover)stack.m_41720_()).getTier(), dir, factory))).orElse(false);
                if (ok) {
                    return InteractionResult.SUCCESS;
                }
            } else if (CoverReplacements.hasReplacement(stack.m_41720_())) {
                factory = CoverReplacements.getReplacement(stack.m_41720_());
                dir = Utils.getInteractSide(hit);
                ok = tile.getCoverHandler().map(i -> i.placeCover(player, Utils.getInteractSide(hit), stack, factory.get().get((ICoverHandler<?>)i, null, dir, factory))).orElse(false);
                if (ok) {
                    return InteractionResult.SUCCESS;
                }
            }
            if ((type = Utils.getToolType(player)) == GTTools.CROWBAR) {
                if (!player.m_6047_()) {
                    if (tile.getCoverHandler().map(h -> h.removeCover(player, Utils.getInteractSide(hit), false)).orElse(false).booleanValue()) {
                        Utils.damageStack(stack, hand, (LivingEntity)player);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
                if (tile.getCoverHandler().map(h -> h.moveCover(player, hit.m_82434_(), Utils.getInteractSide(hit))).orElse(false).booleanValue()) {
                    Utils.damageStack(stack, (LivingEntity)player);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            InteractionResult coverInteract = tile.getCoverHandler().map(h -> h.onInteract(player, hand, Utils.getInteractSide(hit), type)).orElse(InteractionResult.PASS);
            if (coverInteract != InteractionResult.PASS) {
                return coverInteract;
            }
            if (type == null) {
                return InteractionResult.PASS;
            }
            if (type == GTTools.SCREWDRIVER) {
                ICover instance = tile.getCoverHandler().map(h -> h.get(Utils.getInteractSide(hit))).orElse(ICover.empty);
                if (!player.m_6047_()) {
                    if (!instance.isEmpty() && instance.openGui(player, Utils.getInteractSide(hit))) {
                        Utils.damageStack(stack, hand, (LivingEntity)player);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
            }
            if (this.getToolType().equals(type)) {
                Direction side = Utils.getInteractSide(hit);
                if (tile.blocksSide(side) || tile.getPipe(side) != null && tile.getPipe(side).blocksSide(side.m_122424_())) {
                    return InteractionResult.CONSUME;
                }
                tile.toggleConnection(side);
                Utils.damageStack(stack, hand, (LivingEntity)player);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntityPipe<?> tile;
        EntityCollisionContext cont;
        Entity entity;
        if (this.size.ordinal() > 5) {
            return Shapes.m_83144_();
        }
        if (context instanceof EntityCollisionContext && (entity = (cont = (EntityCollisionContext)context).m_193113_()) instanceof Player) {
            Player player = (Player)entity;
            if (Utils.isPlayerHolding(player, InteractionHand.MAIN_HAND, this.getToolType(), GTTools.CROWBAR, GTTools.SCREWDRIVER)) {
                return Shapes.m_83144_();
            }
            if (!player.m_21205_().m_41619_() && (player.m_21205_().m_41720_() instanceof IHaveCover || CoverReplacements.hasReplacement(player.m_21205_().m_41720_()))) {
                return Shapes.m_83144_();
            }
        }
        if ((tile = BlockPipe.getTilePipe(world, pos)) == null) {
            return Shapes.m_83144_();
        }
        VoxelShape shape = null;
        try {
            shape = this.getOrCreateShape(tile);
        }
        catch (ExecutionException e) {
            GTLib.LOGGER.error((Object)e);
        }
        return shape != null ? shape : Shapes.m_83144_();
    }

    public int getPipeID(int config, int cull) {
        return (this.size.ordinal() + 1) * 100 + (this.getModelId() + 1) * 1000 + (cull == 0 ? 0 : 10000) + config;
    }

    @Nullable
    protected static BlockEntityPipe<?> getTilePipe(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        return tile instanceof BlockEntityPipe ? (BlockEntityPipe)tile : null;
    }

    public VoxelShape getOrCreateShape(BlockEntityPipe<?> tile) throws ExecutionException {
        int config = this.getShapeConfig(tile);
        String[] coverIds = new String[6];
        ICover[] covers = new ICover[6];
        boolean allEmpty = true;
        if (tile.coverHandler.isPresent()) {
            PipeCoverHandler<?> coverHandler = tile.coverHandler.get();
            for (Direction s : Direction.values()) {
                ICover cover;
                covers[s.m_122411_()] = cover = coverHandler.get(s);
                if (cover.isEmpty()) {
                    coverIds[s.m_122411_()] = "";
                    continue;
                }
                coverIds[s.m_122411_()] = cover.getIdForCache().toString();
                allEmpty = false;
            }
        }
        if (allEmpty) {
            return (VoxelShape)this.getPipeShapes().get((Object)config, () -> this.makeShapes((short)config));
        }
        PipeShapeKey key = new PipeShapeKey(config, coverIds[0], coverIds[1], coverIds[2], coverIds[3], coverIds[4], coverIds[5]);
        return (VoxelShape)this.getShapes().get((Object)key, () -> {
            VoxelShape core = (VoxelShape)this.getPipeShapes().get((Object)config, () -> this.makeShapes((short)config));
            for (ICover cover : covers) {
                if (cover.isEmpty()) continue;
                core = Shapes.m_83110_((VoxelShape)core, (VoxelShape)cover.getShape(cover.side()));
            }
            return core;
        });
    }

    public int getShapeConfig(BlockEntityPipe<?> tile) {
        int ct = 0;
        if (tile != null) {
            for (int s = 0; s < 6; ++s) {
                if (!tile.canConnect(s)) continue;
                ct += 1 << s;
            }
        }
        return ct;
    }

    @Override
    public ModelConfig getConfig(BlockState state, BlockGetter world, BlockPos.MutableBlockPos mut, BlockPos pos) {
        int ct = 0;
        BlockEntityPipe<?> tile = BlockPipe.getTilePipe(world, pos);
        if (tile != null) {
            ct = this.getShapeConfig(tile);
        }
        return this.config.set(pos, new int[]{this.getPipeID(ct, 0)});
    }

    @Override
    public int getBlockColor(BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, int i) {
        BlockEntityPipe<?> pipe = BlockPipe.getTilePipe(world, pos);
        if (pipe != null && pipe.getPipeColor() != -1) {
            return pipe.getPipeColor();
        }
        return this.getRGB();
    }

    @Override
    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("co")) {
            return stack.m_41783_().m_128451_("co");
        }
        return this.getRGB();
    }

    @Override
    public void onItemModelBuild(ItemLike item, GTItemModelProvider prov) {
        if (this.size.ordinal() > 5) {
            ((GTItemModelBuilder)((GTItemModelBuilder)prov.getBuilder(item).parent(new ResourceLocation(GTBlockModelBuilder.SIMPLE))).texture("all", this.getSide())).texture("north", this.getFace());
        } else {
            ((GTItemModelBuilder)((GTItemModelBuilder)prov.getBuilder(item).parent(prov.existing("gtlib", "block/pipe/" + this.getSize().getId() + "/line_inv"))).texture("all", this.getSide())).texture("overlay", this.getFace());
        }
    }

    @Override
    public void onBlockModelBuild(Block block, GTBlockStateProvider prov) {
        prov.getVariantBuilder(block).forAllStates(s -> new VariantBlockStateBuilder.VariantBuilder().modelFile(this.getPipeConfig(prov.getBuilder(block))).uvLock());
    }

    public String getModelLoc(String shape, int cull) {
        return "gtlib:block/pipe/" + this.getSize().getId() + "/" + shape + (cull == 0 ? "" : (shape.equals("base") ? "" : "_culled"));
    }

    public GTBlockModelBuilder getPipeConfig(GTBlockModelBuilder builder) {
        if (this.size.ordinal() > 5) {
            return this.getPipeConfigForFullBlock(builder);
        }
        builder.model(this.getModelLoc("base", 0), (ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace())));
        builder.staticConfigId("pipe");
        builder.particle(this.getFace());
        builder.config(this.getPipeID(0, 0), this.getModelLoc("base", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(1, 0), this.getModelLoc("single", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(-90, 0, 0));
        builder.config(this.getPipeID(2, 0), this.getModelLoc("single", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(4, 0), this.getModelLoc("single", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(8, 0), this.getModelLoc("single", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 180, 0));
        builder.config(this.getPipeID(16, 0), this.getModelLoc("single", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(32, 0), this.getModelLoc("single", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -90, 0));
        builder.config(this.getPipeID(3, 0), this.getModelLoc("line", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(12, 0), this.getModelLoc("line", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(48, 0), this.getModelLoc("line", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(5, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, -90));
        builder.config(this.getPipeID(6, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, 90));
        builder.config(this.getPipeID(9, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 180, -90));
        builder.config(this.getPipeID(10, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 180, 90));
        builder.config(this.getPipeID(17, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 180, 0));
        builder.config(this.getPipeID(18, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(-90, 180, 0));
        builder.config(this.getPipeID(20, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(24, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -180, 0));
        builder.config(this.getPipeID(33, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(-90, 0, 0));
        builder.config(this.getPipeID(34, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(36, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(40, 0), this.getModelLoc("elbow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -90, 0));
        builder.config(this.getPipeID(7, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(-90, 0, 0));
        builder.config(this.getPipeID(11, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(13, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, 180));
        builder.config(this.getPipeID(14, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(19, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, 90));
        builder.config(this.getPipeID(28, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, 90));
        builder.config(this.getPipeID(35, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, -90));
        builder.config(this.getPipeID(44, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, -90));
        builder.config(this.getPipeID(49, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 180));
        builder.config(this.getPipeID(50, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(52, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, -90));
        builder.config(this.getPipeID(56, 0), this.getModelLoc("side", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 90));
        builder.config(this.getPipeID(21, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, 180));
        builder.config(this.getPipeID(22, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(25, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -270, 180));
        builder.config(this.getPipeID(26, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 180, 0));
        builder.config(this.getPipeID(41, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -180, 180));
        builder.config(this.getPipeID(42, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -90, 0));
        builder.config(this.getPipeID(37, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -90, 180));
        builder.config(this.getPipeID(38, 0), this.getModelLoc("corner", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(23, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, 90));
        builder.config(this.getPipeID(27, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -270, 90));
        builder.config(this.getPipeID(29, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 180));
        builder.config(this.getPipeID(30, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(39, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -90, 90));
        builder.config(this.getPipeID(43, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -180, 90));
        builder.config(this.getPipeID(45, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -90, 180));
        builder.config(this.getPipeID(46, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, -90, 0));
        builder.config(this.getPipeID(53, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(180, 180, 0));
        builder.config(this.getPipeID(54, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(57, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(180, 0, 0));
        builder.config(this.getPipeID(58, 0), this.getModelLoc("arrow", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 180, 0));
        builder.config(this.getPipeID(15, 0), this.getModelLoc("cross", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, 90));
        builder.config(this.getPipeID(51, 0), this.getModelLoc("cross", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(60, 0), this.getModelLoc("cross", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(31, 0), this.getModelLoc("five", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, 90));
        builder.config(this.getPipeID(47, 0), this.getModelLoc("five", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(0, 0, -90));
        builder.config(this.getPipeID(55, 0), this.getModelLoc("five", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(-90, 0, 0));
        builder.config(this.getPipeID(59, 0), this.getModelLoc("five", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(61, 0), this.getModelLoc("five", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))).rot(180, 0, 0));
        builder.config(this.getPipeID(62, 0), this.getModelLoc("five", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(63, 0), this.getModelLoc("all", 0), c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"overlay", (Object)((Object)this.getFace()))));
        return (GTBlockModelBuilder)builder.loader(GTLibModelManager.LOADER_PIPE);
    }

    public GTBlockModelBuilder getPipeConfigForFullBlock(GTBlockModelBuilder builder) {
        builder.model(GTBlockModelBuilder.SIMPLE, (ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace())));
        builder.staticConfigId("pipe");
        builder.particle(this.getFace());
        builder.config(this.getPipeID(0, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(1, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()))).rot(-90, 0, 0));
        builder.config(this.getPipeID(2, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(4, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(8, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()))).rot(0, 180, 0));
        builder.config(this.getPipeID(16, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(32, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()))).rot(0, -90, 0));
        builder.config(this.getPipeID(3, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(12, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(48, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(5, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()))).rot(0, 0, -90));
        builder.config(this.getPipeID(6, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()))).rot(0, 0, 90));
        builder.config(this.getPipeID(9, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()))).rot(0, 180, -90));
        builder.config(this.getPipeID(10, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()))).rot(0, 180, 90));
        builder.config(this.getPipeID(17, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()))).rot(90, 180, 0));
        builder.config(this.getPipeID(18, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()))).rot(-90, 180, 0));
        builder.config(this.getPipeID(20, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(24, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()))).rot(0, -180, 0));
        builder.config(this.getPipeID(33, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()))).rot(-90, 0, 0));
        builder.config(this.getPipeID(34, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(36, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(40, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()))).rot(0, -90, 0));
        builder.config(this.getPipeID(7, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(-90, 0, 0));
        builder.config(this.getPipeID(11, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(90, 0, 0));
        builder.config(this.getPipeID(13, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(0, 0, 180));
        builder.config(this.getPipeID(14, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(19, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(90, 0, 90));
        builder.config(this.getPipeID(28, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(0, 0, 90));
        builder.config(this.getPipeID(35, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(90, 0, -90));
        builder.config(this.getPipeID(44, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(0, 0, -90));
        builder.config(this.getPipeID(49, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(0, 90, 180));
        builder.config(this.getPipeID(50, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(52, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(0, 90, -90));
        builder.config(this.getPipeID(56, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(0, 90, 90));
        builder.config(this.getPipeID(21, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(0, 0, 180));
        builder.config(this.getPipeID(22, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(0, 90, 0));
        builder.config(this.getPipeID(25, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(0, -270, 180));
        builder.config(this.getPipeID(26, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(0, 180, 0));
        builder.config(this.getPipeID(41, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(0, -180, 180));
        builder.config(this.getPipeID(42, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(0, -90, 0));
        builder.config(this.getPipeID(37, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))).rot(0, -90, 180));
        builder.config(this.getPipeID(38, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getSide()), (Object)"north", (Object)((Object)this.getFace()), (Object)"east", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getFace()))));
        builder.config(this.getPipeID(23, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getSide()), (Object)"down", (Object)((Object)this.getSide()))).rot(0, 0, 90));
        builder.config(this.getPipeID(27, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getSide()), (Object)"down", (Object)((Object)this.getSide()))).rot(0, -270, 90));
        builder.config(this.getPipeID(29, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getSide()), (Object)"down", (Object)((Object)this.getSide()))).rot(0, 90, 180));
        builder.config(this.getPipeID(30, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getSide()), (Object)"down", (Object)((Object)this.getSide()))).rot(0, 90, 0));
        builder.config(this.getPipeID(39, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getSide()), (Object)"down", (Object)((Object)this.getSide()))).rot(0, -90, 90));
        builder.config(this.getPipeID(43, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getSide()), (Object)"down", (Object)((Object)this.getSide()))).rot(0, -180, 90));
        builder.config(this.getPipeID(45, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getSide()), (Object)"down", (Object)((Object)this.getSide()))).rot(0, -90, 180));
        builder.config(this.getPipeID(46, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getSide()), (Object)"down", (Object)((Object)this.getSide()))).rot(0, -90, 0));
        builder.config(this.getPipeID(53, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getSide()), (Object)"down", (Object)((Object)this.getSide()))).rot(180, 180, 0));
        builder.config(this.getPipeID(54, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getSide()), (Object)"down", (Object)((Object)this.getSide()))));
        builder.config(this.getPipeID(57, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getSide()), (Object)"down", (Object)((Object)this.getSide()))).rot(180, 0, 0));
        builder.config(this.getPipeID(58, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"south", (Object)((Object)this.getSide()), (Object)"down", (Object)((Object)this.getSide()))).rot(0, 180, 0));
        builder.config(this.getPipeID(15, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getSide()), (Object)"down", (Object)((Object)this.getSide()))).rot(0, 0, 90));
        builder.config(this.getPipeID(51, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getSide()), (Object)"down", (Object)((Object)this.getSide()))).rot(90, 0, 0));
        builder.config(this.getPipeID(60, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"up", (Object)((Object)this.getSide()), (Object)"down", (Object)((Object)this.getSide()))));
        builder.config(this.getPipeID(31, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"down", (Object)((Object)this.getSide()))).rot(0, 0, 90));
        builder.config(this.getPipeID(47, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"down", (Object)((Object)this.getSide()))).rot(0, 0, -90));
        builder.config(this.getPipeID(55, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"down", (Object)((Object)this.getSide()))).rot(-90, 0, 0));
        builder.config(this.getPipeID(59, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"down", (Object)((Object)this.getSide()))).rot(90, 0, 0));
        builder.config(this.getPipeID(61, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"down", (Object)((Object)this.getSide()))).rot(180, 0, 0));
        builder.config(this.getPipeID(62, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()), (Object)"down", (Object)((Object)this.getSide()))));
        builder.config(this.getPipeID(63, 0), GTBlockModelBuilder.SIMPLE, c -> c.tex((ImmutableMap<String, Texture>)ImmutableMap.of((Object)"all", (Object)((Object)this.getFace()))));
        return (GTBlockModelBuilder)builder.loader(GTLibModelManager.LOADER_PIPE);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        builder.m_61104_(new Property[]{TICKING});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)super.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((PipeType)this.type).getTileType().m_155264_(pos, state);
    }

    @Nullable
    public <TILE extends BlockEntity> BlockEntityTicker<TILE> m_142354_(Level level, BlockState state, BlockEntityType<TILE> type) {
        if (((Boolean)state.m_61143_((Property)TICKING)).booleanValue() && !level.m_5776_()) {
            return BlockEntityTickable::commonTick;
        }
        return null;
    }

    @Override
    public Material getMaterial() {
        return ((PipeType)this.type).getMaterial();
    }

    @Generated
    public T getType() {
        return this.type;
    }

    @Generated
    public PipeSize getSize() {
        return this.size;
    }

    @Generated
    public int getModelId() {
        return this.modelId;
    }

    @Generated
    public Texture getSide() {
        return this.side;
    }
}

