/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.network.packets;

import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.container.GTContainer;
import org.gtreimagined.gtlib.gui.container.IGTContainer;
import org.gtreimagined.gtlib.network.GTLibNetwork;
import org.gtreimagined.gtlib.network.packets.GuiSyncPacket;

public class ClientboundGuiSyncPacket
extends GuiSyncPacket<ClientboundGuiSyncPacket> {
    public static final PacketHandler<ClientboundGuiSyncPacket> HANDLER = new ClientHandler();

    public ClientboundGuiSyncPacket(List<GuiInstance.SyncHolder> data) {
        super(data);
    }

    public ClientboundGuiSyncPacket(ByteBuf data) {
        super(data);
    }

    public ResourceLocation getID() {
        return GTLibNetwork.GUI_SYNC_PACKET_ID;
    }

    public PacketHandler<ClientboundGuiSyncPacket> getHandler() {
        return HANDLER;
    }

    private static class ClientHandler
    implements PacketHandler<ClientboundGuiSyncPacket> {
        private ClientHandler() {
        }

        public void encode(ClientboundGuiSyncPacket msg, FriendlyByteBuf buf) {
            buf.m_130130_(msg.data.length);
            for (GuiInstance.SyncHolder data : msg.data) {
                buf.m_130130_(data.index);
                data.writer.accept(buf, data.current);
            }
        }

        public ClientboundGuiSyncPacket decode(FriendlyByteBuf buf) {
            return new ClientboundGuiSyncPacket(buf.copy());
        }

        public PacketContext handle(ClientboundGuiSyncPacket msg) {
            return (sender, level) -> {
                AbstractContainerMenu c = Minecraft.m_91087_().f_91074_.f_36096_;
                if (c instanceof IGTContainer) {
                    ((GTContainer)c).handler.receivePacket(msg, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
                }
            };
        }
    }
}

