/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.kubejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.mods.kubejs.item.ingredient.TagIngredientJS;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.crafting.Ingredient;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.jetbrains.annotations.Nullable;

public class RecipeIngredientJS
extends IngredientStackJS {
    protected boolean nonConsume = false;
    protected boolean ignoreNbt = false;

    public RecipeIngredientJS(IngredientJS i, int c) {
        super(i, c);
    }

    public RecipeIngredientJS setNoConsume(boolean noConsume) {
        this.nonConsume = noConsume;
        return this;
    }

    public boolean ignoreConsume() {
        return this.nonConsume;
    }

    public RecipeIngredientJS setIgnoreNbt(boolean ignoreNbt) {
        this.ignoreNbt = ignoreNbt;
        return this;
    }

    public boolean ignoreNbt() {
        return this.ignoreNbt;
    }

    private static IngredientJS fromValue(Ingredient.Value value) {
        if (value instanceof RecipeIngredient.RecipeValue) {
            RecipeIngredient.RecipeValue v = (RecipeIngredient.RecipeValue)value;
            if (v.getTag() != null) {
                TagIngredientJS in = TagIngredientJS.createTag((String)v.getTag().f_203868_().toString());
                if (v.getCount() > 1) {
                    in = new IngredientStackJS((IngredientJS)in, v.getCount());
                }
                return in;
            }
            return IngredientJS.of(v.m_6223_());
        }
        if (value instanceof RecipeIngredient.MultiValue) {
            RecipeIngredient.MultiValue v = (RecipeIngredient.MultiValue)value;
            ArrayList<IngredientJS> js = new ArrayList<IngredientJS>();
            for (Ingredient.Value v2 : v.getValues()) {
                js.add(RecipeIngredientJS.fromValue(v2));
            }
            return IngredientJS.of(js);
        }
        return null;
    }

    public static RecipeIngredientJS fromJson(@Nullable JsonElement json) {
        List<Ingredient.Value> values = RecipeIngredient.valuesFromJson(json).toList();
        ArrayList<IngredientJS> js = new ArrayList<IngredientJS>();
        for (Ingredient.Value v2 : values) {
            js.add(RecipeIngredientJS.fromValue(v2));
        }
        int count = 1;
        boolean ignoreNBt = false;
        boolean noConsume = false;
        if (json instanceof JsonObject) {
            JsonObject object = (JsonObject)json;
            if (object.has("count")) {
                count = object.get("count").getAsInt();
            }
            if (object.has("ignoreNBT") && object.get("ignoreNBT").getAsBoolean()) {
                ignoreNBt = true;
            }
            if (object.has("noconsume") && object.get("noconsume").getAsBoolean()) {
                noConsume = true;
            }
        }
        return new RecipeIngredientJS(IngredientJS.of(js.size() == 1 ? js.get(0) : js), count).setIgnoreNbt(ignoreNBt).setNoConsume(noConsume);
    }

    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        JsonElement element = super.toJson();
        if (element instanceof JsonObject) {
            JsonObject o;
            object = o = (JsonObject)element;
        } else if (element instanceof JsonArray) {
            object.add("values", element);
        }
        object.addProperty("ignoreNBT", Boolean.valueOf(this.ignoreNbt));
        object.addProperty("noconsume", Boolean.valueOf(this.nonConsume));
        return object;
    }
}

