/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.integration.jei.category;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Set;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gtlib.Data;
import org.gtreimagined.gtlib.integration.jei.category.MultiMachineInfoPage;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;

public class MultiMachineInfoCategory
implements IRecipeCategory<MultiMachineInfoPage> {
    private static IGuiHelper guiHelper;
    private final IDrawable background = guiHelper.createBlankDrawable(176, 150);
    private final IDrawable icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)Data.DEBUG_SCANNER, 1));
    private static final ResourceLocation UID;
    private static final Set<MultiMachineInfoPage> MULTI_MACHINES_PAGES;

    public static void setGuiHelper(IGuiHelper guiHelper) {
        MultiMachineInfoCategory.guiHelper = guiHelper;
    }

    public static void addMultiMachine(MultiMachineInfoPage page) {
        MULTI_MACHINES_PAGES.add(page);
    }

    public static void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(MULTI_MACHINES_PAGES, UID);
    }

    public boolean handleClick(@NotNull MultiMachineInfoPage recipe, double mouseX, double mouseY, int mouseButton) {
        return recipe.handleClick(mouseX, mouseY, mouseButton);
    }

    public void draw(@NotNull MultiMachineInfoPage recipe, @NotNull PoseStack matrixStack, double mouseX, double mouseY) {
        recipe.drawInfo(matrixStack, (int)mouseX, (int)mouseY);
    }

    @NotNull
    public ResourceLocation getUid() {
        return UID;
    }

    @NotNull
    public Class<? extends MultiMachineInfoPage> getRecipeClass() {
        return MultiMachineInfoPage.class;
    }

    @NotNull
    public Component getTitle() {
        return Utils.literal("Multi Machines Title");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@NotNull MultiMachineInfoPage recipe, @NotNull IIngredients ingredients) {
        recipe.setIngredients(ingredients);
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull MultiMachineInfoPage recipe, double mouseX, double mouseY) {
        return recipe.getTooltipStrings(mouseX, mouseY);
    }

    public void setRecipe(@NotNull IRecipeLayout recipeLayout, @NotNull MultiMachineInfoPage recipe, @NotNull IIngredients ingredients) {
        recipe.setRecipeLayout(recipeLayout, guiHelper);
    }

    static {
        UID = new ResourceLocation("antimatter_shared", "multi_machine_info");
        MULTI_MACHINES_PAGES = Sets.newHashSet();
    }
}

