/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.Widget;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBoxWidget
extends Widget {
    EditBox textBox;
    BiConsumer<IGuiHandler, String> consumer;
    Function<IGuiHandler, String> function;
    boolean initialized = false;

    protected TextBoxWidget(@NotNull GuiInstance gui, @Nullable IGuiElement parent, BiConsumer<IGuiHandler, String> consumer, Function<IGuiHandler, String> function) {
        super(gui, parent);
        this.consumer = consumer;
        this.function = function;
    }

    public static WidgetSupplier build(BiConsumer<IGuiHandler, String> consumer, Function<IGuiHandler, String> function) {
        return TextBoxWidget.builder((i, p) -> new TextBoxWidget((GuiInstance)i, (IGuiElement)p, consumer, function));
    }

    @Override
    public void render(PoseStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        this.textBox.m_6305_(matrixStack, (int)mouseX, (int)mouseY, partialTicks);
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        if (this.isInside(mouseX, mouseY)) {
            if (button == 0 && !this.textBox.m_93696_()) {
                this.textBox.m_94178_(true);
            } else if (button == 1 && this.textBox.m_93696_()) {
                this.textBox.m_94178_(false);
            }
        }
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers, double mouseX, double mouseY) {
        if (this.textBox.m_93696_()) {
            return this.textBox.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers, mouseX, mouseY);
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers, double mouseX, double mouseY) {
        if (this.textBox.m_93696_()) {
            return this.textBox.m_7920_(keyCode, scanCode, modifiers);
        }
        return super.keyReleased(keyCode, scanCode, modifiers, mouseX, mouseY);
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers, double mouseX, double mouseY) {
        if (this.textBox.m_93696_()) {
            return this.textBox.m_5534_(codePoint, modifiers);
        }
        return super.charTyped(codePoint, modifiers, mouseX, mouseY);
    }

    @Override
    public void updateSize() {
        super.updateSize();
        if (this.gui.isRemote && this.textBox != null) {
            this.textBox.f_93620_ = this.realX();
            this.textBox.f_93621_ = this.realY();
        }
    }

    @Override
    public void init() {
        super.init();
        this.gui.syncString(() -> this.function.apply(this.gui.handler), this::setValue, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        this.gui.syncString(() -> this.textBox.m_94155_(), s -> this.consumer.accept(this.gui.handler, (String)s), ICanSyncData.SyncDirection.CLIENT_TO_SERVER);
        if (this.gui.isRemote) {
            this.initTextBox();
        } else {
            this.gui.update();
        }
    }

    private void setValue(String value) {
        if (!this.initialized) {
            this.textBox.m_94144_(value);
            this.initialized = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void initTextBox() {
        this.textBox = new EditBox(Minecraft.m_91087_().f_91062_, this.realX(), this.realY(), this.getW(), this.getH(), (Component)Utils.literal(""));
        this.textBox.m_94199_(32500);
    }
}

