/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.gui.container;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.capability.machine.MachineItemHandler;
import org.gtreimagined.gtlib.gui.MenuHandlerMachine;
import org.gtreimagined.gtlib.gui.SlotData;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.container.GTContainer;
import org.gtreimagined.gtlib.gui.slot.AbstractSlot;

public abstract class ContainerMachine<T extends BlockEntityMachine<T>>
extends GTContainer {
    protected final T tile;
    public final Map<SlotType<?>, List<Slot>> slotMap = new Object2ObjectOpenHashMap();

    public ContainerMachine(T tile, Inventory playerInv, MenuHandlerMachine<T, ContainerMachine<T>> menuHandler, int windowId) {
        super((IGuiHandler)tile, menuHandler.getContainerType(), windowId, playerInv, ((BlockEntityMachine)tile).getMachineType().getSlots(((BlockEntityMachine)tile).getMachineTier()).size());
        this.tile = tile;
        this.addSlots((BlockEntityMachine<?>)tile);
        if (((BlockEntityMachine)tile).getMachineType().getGuiData().enablePlayerSlots()) {
            this.addPlayerSlots();
        }
        ((BlockEntityMachine)tile).addOpenContainer(this, playerInv.f_35978_);
    }

    @Override
    protected int getXPlayerOffset() {
        return ((BlockEntityMachine)this.tile).getMachineType().getGuiData().getPlayerXOffset();
    }

    @Override
    protected int getYPlayerOffset() {
        return ((BlockEntityMachine)this.tile).getMachineType().getGuiData().getPlayerYOffset();
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        ((BlockEntityMachine)this.tile).onContainerClose(this, playerIn);
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
    }

    protected void addSlots(BlockEntityMachine<?> tile) {
        Object2IntOpenHashMap slotIndexMap = new Object2IntOpenHashMap();
        for (SlotData<?> slot : tile.getMachineType().getSlots(tile.getMachineTier())) {
            slotIndexMap.computeIntIfAbsent((Object)slot.getType().getId(), k -> 0);
            Object supplier = slot.getType().getSlotSupplier().get(slot.getType(), tile, tile.itemHandler.map(MachineItemHandler::getAll).orElse(null), slotIndexMap.getInt((Object)slot.getType().getId()), slot);
            this.m_38897_((Slot)supplier);
            slotIndexMap.computeInt((Object)slot.getType().getId(), (a, b) -> {
                if (b == null) {
                    return 0;
                }
                return b + 1;
            });
        }
    }

    protected Slot m_38897_(Slot slot) {
        if (slot instanceof AbstractSlot) {
            AbstractSlot abstractSlot = (AbstractSlot)slot;
            this.slotMap.computeIfAbsent(abstractSlot.type, t -> new ArrayList()).add(abstractSlot);
        }
        return super.m_38897_(slot);
    }

    public boolean m_6875_(Player player) {
        return ContainerMachine.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.tile.m_58904_(), (BlockPos)this.tile.m_58899_()), (Player)player, (Block)this.tile.m_58900_().m_60734_());
    }

    @Generated
    public T getTile() {
        return this.tile;
    }
}

