/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.datagen.builder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.devtech.arrp.json.models.JTextures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.client.GTLibModelManager;
import org.gtreimagined.gtlib.datagen.builder.DynamicConfigBuilder;
import org.gtreimagined.gtlib.datagen.builder.GTModelBuilder;
import org.gtreimagined.gtlib.datagen.json.JConfigEntry;
import org.gtreimagined.gtlib.datagen.json.JLoaderModel;
import org.gtreimagined.gtlib.datagen.json.JModel;
import org.gtreimagined.gtlib.datagen.json.JRotationModel;
import org.gtreimagined.gtlib.registration.ITextureProvider;
import org.gtreimagined.gtlib.texture.Texture;

public class GTBlockModelBuilder
extends GTModelBuilder<GTBlockModelBuilder> {
    public static final String SIMPLE = "gtlib".concat(":block/preset/simple");
    protected static final String LAYERED = "gtlib".concat(":block/preset/layered");
    protected final List<Consumer<Object>> properties = new ObjectArrayList();

    public GTBlockModelBuilder(ResourceLocation outputLocation) {
        super(outputLocation);
    }

    public GTBlockModelBuilder property(String property, Object element) {
        this.model.property(property, element);
        return this;
    }

    public GTBlockModelBuilder property(String property, String value) {
        this.model.property(property, value);
        return this;
    }

    public GTBlockModelBuilder property(String property, String key, String value) {
        return this.property(property, new StringToString(key, value));
    }

    public GTBlockModelBuilder particle(Texture tex) {
        this.model.property("particle", tex.toString());
        return this;
    }

    public GTBlockModelBuilder model(String parent, String ... textures) {
        this.loader(GTLibModelManager.LOADER_MAIN);
        return this.property("model", this.addModelObject(JLoaderModel.model(), parent, GTBlockModelBuilder.buildTextures(textures)));
    }

    public GTBlockModelBuilder model(String parent, Texture ... textures) {
        this.loader(GTLibModelManager.LOADER_MAIN);
        return this.property("model", this.addModelObject(JLoaderModel.model(), parent, GTBlockModelBuilder.buildTextures(textures)));
    }

    public GTBlockModelBuilder model(String parent, Function<ImmutableMap.Builder<String, Texture>, ImmutableMap.Builder<String, Texture>> func) {
        this.loader(GTLibModelManager.LOADER_MAIN);
        return this.property("model", this.addModelObject(JLoaderModel.model(), parent, GTBlockModelBuilder.buildTextures((ImmutableMap<String, Texture>)func.apply((ImmutableMap.Builder<String, Texture>)new ImmutableMap.Builder()).build())));
    }

    public GTBlockModelBuilder model(String parent, ImmutableMap<String, Texture> map) {
        this.loader(GTLibModelManager.LOADER_MAIN);
        return this.property("model", this.addModelObject(JLoaderModel.model(), parent, GTBlockModelBuilder.buildTextures(map)));
    }

    public GTBlockModelBuilder rot(int ... rotations) {
        this.loader(GTLibModelManager.LOADER_MAIN);
        if (rotations.length != 3) {
            throw new IllegalStateException("rotations must have no more or less then 3 elements");
        }
        this.model.rotation(rotations);
        return this;
    }

    public GTBlockModelBuilder config(int id, String parent, Function<DynamicConfigBuilder, DynamicConfigBuilder> builderFunc) {
        return this.config(id, (b, l) -> l.add((Object)((DynamicConfigBuilder)builderFunc.apply(b.of(parent)))));
    }

    public GTBlockModelBuilder config(int id, IConfigFunction configFunc) {
        this.loader(GTLibModelManager.LOADER_DYNAMIC);
        ImmutableList builders = configFunc.apply(new DynamicConfigBuilder(), (ImmutableList.Builder<DynamicConfigBuilder>)new ImmutableList.Builder()).build();
        JConfigEntry entry = JConfigEntry.configEntry();
        entry.setID(id);
        entry.addModels(this.getModelObjects((ImmutableList<DynamicConfigBuilder>)builders));
        this.model.configEntry(entry);
        return this;
    }

    public JModel[] getModelObjects(ImmutableList<DynamicConfigBuilder> builders) {
        ArrayList models = new ArrayList();
        builders.forEach(b -> {
            JRotationModel model1 = JRotationModel.modelKeepElements();
            model1.parent(b.parent);
            JTextures textures1 = new JTextures();
            b.textures.forEach((arg_0, arg_1) -> ((JTextures)textures1).var(arg_0, arg_1));
            model1.textures(textures1);
            if (b.hasRots()) {
                model1.rotation(b.rotations);
            }
            if (b.getLoader() != null) {
                model1.loader(b.loader.toString());
            }
            models.add(model1);
        });
        return models.toArray(new JModel[0]);
    }

    public JLoaderModel addModelObject(JLoaderModel o, String parent, ImmutableMap<String, String> textures) {
        if (!parent.contains(":")) {
            parent = StringUtils.replace((String)StringUtils.replace((String)parent, (String)"simple", (String)SIMPLE), (String)"layered", (String)LAYERED);
        }
        o.parent(parent);
        JTextures textures1 = new JTextures();
        textures.forEach((k, v) -> textures1.var(k, v.replaceAll("mc:", "minecraft:")));
        o.textures(textures1);
        return o;
    }

    public static String getSimple() {
        return SIMPLE;
    }

    public static String getLayered() {
        return LAYERED;
    }

    public GTBlockModelBuilder staticConfigId(String mapId) {
        this.loader(GTLibModelManager.LOADER_DYNAMIC);
        return this.property("staticConfigId", mapId);
    }

    public static ImmutableMap<String, String> buildTextures(ImmutableMap<String, Texture> map) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        map.forEach((k, v) -> builder.put(k, (Object)v.toString()));
        return builder.build();
    }

    public static ImmutableMap<String, String> buildTextures(Texture ... textures) {
        return GTBlockModelBuilder.buildTextures((String[])Arrays.stream(textures).map(ResourceLocation::toString).toArray(String[]::new));
    }

    public static ImmutableMap<String, String> buildTextures(String ... textures) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        if (textures.length == 1) {
            builder.put((Object)"all", (Object)textures[0]);
        } else if (textures.length == 6) {
            for (int s = 0; s < 6; ++s) {
                builder.put((Object)Ref.DIRS[s].toString(), (Object)textures[s]);
            }
        }
        return builder.build();
    }

    public GTBlockModelBuilder basicConfig(Block block, Texture[] tex) {
        if (!(block instanceof ITextureProvider) || tex.length < 13) {
            return this;
        }
        this.model(SIMPLE, ((ITextureProvider)block).getTextures());
        if (tex.length < 17) {
            this.config(1, SIMPLE, c -> c.tex(tex[12], tex[12], tex[1], tex[1], tex[1], tex[1]));
            this.config(2, SIMPLE, c -> c.tex(tex[12], tex[12], tex[1], tex[1], tex[1], tex[1]));
            this.config(4, SIMPLE, c -> c.tex(tex[1], tex[1], tex[0], tex[12], tex[0], tex[0]));
            this.config(8, SIMPLE, c -> c.tex(tex[1], tex[1], tex[12], tex[0], tex[0], tex[0]));
            this.config(16, SIMPLE, c -> c.tex(tex[0], tex[0], tex[0], tex[0], tex[0], tex[12]));
            this.config(32, SIMPLE, c -> c.tex(tex[0], tex[0], tex[0], tex[0], tex[12], tex[0]));
        } else {
            this.config(1, SIMPLE, c -> c.tex(tex[12], tex[12], tex[14], tex[14], tex[14], tex[14]));
            this.config(2, SIMPLE, c -> c.tex(tex[12], tex[12], tex[16], tex[16], tex[16], tex[16]));
            this.config(4, SIMPLE, c -> c.tex(tex[14], tex[16], tex[0], tex[12], tex[15], tex[13]));
            this.config(8, SIMPLE, c -> c.tex(tex[16], tex[14], tex[12], tex[0], tex[13], tex[15]));
            this.config(16, SIMPLE, c -> c.tex(tex[15], tex[15], tex[13], tex[15], tex[0], tex[12]));
            this.config(32, SIMPLE, c -> c.tex(tex[13], tex[13], tex[15], tex[13], tex[12], tex[0]));
        }
        this.config(3, SIMPLE, c -> c.tex(tex[12], tex[12], tex[1], tex[1], tex[1], tex[1]));
        this.config(12, SIMPLE, c -> c.tex(tex[1], tex[1], tex[12], tex[12], tex[0], tex[0]));
        this.config(48, SIMPLE, c -> c.tex(tex[0], tex[0], tex[0], tex[0], tex[12], tex[12]));
        this.config(6, SIMPLE, c -> c.tex(tex[1], tex[12], tex[0], tex[1], tex[11], tex[10]));
        this.config(5, SIMPLE, c -> c.tex(tex[12], tex[1], tex[12], tex[1], tex[9], tex[8]));
        this.config(9, SIMPLE, c -> c.tex(tex[12], tex[1], tex[1], tex[12], tex[8], tex[9]));
        this.config(10, SIMPLE, c -> c.tex(tex[1], tex[12], tex[1], tex[12], tex[10], tex[11]));
        this.config(17, SIMPLE, c -> c.tex(tex[12], tex[0], tex[8], tex[9], tex[12], tex[1]));
        this.config(18, SIMPLE, c -> c.tex(tex[0], tex[12], tex[10], tex[11], tex[12], tex[1]));
        this.config(33, SIMPLE, c -> c.tex(tex[12], tex[0], tex[9], tex[8], tex[1], tex[12]));
        this.config(34, SIMPLE, c -> c.tex(tex[0], tex[12], tex[11], tex[10], tex[1], tex[10]));
        this.config(20, SIMPLE, c -> c.tex(tex[9], tex[11], tex[0], tex[0], tex[0], tex[0]));
        this.config(24, SIMPLE, c -> c.tex(tex[11], tex[9], tex[0], tex[0], tex[0], tex[0]));
        this.config(36, SIMPLE, c -> c.tex(tex[8], tex[10], tex[0], tex[0], tex[0], tex[0]));
        this.config(40, SIMPLE, c -> c.tex(tex[10], tex[8], tex[0], tex[0], tex[0], tex[0]));
        this.config(7, SIMPLE, c -> c.tex(tex[12], tex[12], tex[12], tex[1], tex[4], tex[2]));
        this.config(11, SIMPLE, c -> c.tex(tex[12], tex[12], tex[1], tex[12], tex[2], tex[4]));
        this.config(13, SIMPLE, c -> c.tex(tex[12], tex[1], tex[12], tex[12], tex[3], tex[3]));
        this.config(14, SIMPLE, c -> c.tex(tex[1], tex[12], tex[12], tex[12], tex[5], tex[5]));
        this.config(19, SIMPLE, c -> c.tex(tex[12], tex[12], tex[2], tex[4], tex[12], tex[1]));
        this.config(28, SIMPLE, c -> c.tex(tex[4], tex[4], tex[12], tex[12], tex[12], tex[0]));
        this.config(35, SIMPLE, c -> c.tex(tex[12], tex[12], tex[4], tex[2], tex[1], tex[12]));
        this.config(44, SIMPLE, c -> c.tex(tex[2], tex[2], tex[12], tex[12], tex[0], tex[12]));
        this.config(49, SIMPLE, c -> c.tex(tex[12], tex[0], tex[3], tex[3], tex[12], tex[12]));
        this.config(50, SIMPLE, c -> c.tex(tex[0], tex[12], tex[5], tex[5], tex[12], tex[12]));
        this.config(52, SIMPLE, c -> c.tex(tex[3], tex[5], tex[12], tex[0], tex[12], tex[12]));
        this.config(56, SIMPLE, c -> c.tex(tex[5], tex[3], tex[0], tex[12], tex[12], tex[12]));
        this.config(21, SIMPLE, c -> c.tex(tex[11], tex[11], tex[0], tex[9], tex[0], tex[8]));
        this.config(22, SIMPLE, c -> c.tex(tex[9], tex[9], tex[0], tex[11], tex[0], tex[10]));
        this.config(25, SIMPLE, c -> c.tex(tex[9], tex[9], tex[8], tex[0], tex[0], tex[9]));
        this.config(26, SIMPLE, c -> c.tex(tex[11], tex[11], tex[10], tex[0], tex[0], tex[11]));
        this.config(37, SIMPLE, c -> c.tex(tex[10], tex[10], tex[0], tex[8], tex[9], tex[0]));
        this.config(38, SIMPLE, c -> c.tex(tex[8], tex[8], tex[0], tex[10], tex[11], tex[0]));
        this.config(41, SIMPLE, c -> c.tex(tex[8], tex[8], tex[9], tex[0], tex[8], tex[0]));
        this.config(42, SIMPLE, c -> c.tex(tex[10], tex[10], tex[11], tex[0], tex[10], tex[0]));
        this.config(23, SIMPLE, c -> c.tex(tex[12], tex[12], tex[12], tex[4], tex[12], tex[2]));
        this.config(27, SIMPLE, c -> c.tex(tex[12], tex[12], tex[2], tex[12], tex[12], tex[4]));
        this.config(29, SIMPLE, c -> c.tex(tex[12], tex[4], tex[12], tex[12], tex[12], tex[3]));
        this.config(30, SIMPLE, c -> c.tex(tex[4], tex[12], tex[12], tex[12], tex[12], tex[5]));
        this.config(39, SIMPLE, c -> c.tex(tex[12], tex[12], tex[12], tex[2], tex[4], tex[12]));
        this.config(43, SIMPLE, c -> c.tex(tex[12], tex[12], tex[4], tex[12], tex[2], tex[12]));
        this.config(45, SIMPLE, c -> c.tex(tex[12], tex[2], tex[12], tex[12], tex[3], tex[12]));
        this.config(46, SIMPLE, c -> c.tex(tex[2], tex[12], tex[12], tex[12], tex[5], tex[12]));
        this.config(53, SIMPLE, c -> c.tex(tex[12], tex[5], tex[12], tex[3], tex[12], tex[12]));
        this.config(54, SIMPLE, c -> c.tex(tex[3], tex[12], tex[12], tex[5], tex[12], tex[12]));
        this.config(57, SIMPLE, c -> c.tex(tex[12], tex[3], tex[3], tex[12], tex[12], tex[12]));
        this.config(58, SIMPLE, c -> c.tex(tex[5], tex[12], tex[5], tex[12], tex[12], tex[12]));
        this.config(15, SIMPLE, c -> c.tex(tex[12], tex[12], tex[12], tex[12], tex[6], tex[6]));
        this.config(51, SIMPLE, c -> c.tex(tex[12], tex[12], tex[6], tex[6], tex[12], tex[12]));
        this.config(60, SIMPLE, c -> c.tex(tex[6], tex[6], tex[12], tex[12], tex[12], tex[12]));
        this.config(31, SIMPLE, c -> c.tex(tex[12], tex[12], tex[12], tex[12], tex[12], tex[6]));
        this.config(47, SIMPLE, c -> c.tex(tex[12], tex[12], tex[12], tex[12], tex[6], tex[12]));
        this.config(55, SIMPLE, c -> c.tex(tex[12], tex[12], tex[12], tex[6], tex[12], tex[12]));
        this.config(59, SIMPLE, c -> c.tex(tex[12], tex[12], tex[6], tex[12], tex[12], tex[12]));
        this.config(61, SIMPLE, c -> c.tex(tex[12], tex[6], tex[12], tex[12], tex[12], tex[12]));
        this.config(62, SIMPLE, c -> c.tex(tex[6], tex[12], tex[12], tex[12], tex[12], tex[12]));
        this.config(63, SIMPLE, c -> c.tex(tex[12], tex[12], tex[12], tex[12], tex[12], tex[12]));
        return this;
    }

    private record StringToString(String key, String value) {
    }

    public static interface IConfigFunction {
        public ImmutableList.Builder<DynamicConfigBuilder> apply(DynamicConfigBuilder var1, ImmutableList.Builder<DynamicConfigBuilder> var2);
    }
}

