/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.client.baked;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import org.gtreimagined.gtlib.client.GTLibModelProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IGTBakedModel
extends IDynamicBakedModel {
    public List<BakedQuad> getBlockQuads(BlockState var1, @Nullable Direction var2, @NotNull Random var3, @NotNull BlockAndTintGetter var4, @NotNull BlockPos var5);

    default public List<BakedQuad> getQuads(BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull BlockAndTintGetter level, @NotNull BlockPos pos) {
        try {
            if (this.hasOnlyGeneralQuads() && side != null) {
                return Collections.emptyList();
            }
            return state != null ? this.getBlockQuads(state, side, rand, level, pos) : Collections.emptyList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public boolean hasOnlyGeneralQuads();

    default public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return Collections.emptyList();
    }

    @NotNull
    default public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull IModelData data) {
        BlockAndTintGetter world = (BlockAndTintGetter)data.getData(GTLibModelProperties.WORLD);
        BlockPos pos = (BlockPos)data.getData(GTLibModelProperties.POS);
        if (world == null || pos == null) {
            return Collections.emptyList();
        }
        return this.getQuads(state, side, rand, world, pos);
    }

    @NotNull
    default public IModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData modelData) {
        IModelData d = super.getModelData(level, pos, state, modelData);
        if (d == EmptyModelData.INSTANCE) {
            d = new ModelDataMap.Builder().build();
        }
        d.setData(GTLibModelProperties.WORLD, (Object)level);
        d.setData(GTLibModelProperties.POS, (Object)pos);
        return d;
    }

    default public TextureAtlasSprite getParticleIcon(@NotNull IModelData data) {
        BlockAndTintGetter world = (BlockAndTintGetter)data.getData(GTLibModelProperties.WORLD);
        BlockPos pos = (BlockPos)data.getData(GTLibModelProperties.POS);
        if (world == null || pos == null) {
            return super.getParticleIcon(data);
        }
        return this.getParticleIcon(world, pos);
    }

    public TextureAtlasSprite getParticleIcon(BlockAndTintGetter var1, BlockPos var2);
}

