/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gtlib.capability.fluid;

import net.minecraft.core.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityFluidPipe;
import org.gtreimagined.gtlib.capability.FluidHandler;
import org.gtreimagined.gtlib.capability.fluid.FluidHandlerSidedWrapper;
import org.jetbrains.annotations.NotNull;

public class PipeFluidHandlerSidedWrapper
extends FluidHandlerSidedWrapper {
    BlockEntityFluidPipe<?> pipe;
    FluidHandler<?> fluidHandler;

    public PipeFluidHandlerSidedWrapper(FluidHandler<?> fluidHandler, BlockEntityFluidPipe<?> fluidPipe, Direction side) {
        super(fluidHandler, fluidPipe.coverHandler.orElse(null), side);
        this.pipe = fluidPipe;
        this.fluidHandler = fluidHandler;
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.side == null) {
            return 0;
        }
        if (this.coverHandler != null) {
            if (this.coverHandler.blocksInput(IFluidHandler.class, this.side)) {
                return 0;
            }
            int oldAmount = resource.getAmount();
            if (this.coverHandler.onTransfer(resource, this.side, true, action.simulate())) {
                return oldAmount - resource.getAmount();
            }
        }
        if (!this.fluidHandler.canInput(resource, this.side) || !this.fluidHandler.canInput(this.side)) {
            return 0;
        }
        int tank = this.fluidHandler.getInputTanks().getFirstAvailableTank(resource, false);
        if (tank == -1) {
            return 0;
        }
        int insert = this.fluidHandler.getInputTanks().getTank(tank).fill(resource, action);
        if (insert > 0 && action.execute()) {
            this.pipe.setLastSide(this.side, tank);
        }
        return insert;
    }

    @Override
    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.side == null) {
            return FluidStack.EMPTY;
        }
        if (this.coverHandler != null && (this.coverHandler.blocksOutput(IFluidHandler.class, this.side) || this.coverHandler.onTransfer(resource, this.side, false, action.simulate()))) {
            return FluidStack.EMPTY;
        }
        return super.drain(resource, action);
    }
}

