/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core.matrix;

import com.mojang.math.Matrix3f;
import com.mojang.math.Quaternion;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.math.Matrix3fExtended;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Matrix3f.class})
public class MixinMatrix3f
implements Matrix3fExtended {
    @Shadow
    protected float f_8134_;
    @Shadow
    protected float f_8137_;
    @Shadow
    protected float f_8140_;
    @Shadow
    protected float f_8135_;
    @Shadow
    protected float f_8138_;
    @Shadow
    protected float f_8141_;
    @Shadow
    protected float f_8136_;
    @Shadow
    protected float f_8139_;
    @Shadow
    protected float f_8142_;

    @Override
    public float transformVecX(float x, float y, float z) {
        return this.f_8134_ * x + this.f_8135_ * y + this.f_8136_ * z;
    }

    @Override
    public float transformVecY(float x, float y, float z) {
        return this.f_8137_ * x + this.f_8138_ * y + this.f_8139_ * z;
    }

    @Override
    public float transformVecZ(float x, float y, float z) {
        return this.f_8140_ * x + this.f_8141_ * y + this.f_8142_ * z;
    }

    @Override
    public void rotate(Quaternion quaternion) {
        boolean z;
        boolean x = quaternion.m_80140_() != 0.0f;
        boolean y = quaternion.m_80150_() != 0.0f;
        boolean bl = z = quaternion.m_80153_() != 0.0f;
        if (x) {
            if (!y && !z) {
                this.rotateX(quaternion);
            } else {
                this.rotateXYZ(quaternion);
            }
        } else if (y) {
            if (!z) {
                this.rotateY(quaternion);
            } else {
                this.rotateXYZ(quaternion);
            }
        } else if (z) {
            this.rotateZ(quaternion);
        }
    }

    @Override
    public int computeNormal(Direction dir) {
        Vec3i faceNorm = dir.m_122436_();
        float x = faceNorm.m_123341_();
        float y = faceNorm.m_123342_();
        float z = faceNorm.m_123343_();
        float x2 = this.f_8134_ * x + this.f_8135_ * y + this.f_8136_ * z;
        float y2 = this.f_8137_ * x + this.f_8138_ * y + this.f_8139_ * z;
        float z2 = this.f_8140_ * x + this.f_8141_ * y + this.f_8142_ * z;
        return Norm3b.pack(x2, y2, z2);
    }

    private void rotateX(Quaternion quaternion) {
        float x = quaternion.m_80140_();
        float w = quaternion.m_80156_();
        float xx = 2.0f * x * x;
        float ta11 = 1.0f - xx;
        float ta22 = 1.0f - xx;
        float xw = x * w;
        float ta21 = 2.0f * xw;
        float ta12 = 2.0f * -xw;
        float a01 = this.f_8135_ * ta11 + this.f_8136_ * ta21;
        float a02 = this.f_8135_ * ta12 + this.f_8136_ * ta22;
        float a11 = this.f_8138_ * ta11 + this.f_8139_ * ta21;
        float a12 = this.f_8138_ * ta12 + this.f_8139_ * ta22;
        float a21 = this.f_8141_ * ta11 + this.f_8142_ * ta21;
        float a22 = this.f_8141_ * ta12 + this.f_8142_ * ta22;
        this.f_8135_ = a01;
        this.f_8136_ = a02;
        this.f_8138_ = a11;
        this.f_8139_ = a12;
        this.f_8141_ = a21;
        this.f_8142_ = a22;
    }

    private void rotateY(Quaternion quaternion) {
        float y = quaternion.m_80150_();
        float w = quaternion.m_80156_();
        float yy = 2.0f * y * y;
        float ta00 = 1.0f - yy;
        float ta22 = 1.0f - yy;
        float yw = y * w;
        float ta20 = 2.0f * -yw;
        float ta02 = 2.0f * yw;
        float a00 = this.f_8134_ * ta00 + this.f_8136_ * ta20;
        float a02 = this.f_8134_ * ta02 + this.f_8136_ * ta22;
        float a10 = this.f_8137_ * ta00 + this.f_8139_ * ta20;
        float a12 = this.f_8137_ * ta02 + this.f_8139_ * ta22;
        float a20 = this.f_8140_ * ta00 + this.f_8142_ * ta20;
        float a22 = this.f_8140_ * ta02 + this.f_8142_ * ta22;
        this.f_8134_ = a00;
        this.f_8136_ = a02;
        this.f_8137_ = a10;
        this.f_8139_ = a12;
        this.f_8140_ = a20;
        this.f_8142_ = a22;
    }

    private void rotateZ(Quaternion quaternion) {
        float z = quaternion.m_80153_();
        float w = quaternion.m_80156_();
        float zz = 2.0f * z * z;
        float ta00 = 1.0f - zz;
        float ta11 = 1.0f - zz;
        float zw = z * w;
        float ta10 = 2.0f * (0.0f + zw);
        float ta01 = 2.0f * (0.0f - zw);
        float a00 = this.f_8134_ * ta00 + this.f_8135_ * ta10;
        float a01 = this.f_8134_ * ta01 + this.f_8135_ * ta11;
        float a10 = this.f_8137_ * ta00 + this.f_8138_ * ta10;
        float a11 = this.f_8137_ * ta01 + this.f_8138_ * ta11;
        float a20 = this.f_8140_ * ta00 + this.f_8141_ * ta10;
        float a21 = this.f_8140_ * ta01 + this.f_8141_ * ta11;
        this.f_8134_ = a00;
        this.f_8135_ = a01;
        this.f_8137_ = a10;
        this.f_8138_ = a11;
        this.f_8140_ = a20;
        this.f_8141_ = a21;
    }

    private void rotateXYZ(Quaternion quaternion) {
        float x = quaternion.m_80140_();
        float y = quaternion.m_80150_();
        float z = quaternion.m_80153_();
        float w = quaternion.m_80156_();
        float xx = 2.0f * x * x;
        float yy = 2.0f * y * y;
        float zz = 2.0f * z * z;
        float ta00 = 1.0f - yy - zz;
        float ta11 = 1.0f - zz - xx;
        float ta22 = 1.0f - xx - yy;
        float xy = x * y;
        float yz = y * z;
        float zx = z * x;
        float xw = x * w;
        float yw = y * w;
        float zw = z * w;
        float ta10 = 2.0f * (xy + zw);
        float ta01 = 2.0f * (xy - zw);
        float ta20 = 2.0f * (zx - yw);
        float ta02 = 2.0f * (zx + yw);
        float ta21 = 2.0f * (yz + xw);
        float ta12 = 2.0f * (yz - xw);
        float a00 = this.f_8134_ * ta00 + this.f_8135_ * ta10 + this.f_8136_ * ta20;
        float a01 = this.f_8134_ * ta01 + this.f_8135_ * ta11 + this.f_8136_ * ta21;
        float a02 = this.f_8134_ * ta02 + this.f_8135_ * ta12 + this.f_8136_ * ta22;
        float a10 = this.f_8137_ * ta00 + this.f_8138_ * ta10 + this.f_8139_ * ta20;
        float a11 = this.f_8137_ * ta01 + this.f_8138_ * ta11 + this.f_8139_ * ta21;
        float a12 = this.f_8137_ * ta02 + this.f_8138_ * ta12 + this.f_8139_ * ta22;
        float a20 = this.f_8140_ * ta00 + this.f_8141_ * ta10 + this.f_8142_ * ta20;
        float a21 = this.f_8140_ * ta01 + this.f_8141_ * ta11 + this.f_8142_ * ta21;
        float a22 = this.f_8140_ * ta02 + this.f_8141_ * ta12 + this.f_8142_ * ta22;
        this.f_8134_ = a00;
        this.f_8135_ = a01;
        this.f_8136_ = a02;
        this.f_8137_ = a10;
        this.f_8138_ = a11;
        this.f_8139_ = a12;
        this.f_8140_ = a20;
        this.f_8141_ = a21;
        this.f_8142_ = a22;
    }

    @Override
    public float getA00() {
        return this.f_8134_;
    }

    @Override
    public float getA10() {
        return this.f_8137_;
    }

    @Override
    public float getA20() {
        return this.f_8140_;
    }

    @Override
    public float getA01() {
        return this.f_8135_;
    }

    @Override
    public float getA11() {
        return this.f_8138_;
    }

    @Override
    public float getA21() {
        return this.f_8141_;
    }

    @Override
    public float getA02() {
        return this.f_8136_;
    }

    @Override
    public float getA12() {
        return this.f_8139_;
    }

    @Override
    public float getA22() {
        return this.f_8142_;
    }
}

