/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseContainerBase;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.IContainerFactory;

public abstract class CorpseContainerFactory<T extends CorpseContainerBase>
implements IContainerFactory<T> {
    public T create(int windowId, Inventory inv, FriendlyByteBuf buffer) {
        boolean isHistory = buffer.readBoolean();
        boolean additionalItemsEmpty = buffer.readBoolean();
        if (isHistory) {
            Death death = Death.fromNBT(buffer.m_130260_());
            if (!additionalItemsEmpty) {
                death.getAdditionalItems().add((Object)new ItemStack((ItemLike)Items.f_41905_));
            }
            return this.create(windowId, inv, CorpseEntity.createFromDeath(inv.f_35978_, death), inv.f_35978_.m_150110_().f_35937_, isHistory);
        }
        UUID uuid = buffer.m_130259_();
        AABB aabb = inv.f_35978_.m_142469_();
        aabb = aabb.m_82400_(10.0);
        Optional<CorpseEntity> entity = inv.f_35978_.f_19853_.m_45976_(CorpseEntity.class, aabb).stream().filter(corpse -> corpse.m_142081_().equals(uuid) && corpse.m_20270_((Entity)inv.f_35978_) <= 5.0f).findFirst();
        return (T)((Object)((CorpseContainerBase)entity.map(corpseEntity -> {
            if (!additionalItemsEmpty) {
                corpseEntity.getDeath().getAdditionalItems().add((Object)new ItemStack((ItemLike)Items.f_41905_));
            }
            return this.create(windowId, inv.f_35978_.m_150109_(), (CorpseEntity)((Object)corpseEntity), true, isHistory);
        }).orElse(null)));
    }

    public abstract T create(int var1, Inventory var2, CorpseEntity var3, boolean var4, boolean var5);
}

