/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.worldgen;

import net.minecraft.nbt.CompoundTag;
import org.gtreimagined.gt5r.worldgen.OilSpoutFluid;
import org.gtreimagined.gt5r.worldgen.OilSpoutSavedData;
import org.jetbrains.annotations.NotNull;

public class OilSpoutEntry {
    final OilSpoutFluid fluid;
    int currentYield;
    int level = 1000;

    public OilSpoutEntry(OilSpoutFluid fluid, int currentYield) {
        this.fluid = fluid;
        this.currentYield = currentYield;
    }

    public void decreaseLevel() {
        if (this.fluid == null) {
            return;
        }
        if (this.currentYield == this.fluid.getMinYield()) {
            return;
        }
        if (this.level == 0) {
            if (this.currentYield > this.fluid.getMinYield()) {
                --this.currentYield;
            }
            this.level = 1000;
        } else {
            this.level -= Math.min(this.level, this.fluid.getLevelDecrese());
        }
    }

    public CompoundTag writeToNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.fluid != null) {
            tag.m_128359_("fluid", this.fluid.getId());
        }
        tag.m_128405_("currentYield", this.currentYield);
        tag.m_128405_("level", this.level);
        return tag;
    }

    @NotNull
    public static OilSpoutEntry readFromNBT(@NotNull CompoundTag tag) {
        OilSpoutEntry info = new OilSpoutEntry(tag.m_128441_("fluid") ? OilSpoutSavedData.getOilSpoutFluid(tag.m_128461_("fluid")) : null, tag.m_128451_("currentYield"));
        info.level = tag.m_128451_("level");
        return info;
    }

    public OilSpoutFluid getFluid() {
        return this.fluid;
    }

    public int getCurrentYield() {
        return this.currentYield;
    }

    public int getLevel() {
        return this.level;
    }
}

