/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.proxy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.gtreimagined.gt5r.GT5Reimagined;
import org.gtreimagined.gt5r.block.BlockBedrockFlower;
import org.gtreimagined.gt5r.block.BlockCasing;
import org.gtreimagined.gt5r.block.BlockColoredWall;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.GT5RMachines;
import org.gtreimagined.gt5r.integration.tfc.client.JavelinModel;
import org.gtreimagined.gt5r.integration.tfc.data.TFCToolTypes;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.client.ModelUtils;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.gtlib.util.Utils;

public class ClientHandler {
    public static void setup() {
        GTAPI.all(BlockCasing.class, t -> ModelUtils.setRenderLayer((Block)t, (RenderType)RenderType.m_110463_()));
        GTAPI.all(BlockColoredWall.class, t -> ModelUtils.setRenderLayer((Block)t, (RenderType)RenderType.m_110463_()));
        GTAPI.all(BlockBedrockFlower.class, t -> ModelUtils.setRenderLayer((Block)t, (RenderType)RenderType.m_110463_()));
        ModelUtils.setRenderLayer((Block)GT5RMachines.NUCLEAR_REACTOR_CORE.getBlockState(Tier.NONE), (RenderType)RenderType.m_110463_());
        ClientHandler.copyProgrammerArtIfMissing();
        GTAPI.all(IGTTool.class, (String)"gt5r").stream().filter(t -> t.getGTToolType() == TFCToolTypes.JAVELIN).forEach(j -> {
            Item javelin = j.getItem();
            ItemProperties.register((Item)javelin, (ResourceLocation)Helpers.identifier((String)"throwing"), (stack, level, entity, unused) -> {
                Monster monster;
                return entity != null && (entity.m_6117_() && entity.m_21211_() == stack || entity instanceof Monster && (monster = (Monster)entity).m_5912_()) ? 1.0f : 0.0f;
            });
        });
    }

    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ClientHandler.modelIdentifier("javelin_head"), JavelinModel::createHeadLayer);
        event.registerLayerDefinition(ClientHandler.modelIdentifier("javelin_handle"), JavelinModel::createHandleLayer);
    }

    public static ModelLayerLocation modelIdentifier(String name, String part) {
        return new ModelLayerLocation(new ResourceLocation("gt5r", name), part);
    }

    public static ModelLayerLocation modelIdentifier(String name) {
        return ClientHandler.modelIdentifier(name, "main");
    }

    private static void copyProgrammerArtIfMissing() {
        ClientHandler.writeResourcePack("Classic-GT5-Machine-Textures", "classic-gt5-machine-textures");
        ClientHandler.writeResourcePack("Old-GTI-Machine-Textures", "old-gti-machine-textures");
    }

    private static void writeResourcePack(String writeName, String readName) {
        File dir = new File(FMLPaths.CONFIGDIR.get().getParent().toFile(), "resourcepacks");
        File target = new File(dir, writeName + ".zip");
        try {
            dir.mkdirs();
            InputStream in = GT5Reimagined.class.getResourceAsStream("/assets/gt5r/" + readName + ".zip");
            FileOutputStream out = new FileOutputStream(target);
            byte[] buf = new byte[16384];
            int len = 0;
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void onTooltipEvent(ItemTooltipEvent event) {
        String material;
        Material mat;
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() == GT5RItems.DataOrb && stack.m_41783_() != null && stack.m_41783_().m_128441_("scanned_gt_material") && (mat = Material.get((String)(material = stack.m_41783_().m_128461_("scanned_gt_material")))) != Material.NULL && mat.getElement() != null) {
            event.getToolTip().add(1, Utils.translatable((String)"tooltip.gt5r.data_orb.elemental_scan", (Object[])new Object[0]));
            event.getToolTip().add(2, Utils.literal((String)mat.getChemicalFormula()));
        }
    }
}

