/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.machine.caps;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gtreimagined.gtlib.blockentity.multi.BlockEntityMultiMachine;
import org.gtreimagined.gtlib.capability.FluidHandler;
import org.gtreimagined.gtlib.capability.IComponentHandler;
import org.gtreimagined.gtlib.capability.fluid.FluidTanks;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.capability.machine.MultiMachineFluidHandler;

public class SecondaryMultiFluidHandler<T extends BlockEntityMultiMachine<T>>
extends MultiMachineFluidHandler<T> {
    protected final EnumMap<FluidHandler.FluidDirection, FluidTanks> secondaryTanks = new EnumMap(FluidHandler.FluidDirection.class);

    public SecondaryMultiFluidHandler(T tile) {
        super(tile);
    }

    protected void cacheSecondaryInputs() {
        List inputs = ((BlockEntityMultiMachine)this.tile).getComponentsByHandlerId(this.secondaryInputComponentString()).stream().map(IComponentHandler::getFluidHandler).map(Optional::get).sorted(this::compareSecondaryInputHatches).collect(Collectors.toUnmodifiableList());
        this.secondaryTanks.put(FluidHandler.FluidDirection.INPUT, new FluidTanks((Collection)inputs.stream().filter(t -> t.getInputTanks() != null).flatMap(t -> Arrays.stream(t.getInputTanks().getBackingTanks())).collect(Collectors.toList())));
    }

    protected int compareSecondaryInputHatches(MachineFluidHandler<?> a, MachineFluidHandler<?> b) {
        return 0;
    }

    protected String secondaryInputComponentString() {
        return "secondary_fluid_input";
    }

    protected String secondaryOutputComponentString() {
        return "secondary_fluid_output";
    }

    protected void cacheSecondaryOutputs() {
        List outputs = ((BlockEntityMultiMachine)this.tile).getComponentsByHandlerId(this.secondaryOutputComponentString()).stream().map(IComponentHandler::getFluidHandler).map(Optional::get).sorted(this::compareSecondaryOutputHatches).collect(Collectors.toUnmodifiableList());
        this.secondaryTanks.put(FluidHandler.FluidDirection.OUTPUT, new FluidTanks((Collection)outputs.stream().filter(t -> t.getOutputTanks() != null).flatMap(t -> Arrays.stream(t.getOutputTanks().getBackingTanks())).collect(Collectors.toList())));
    }

    protected int compareSecondaryOutputHatches(MachineFluidHandler<?> a, MachineFluidHandler<?> b) {
        return 0;
    }

    public void invalidate() {
        super.invalidate();
        this.secondaryTanks.clear();
    }

    public void onStructureBuild() {
        super.onStructureBuild();
        this.cacheSecondaryInputs();
        this.cacheSecondaryOutputs();
    }

    public FluidTanks getSecondaryInputTanks() {
        return this.secondaryTanks.get(FluidHandler.FluidDirection.INPUT);
    }

    public FluidTanks getSecondaryOutputTanks() {
        return this.secondaryTanks.get(FluidHandler.FluidDirection.OUTPUT);
    }
}

