/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.machine.caps;

import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.CoverHandler;
import org.gtreimagined.gtlib.capability.item.SidedCombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class ExtenderSidedItemWrapper
extends SidedCombinedInvWrapper {
    protected BlockEntityMachine<?> blockEntity;

    public ExtenderSidedItemWrapper(BlockEntityMachine<?> blockEntity, Direction side, CoverHandler<?> coverHandler, Predicate<Direction> inputFunction, Predicate<Direction> outputFunction, IItemHandlerModifiable ... itemHandler) {
        super(side, coverHandler, inputFunction, outputFunction, itemHandler);
        this.blockEntity = blockEntity;
    }

    LazyOptional<IItemHandler> getItemHandler(Direction facing) {
        Direction side = facing == this.blockEntity.getFacing() ? this.blockEntity.getOutputFacing() : this.blockEntity.getFacing();
        BlockEntity entity = this.blockEntity.getCachedBlockEntity(side);
        if (entity == null) {
            return LazyOptional.empty();
        }
        return entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.m_122424_());
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.inputFunction.test(this.side)) {
            return stack;
        }
        if (this.coverHandler != null) {
            if (this.coverHandler.blocksInput(IItemHandler.class, this.side)) {
                return stack;
            }
            ItemStack copy = stack.m_41777_();
            if (this.coverHandler.onTransfer((Object)copy, this.side, true, simulate)) {
                return copy;
            }
        }
        return this.getItemHandler(this.side).map(i -> i.insertItem(slot, stack, simulate)).orElse(stack);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.outputFunction.test(this.side)) {
            return ItemStack.f_41583_;
        }
        if (this.coverHandler != null && (this.coverHandler.blocksOutput(IItemHandler.class, this.side) || this.coverHandler.onTransfer((Object)this.getStackInSlot(slot), this.side, false, simulate))) {
            return ItemStack.f_41583_;
        }
        return this.getItemHandler(this.side).map(i -> i.extractItem(slot, amount, simulate)).orElse(ItemStack.f_41583_);
    }

    public int getSlots() {
        return this.getItemHandler(this.side).map(IItemHandler::getSlots).orElse(0);
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.getItemHandler(this.side).map(i -> i.getStackInSlot(slot)).orElse(ItemStack.f_41583_);
    }

    public int getSlotLimit(int slot) {
        return this.getItemHandler(this.side).map(i -> i.getSlotLimit(slot)).orElse(0);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.getItemHandler(this.side).map(i -> i.isItemValid(slot, stack)).orElse(false);
    }
}

