/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.machine.caps;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.CoverHandler;
import org.gtreimagined.gtlib.capability.fluid.FluidHandlerSidedWrapper;
import org.gtreimagined.gtlib.capability.fluid.IFluidNode;
import org.jetbrains.annotations.NotNull;

public class ExtenderSidedFluidWrapper
extends FluidHandlerSidedWrapper {
    BlockEntityMachine<?> blockEntity;

    public ExtenderSidedFluidWrapper(BlockEntityMachine<?> entity, IFluidNode fluidHandler, CoverHandler<?> coverHandler, Direction side) {
        super(fluidHandler, coverHandler, side);
        this.blockEntity = entity;
    }

    LazyOptional<IFluidHandler> getFluidHandler(Direction facing) {
        Direction side = facing == this.blockEntity.getFacing() ? this.blockEntity.getOutputFacing() : this.blockEntity.getFacing();
        BlockEntity entity = this.blockEntity.getCachedBlockEntity(side);
        if (entity == null) {
            return LazyOptional.empty();
        }
        return entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.m_122424_());
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.coverHandler != null) {
            if (this.coverHandler.blocksInput(IFluidHandler.class, this.side)) {
                return 0;
            }
            int oldAmount = resource.getAmount();
            if (this.coverHandler.onTransfer((Object)resource, this.side, true, action.simulate())) {
                return oldAmount - resource.getAmount();
            }
        }
        return this.getFluidHandler(this.side).map(f -> f.fill(resource, action)).orElse(0);
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.coverHandler != null && (this.coverHandler.blocksOutput(IFluidHandler.class, this.side) || this.coverHandler.onTransfer((Object)resource, this.side, false, action.simulate()))) {
            return FluidStack.EMPTY;
        }
        return this.getFluidHandler(this.side).map(f -> f.drain(resource, action)).orElse(FluidStack.EMPTY);
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluidHandler(this.side).map(f -> f.getFluidInTank(tank)).orElse(FluidStack.EMPTY);
    }

    public int getTanks() {
        return this.getFluidHandler(this.side).map(IFluidHandler::getTanks).orElse(0);
    }

    public int getTankCapacity(int tank) {
        return this.getFluidHandler(this.side).map(f -> f.getTankCapacity(tank)).orElse(0);
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.getFluidHandler(this.side).map(f -> f.isFluidValid(tank, stack)).orElse(false);
    }
}

