/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.machine.caps;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.gtreimagined.gt5r.blockentity.IAutocrafter;
import org.gtreimagined.gt5r.machine.caps.ParallelRecipeHandler;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.recipe.IRecipe;
import org.gtreimagined.gtlib.recipe.Recipe;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;
import org.gtreimagined.gtlib.recipe.serializer.MachineRecipeSerializer;
import org.gtreimagined.gtlib.util.Utils;

public class AutocraftingRecipeHandler<T extends BlockEntityMachine<T>>
extends ParallelRecipeHandler<T> {
    public AutocraftingRecipeHandler(T tile, int maxSimultaneousRecipes) {
        super(tile, maxSimultaneousRecipes);
    }

    protected boolean canRecipeContinue() {
        return super.canRecipeContinue() && (!this.activeRecipe.getMapId().isEmpty() || ((IAutocrafter)this.tile).getRecipe() != null && ((IAutocrafter)this.tile).getRecipe().m_6423_().equals((Object)this.activeRecipe.m_6423_()));
    }

    public IRecipe findRecipe() {
        if (this.lastRecipe != null) {
            this.activeRecipe = this.lastRecipe;
            if (this.canRecipeContinue()) {
                this.activeRecipe = null;
                return this.lastRecipe;
            }
            this.activeRecipe = null;
        }
        IRecipe recipe = null;
        if (((IAutocrafter)this.tile).getRecipe() != null) {
            ArrayList condensed = new ArrayList();
            HashMap<Ingredient, Integer> condensedMap = new HashMap<Ingredient, Integer>();
            for (Ingredient i : ((IAutocrafter)this.tile).getRecipe().m_7527_()) {
                if (i.m_43947_()) continue;
                if (!condensedMap.containsKey(i)) {
                    condensedMap.put(i, Math.max(1, RecipeIngredient.count((Ingredient)i)));
                    continue;
                }
                condensedMap.compute(i, (k, currentCount) -> currentCount + Math.max(1, RecipeIngredient.count((Ingredient)i)));
            }
            condensedMap.forEach((k, v) -> condensed.add(RecipeIngredient.of((Ingredient)k, (int)v)));
            recipe = new Recipe(condensed, new ItemStack[]{((IAutocrafter)this.tile).getRecipe().m_8043_()}, List.of(), null, 1024, 16L, 0, 1);
            recipe.setId(((IAutocrafter)this.tile).getRecipe().m_6423_());
            recipe.setMapId("");
            boolean valid = this.validateRecipe(recipe);
            if (!valid) {
                recipe = null;
            }
        }
        if (recipe == null) {
            IRecipeMap map = this.getRecipeMap();
            recipe = map != null ? map.find(this.tile.itemHandler, this.tile.fluidHandler, this.tile.getMachineTier(), x$0 -> this.validateRecipe((IRecipe)x$0)) : null;
        }
        return recipe;
    }

    public void checkRecipe() {
        if (this.activeRecipe != null) {
            return;
        }
        if (!this.tile.hadFirstTick() && this.hasLoadedInput()) {
            if (!this.tile.getMachineState().allowRecipeCheck()) {
                return;
            }
            this.activeRecipe = this.findRecipe();
            if (this.activeRecipe == null) {
                return;
            }
            this.calculateDurations();
            this.lastRecipe = this.activeRecipe;
            return;
        }
        if (this.tile.getMachineState().allowRecipeCheck() && ((this.activeRecipe = this.cachedRecipe()) != null || (this.activeRecipe = this.findRecipe()) != null)) {
            if (!this.validateRecipe(this.activeRecipe)) {
                this.tile.setMachineState(MachineState.INVALID_TIER);
                this.activeRecipe = null;
                return;
            }
            this.calculateDurations();
            if (!this.consumePower(true) || !this.canRecipeContinue()) {
                this.activeRecipe = null;
                this.tile.setMachineState(this.tile.getDefaultMachineState());
                this.tickTimer += 10;
                return;
            }
            this.activateRecipe(true);
            this.tile.setMachineState(MachineState.ACTIVE);
        }
    }

    @Override
    public int getOverclock() {
        if (this.maxSimultaneousRecipes() > 1) {
            return 0;
        }
        if (this.activeRecipe == null) {
            return 0;
        }
        int oc = 0;
        if (this.activeRecipe.getPower() > 0L && this.tile.getPowerLevel().getVoltage() > this.activeRecipe.getPower()) {
            long voltage = this.activeRecipe.getPower();
            int tier = Utils.getVoltageTier((long)voltage);
            long tempoverclock = this.tile.getPowerLevel().getVoltage() / Ref.V[tier];
            while (tempoverclock > 1L) {
                tempoverclock >>= 2;
                ++oc;
            }
        }
        return oc;
    }

    public long getPower() {
        if (this.maxSimultaneousRecipes() > 1) {
            return super.getPower();
        }
        if (this.activeRecipe == null) {
            return 0L;
        }
        if (this.overclock == 0 || this.tile.has("fe")) {
            return this.activeRecipe.getPower();
        }
        return this.activeRecipe.getPower() * (1L << this.overclock) * (1L << this.overclock);
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        if (this.activeRecipe != null) {
            nbt.m_128359_("activeRecipe", this.activeRecipe.toJson().toString());
        }
        if (this.lastRecipe != null) {
            nbt.m_128359_("lastRecipe", this.lastRecipe.toJson().toString());
        }
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        if (nbt.m_128441_("activeRecipe")) {
            this.activeRecipe = MachineRecipeSerializer.INSTANCE.fromJson(new ResourceLocation(nbt.m_128461_("AR")), (JsonObject)JsonParser.parseString((String)nbt.m_128461_("activeRecipe")));
        }
        if (nbt.m_128441_("lastRecipe")) {
            this.lastRecipe = MachineRecipeSerializer.INSTANCE.fromJson(new ResourceLocation(nbt.m_128461_("LR")), (JsonObject)JsonParser.parseString((String)nbt.m_128461_("lastRecipe")));
        }
    }
}

