/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.machine;

import org.gtreimagined.gt5r.blockentity.single.BlockEntitySmallHeatExchanger;
import org.gtreimagined.gt5r.data.GT5RCovers;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.BasicMachine;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.recipe.map.IRecipeMap;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Dir;
import org.gtreimagined.gtlib.util.Utils;

public class HeatExchangerMachine
extends BasicMachine {
    int rate;
    int efficiency = 10000;

    public HeatExchangerMachine(String domain, String id, int rate) {
        super(domain, id);
        this.rate = rate;
        this.setTile((m, p, s) -> new BlockEntitySmallHeatExchanger(this, p, s, this.rate, this.efficiency));
        this.setOverlayTextures((type, state, tier, i) -> {
            String stateDir = (state = state.getTextureState()) == MachineState.IDLE ? "" : state.getId() + "/";
            return new Texture[]{new Texture(domain, "block/machine/overlay/small_heat_exchanger/" + stateDir + "bottom"), new Texture(domain, "block/machine/overlay/small_heat_exchanger/" + stateDir + "top"), new Texture(domain, "block/machine/overlay/small_heat_exchanger/" + stateDir + "back"), new Texture(domain, "block/machine/overlay/small_heat_exchanger/" + stateDir + "front"), new Texture(domain, "block/machine/overlay/small_heat_exchanger/" + stateDir + "side"), new Texture(domain, "block/machine/overlay/small_heat_exchanger/" + stateDir + "side")};
        });
        this.removeFlags(new String[]{"eu"});
        this.setSecondaryOutputCover(GT5RCovers.COVER_OUTPUT_SECONDARY);
        this.setSecondaryOutputDir(Dir.RIGHT);
        this.setAllowsOutputCoversOnFacing(true);
        this.setTiers(new Tier[]{Tier.NONE});
        this.setBaseTexture(new Texture("gt5r", "block/machine/base/" + id));
        ((BasicMachine)((BasicMachine)((BasicMachine)this.setMap((IRecipeMap)RecipeMaps.HEAT_EXCHANGER, new Tier[0])).addFlags(new String[]{"gui", "item", "fluid"})).setAllowsFrontCovers()).setAllowsFrontIO();
        this.addTooltipInfo((machine, stack, world, tooltip, flag) -> {
            tooltip.add(Utils.translatable((String)"tooltip.gt5r.small_heat_exchanger.heat_rate", (Object[])new Object[]{rate}));
            tooltip.add(Utils.translatable((String)"tooltip.gt5r.small_heat_exchanger.efficiency", (Object[])new Object[]{(double)this.efficiency / 100.0 + "%"}));
        });
        ((Machine)((Machine)((Machine)((Machine)((Machine)this.add(SlotType.IT_IN, 53, 25)).add(SlotType.IT_OUT, 107, 25)).add(SlotType.FL_IN, 44, 63)).add(SlotType.FL_IN, 62, 63)).add(SlotType.FL_OUT, 107, 63)).add(SlotType.FL_OUT, 125, 63);
    }

    public HeatExchangerMachine setEfficiency(int efficiency) {
        if (efficiency > 10000) {
            efficiency = 10000;
        }
        if (efficiency < 0) {
            efficiency = 0;
        }
        this.efficiency = efficiency;
        return this;
    }

    public int getRate() {
        return this.rate;
    }

    public int getEfficiency() {
        return this.efficiency;
    }
}

