/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.machines;

import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.GT5RConfig;
import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.ore.CobbleStoneType;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;

public class SmelterLoader {
    public static void init() {
        MaterialTypeItem[] items;
        for (MaterialTypeItem item : items = new MaterialTypeItem[]{GTMaterialTypes.INGOT, GTMaterialTypes.NUGGET, GTMaterialTypes.PLATE, GTMaterialTypes.DENSE_PLATE, GTMaterialTypes.ROD, GTMaterialTypes.LONG_ROD, GTMaterialTypes.RING, GTMaterialTypes.FOIL, GTMaterialTypes.BOLT, GTMaterialTypes.SCREW, GTMaterialTypes.GEAR, GTMaterialTypes.SMALL_GEAR, GTMaterialTypes.FINE_WIRE, GTMaterialTypes.ROTOR}) {
            item.all().forEach(m -> {
                long amount = m == Materials.Alumina ? item.getUnitValue() * 7L / 2L : item.getUnitValue();
                SmelterLoader.add(m, item, amount);
            });
        }
        GTMaterialTypes.DUST.all().forEach(m -> {
            if (!m.has(new IMaterialTag[]{GT5RMaterialTags.NEEDS_BLAST_FURNACE})) {
                long amount = m == Materials.Alumina ? GTMaterialTypes.DUST.getUnitValue() * 7L / 2L : GTMaterialTypes.DUST.getUnitValue();
                SmelterLoader.add(m, GTMaterialTypes.DUST, amount);
            }
        });
        if (GT5RConfig.HARDER_ALUMINIUM_PROCESSING.get()) {
            RecipeMaps.SMELTER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.AluminiumHydroxide, 1)}).fo(new FluidStack[]{Materials.Alumina.getLiquid(180)}).add("aluminium_hydroxide_to_alumina", 55L, 16L);
        }
        SmelterLoader.addLava(Materials.Obsidian, GTMaterialTypes.LONG_ROD, GTMaterialTypes.LONG_ROD.getUnitValue());
        SmelterLoader.addLava(Materials.Obsidian, GTMaterialTypes.PLATE, GTMaterialTypes.PLATE.getUnitValue());
        SmelterLoader.addLava(Materials.Obsidian, GTMaterialTypes.DUST, GTMaterialTypes.DUST.getUnitValue());
        RecipeMaps.SMELTER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Limestone, 1)}).fo(new FluidStack[]{Materials.Calcite.getLiquid(144)}).add("limestone_dust_to_calcite", Materials.Limestone.getMass(), 24L);
        RecipeMaps.SMELTER.RB().ii(new ItemLike[]{GTCoreBlocks.LIMESTONE.getState().m_60734_()}).fo(new FluidStack[]{Materials.Calcite.getLiquid(144)}).add("limestone_to_calcite", Materials.Limestone.getMass(), 24L);
        RecipeMaps.SMELTER.RB().ii(new ItemLike[]{((CobbleStoneType)GTCoreBlocks.LIMESTONE).getBlock("cobble")}).fo(new FluidStack[]{Materials.Calcite.getLiquid(144)}).add("limestone_cobble_to_calcite", Materials.Limestone.getMass(), 24L);
        RecipeMaps.SMELTER.RB().ii(new ItemLike[]{Blocks.f_152497_}).fo(new FluidStack[]{Materials.Calcite.getLiquid(144)}).add("mc_calcite_to_calcite", Materials.Limestone.getMass(), 24L);
    }

    private static void add(Material m, MaterialTypeItem<?> i, long materialAmount) {
        Material molten = (Material)MaterialTags.MELT_INTO.get(m);
        if (!molten.has(new IMaterialTag[]{GTMaterialTypes.LIQUID})) {
            return;
        }
        int amount = (int)(144L * materialAmount / 18144000L);
        long duration = Math.max(1L, 24L * materialAmount / 18144000L);
        RecipeMaps.SMELTER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)i.getMaterialTag(m), (int)1)}).fo(new FluidStack[]{molten.getLiquid(amount)}).add(m.getId() + "_from_" + i.getId(), (long)((float)m.getMass() * ((float)amount / 144.0f)), (long)Math.max(8, (int)Math.sqrt(2 * MaterialTags.MELTING_POINT.getInt(m))), duration);
    }

    private static void addLava(Material m, MaterialTypeItem<?> i, long materialAmount) {
        long flUnit = 111L;
        int amount = (int)(flUnit * materialAmount / 18144000L);
        long duration = Math.max(1L, 24L * materialAmount / 18144000L);
        RecipeMaps.SMELTER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)i.getMaterialTag(m), (int)1)}).fo(new FluidStack[]{Materials.Lava.getLiquid(amount)}).add(m.getId() + "_from_" + i.getId(), (long)((float)m.getMass() * ((float)amount / 144.0f)), (long)Math.max(8, (int)Math.sqrt(2 * MaterialTags.MELTING_POINT.getInt(m))), duration);
    }
}

