/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.machines;

import java.util.function.ToLongFunction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtcore.block.RedstoneWire;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreMaterials;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.pipe.PipeItemBlock;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.FluidPipe;
import org.gtreimagined.gtlib.pipe.types.HeatPipe;
import org.gtreimagined.gtlib.pipe.types.ItemPipe;
import org.gtreimagined.gtlib.pipe.types.PipeType;
import org.gtreimagined.gtlib.pipe.types.Wire;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.tool.GTToolType;

public class ExtruderLoader {
    public static void init() {
        ToLongFunction<Material> energyPerTick = m -> m.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) ? 16L : 128L;
        ToLongFunction<Material> baseDuration = m -> {
            if (m.has(new IMaterialTag[]{GT5RMaterialTags.RECIPE_MASS})) {
                return ((Integer)GT5RMaterialTags.RECIPE_MASS.get(m)).intValue();
            }
            return m.getMass();
        };
        RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{GTMaterialTypes.INGOT.getMaterialIngredient(Materials.Zirconium, 1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeCell, (int)1).setNoConsume()}).io(new Item[]{GT5RItems.EmptyNuclearFuelRod}).add("empty_nuclear_rod", 216L, 96L);
        RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(GTCoreMaterials.Beeswax, 1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeBottle, (int)1).setNoConsume()}).io(new Item[]{GTCoreItems.EmptyWaxPill}).add("empty_wax_pill", 64L, 16L);
        RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Glass, 1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeBottle, (int)1).setNoConsume()}).io(new Item[]{Items.f_42590_}).add("glass_bottle", 64L, 16L);
        GTMaterialTypes.RING.all().forEach(r -> {
            if (r.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(r), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeRing, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.RING.get(r, 4)}).add("ring_" + r.getId(), baseDuration.applyAsLong((Material)r), energyPerTick.applyAsLong((Material)r));
            }
            if (r.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && r.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) && !r.has(new IMaterialTag[]{MaterialTags.WOOD})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(r), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeRing, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.RING.get(r, 4)}).add("ring_" + r.getId() + "_from_dust", baseDuration.applyAsLong((Material)r), energyPerTick.applyAsLong((Material)r));
            }
        });
        GTMaterialTypes.FOIL.all().forEach(r -> {
            if (r.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(r), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeFoil, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.FOIL.get(r, 4)}).add("foil_" + r.getId(), baseDuration.applyAsLong((Material)r), energyPerTick.applyAsLong((Material)r));
            }
            if (r.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && r.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) && !r.has(new IMaterialTag[]{MaterialTags.WOOD})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(r), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeFoil, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.FOIL.get(r, 4)}).add("foil_" + r.getId() + "_from_dust", baseDuration.applyAsLong((Material)r), energyPerTick.applyAsLong((Material)r));
            }
        });
        GTMaterialTypes.FINE_WIRE.all().forEach(r -> {
            if (r.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(r), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeFineWire, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.FINE_WIRE.get(r, 8)}).add("fine_wire_" + r.getId(), baseDuration.applyAsLong((Material)r), energyPerTick.applyAsLong((Material)r));
            }
            if (r.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && r.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) && !r.has(new IMaterialTag[]{MaterialTags.WOOD})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(r), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeFineWire, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.FINE_WIRE.get(r, 8)}).add("fine_wire_" + r.getId() + "_from_dust", baseDuration.applyAsLong((Material)r), energyPerTick.applyAsLong((Material)r));
            }
        });
        GTMaterialTypes.TINY_PLATE.all().forEach(r -> {
            if (r.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(r), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeTinyPlate, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.TINY_PLATE.get(r, 9)}).add("tiny_plate_" + r.getId(), baseDuration.applyAsLong((Material)r), energyPerTick.applyAsLong((Material)r));
            }
            if (r.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && r.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) && !r.has(new IMaterialTag[]{MaterialTags.WOOD})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(r), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeTinyPlate, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.TINY_PLATE.get(r, 9)}).add("tiny_plate_" + r.getId() + "_from_dust", baseDuration.applyAsLong((Material)r), energyPerTick.applyAsLong((Material)r));
            }
        });
        GTMaterialTypes.GEAR.all().forEach(g -> {
            if (g.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(g), (int)4), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeGear, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.GEAR.get(g, 1)}).add("gear_" + g.getId(), baseDuration.applyAsLong((Material)g) * 4L, energyPerTick.applyAsLong((Material)g));
            }
            if (g.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && g.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) && !g.has(new IMaterialTag[]{MaterialTags.WOOD})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(g), (int)4), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeGear, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.GEAR.get(g, 1)}).add("gear_" + g.getId() + "_from_dust", baseDuration.applyAsLong((Material)g) * 4L, energyPerTick.applyAsLong((Material)g));
            }
        });
        GTMaterialTypes.BOLT.all().forEach(b -> {
            if (b.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(b), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeBolt, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.BOLT.get(b, 8)}).add("bolt_" + b.getId(), baseDuration.applyAsLong((Material)b), energyPerTick.applyAsLong((Material)b));
            }
            if (b.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && b.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) && !b.has(new IMaterialTag[]{MaterialTags.WOOD})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(b), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeBolt, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.BOLT.get(b, 8)}).add("bolt_" + b.getId() + "_from_dust", baseDuration.applyAsLong((Material)b), energyPerTick.applyAsLong((Material)b));
            }
        });
        GTMaterialTypes.SMALL_GEAR.all().forEach(g -> {
            if (g.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(g), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeGearSmall, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.SMALL_GEAR.get(g, 1)}).add("gear_small_" + g.getId(), baseDuration.applyAsLong((Material)g), energyPerTick.applyAsLong((Material)g));
            }
            if (g.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && g.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) && !g.has(new IMaterialTag[]{MaterialTags.WOOD})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(g), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeGearSmall, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.SMALL_GEAR.get(g, 1)}).add("gear_small_" + g.getId() + "_from_dust", baseDuration.applyAsLong((Material)g), energyPerTick.applyAsLong((Material)g));
            }
        });
        GTMaterialTypes.PLATE.all().forEach(p -> {
            if (p.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(p), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapePlate, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.PLATE.get(p, 1)}).add("plate_" + p.getId(), baseDuration.applyAsLong((Material)p), energyPerTick.applyAsLong((Material)p));
            }
            if (p.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && p.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) && !p.has(new IMaterialTag[]{MaterialTags.WOOD})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(p), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapePlate, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.PLATE.get(p, 1)}).add("plate_" + p.getId() + "_from_dust", baseDuration.applyAsLong((Material)p), energyPerTick.applyAsLong((Material)p));
            }
        });
        GTMaterialTypes.ITEM_CASING.all().forEach(r -> {
            if (r.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(r), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeCasing, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.ITEM_CASING.get(r, 2)}).add("item_casing_" + r.getId(), baseDuration.applyAsLong((Material)r), energyPerTick.applyAsLong((Material)r));
            }
            if (r.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && r.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) && !r.has(new IMaterialTag[]{MaterialTags.WOOD})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(r), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeCasing, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.ITEM_CASING.get(r, 2)}).add("item_casing_" + r.getId() + "_from_dust", baseDuration.applyAsLong((Material)r), energyPerTick.applyAsLong((Material)r));
            }
        });
        GTMaterialTypes.ROD.all().forEach(r -> {
            if (r.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(r), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeRod, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.ROD.get(r, 2)}).add("rod_" + r.getId(), baseDuration.applyAsLong((Material)r), energyPerTick.applyAsLong((Material)r));
            }
            if (r.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && !r.has(new IMaterialTag[]{MaterialTags.WOOD}) && (r.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) || !r.has(new IMaterialTag[]{GTMaterialTypes.INGOT}) && !r.has(new IMaterialTag[]{GTMaterialTypes.GEM}) && r != Materials.Obsidian)) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(r), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeRod, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.ROD.get(r, 2)}).add("rod_" + r.getId() + "_from_dust", baseDuration.applyAsLong((Material)r), energyPerTick.applyAsLong((Material)r));
            }
        });
        GTMaterialTypes.LONG_ROD.all().forEach(r -> {
            if (r.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(r), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeLongRod, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.LONG_ROD.get(r, 1)}).add("long_rod_" + r.getId(), baseDuration.applyAsLong((Material)r), energyPerTick.applyAsLong((Material)r));
            }
            if (r.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && !r.has(new IMaterialTag[]{MaterialTags.WOOD}) && (r.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) || r == Materials.Endstone)) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(r), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeLongRod, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.LONG_ROD.get(r, 1)}).add("long_rod_" + r.getId() + "_from_dust", baseDuration.applyAsLong((Material)r), energyPerTick.applyAsLong((Material)r));
            }
        });
        MaterialTags.RUBBERTOOLS.all().forEach(p -> {
            if (p.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && p.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(p), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeIngot, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.INGOT.get(p, 1)}).add("ingot_" + p.getId() + "_from_dust", baseDuration.applyAsLong((Material)p), energyPerTick.applyAsLong((Material)p));
            }
        });
        GTMaterialTypes.BLOCK.all().forEach(p -> {
            if (p.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(p), (int)9), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeBlock, (int)1).setNoConsume()}).io(new ItemStack[]{((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.BLOCK.get()).get(p).asStack()}).add("block_" + p.getId(), baseDuration.applyAsLong((Material)p) * 9L, energyPerTick.applyAsLong((Material)p));
            }
            if (p.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && p.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) && !p.has(new IMaterialTag[]{MaterialTags.WOOD})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(p), (int)9), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeBlock, (int)1).setNoConsume()}).io(new ItemStack[]{((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.BLOCK.get()).get(p).asStack()}).add("block_" + p.getId() + "_from_dust", baseDuration.applyAsLong((Material)p) * 9L, energyPerTick.applyAsLong((Material)p));
            }
        });
        MaterialTags.TOOLS.getAll().forEach((m, t) -> {
            GTToolType[] toolHeadTypes = new GTToolType[]{GTTools.PICKAXE, GTTools.AXE, GTTools.SWORD, GTTools.SHOVEL, GTTools.HOE, GTTools.FILE, GTTools.SAW, GTTools.HAMMER};
            Item[] toolHeadShapes = new Item[]{GTCoreItems.ShapeHeadPickaxe, GTCoreItems.ShapeHeadAxe, GTCoreItems.ShapeBladeSword, GTCoreItems.ShapeHeadShovel, GTCoreItems.ShapeHeadHoe, GTCoreItems.ShapeHeadFile, GTCoreItems.ShapeBladeSaw, GTCoreItems.ShapeHeadHammer};
            int i = 0;
            for (GTToolType type : toolHeadTypes) {
                if (t.toolTypes().contains(type)) {
                    MaterialTypeItem itemType = type.getMaterialTypeItem();
                    if (itemType == null) continue;
                    if (m.has(new IMaterialTag[]{itemType})) {
                        int amountIn;
                        int n = type == GTTools.PICKAXE || type == GTTools.AXE ? 3 : (type == GTTools.HAMMER ? 6 : (amountIn = type == GTTools.SHOVEL ? 1 : 2));
                        if (m.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                            RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(m), (int)amountIn), RecipeIngredient.of((ItemLike)toolHeadShapes[i], (int)1).setNoConsume()}).io(new ItemStack[]{itemType.get(m, 1)}).add(itemType.getId() + "_" + m.getId(), baseDuration.applyAsLong((Material)m) * (long)amountIn, energyPerTick.applyAsLong((Material)m));
                        }
                        if (m.has(new IMaterialTag[]{GTMaterialTypes.DUST}) && m.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) && !m.has(new IMaterialTag[]{MaterialTags.WOOD})) {
                            RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(m), (int)amountIn), RecipeIngredient.of((ItemLike)toolHeadShapes[i], (int)1).setNoConsume()}).io(new ItemStack[]{itemType.get(m, 1)}).add(itemType.getId() + "_" + m.getId() + "_from_dust", baseDuration.applyAsLong((Material)m) * (long)amountIn, energyPerTick.applyAsLong((Material)m));
                        }
                    }
                }
                ++i;
            }
        });
        GTAPI.all(Wire.class).forEach(t -> {
            PipeItemBlock wireItem = t.getBlockItem(PipeSize.VTINY);
            ItemStack stack = new ItemStack((ItemLike)wireItem, 2);
            if (t.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(t.getMaterial()), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeWire, (int)1).setNoConsume()}).io(new ItemStack[]{stack}).add("wire_" + t.getMaterial().getId(), baseDuration.applyAsLong(t.getMaterial()), energyPerTick.applyAsLong(t.getMaterial()));
            }
            if (t.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.DUST}) && t.getMaterial().has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(t.getMaterial()), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeWire, (int)1).setNoConsume()}).io(new ItemStack[]{stack}).add("wire_" + t.getMaterial().getId() + "_from_dust", baseDuration.applyAsLong(t.getMaterial()), energyPerTick.applyAsLong(t.getMaterial()));
            }
        });
        GTAPI.all(RedstoneWire.class).forEach(t -> {
            PipeItemBlock wireItem = t.getBlockItem(PipeSize.VTINY);
            ItemStack stack = new ItemStack((ItemLike)wireItem, 2);
            if (t.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.INGOT.getMaterialTag(t.getMaterial()), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeWire, (int)1).setNoConsume()}).io(new ItemStack[]{stack}).add("wire_" + t.getMaterial().getId(), baseDuration.applyAsLong(t.getMaterial()), energyPerTick.applyAsLong(t.getMaterial()));
            }
            if (t.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.DUST}) && t.getMaterial().has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) && !t.getMaterial().has(new IMaterialTag[]{MaterialTags.WOOD})) {
                RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(t.getMaterial()), (int)1), RecipeIngredient.of((ItemLike)GTCoreItems.ShapeWire, (int)1).setNoConsume()}).io(new ItemStack[]{stack}).add("wire_" + t.getMaterial().getId() + "_from_dust", baseDuration.applyAsLong(t.getMaterial()), energyPerTick.applyAsLong(t.getMaterial()));
            }
        });
        GTAPI.all(FluidPipe.class).stream().filter(t -> t.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.INGOT})).forEach(t -> {
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 1, 2, PipeSize.TINY, t, 2);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 1, 1, PipeSize.SMALL, t, 1);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 3, 1, PipeSize.NORMAL, t, 3);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 6, 1, PipeSize.LARGE, t, 6);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 12, 1, PipeSize.HUGE, t, 12);
        });
        GTAPI.all(ItemPipe.class).forEach(t -> {
            if (!t.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                return;
            }
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 1, 2, PipeSize.TINY, t, 2);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 1, 1, PipeSize.SMALL, t, 1);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 3, 1, PipeSize.NORMAL, t, 3);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 6, 1, PipeSize.LARGE, t, 6);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 12, 1, PipeSize.HUGE, t, 12);
        });
        GTAPI.all(HeatPipe.class).forEach(t -> {
            if (!t.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                return;
            }
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 1, 2, PipeSize.TINY, t, 10);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 1, 1, PipeSize.SMALL, t, 20);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 3, 1, PipeSize.NORMAL, t, 30);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 6, 1, PipeSize.LARGE, t, 40);
            ExtruderLoader.addPipeRecipe(t.getMaterial(), 12, 1, PipeSize.HUGE, t, 50);
        });
    }

    private static void addPipeRecipe(Material material, int countIn, int countOut, PipeSize size, PipeType<?> pipe, int durationMultiplier) {
        if (pipe.getSizes().contains((Object)size)) {
            long duration = material.has(new IMaterialTag[]{GT5RMaterialTags.RECIPE_MASS}) ? (long)((Integer)GT5RMaterialTags.RECIPE_MASS.get(material)).intValue() : Math.max(material.getMass(), 1L);
            RecipeMaps.EXTRUDER.RB().ii(new Ingredient[]{GTMaterialTypes.INGOT.getMaterialIngredient(material, countIn), RecipeIngredient.of((ItemLike)ExtruderLoader.getPipeMold(size), (int)1).setNoConsume()}).io(new ItemStack[]{new ItemStack((ItemLike)pipe.getBlockItem(size), countOut)}).add(size.getId() + "_" + pipe.getType() + "_" + material.getId(), duration * (long)durationMultiplier, 30L);
        }
    }

    private static Item getPipeMold(PipeSize size) {
        return switch (size) {
            case PipeSize.HUGE -> GTCoreItems.ShapePipeHuge;
            case PipeSize.LARGE -> GTCoreItems.ShapePipeLarge;
            case PipeSize.NORMAL -> GTCoreItems.ShapePipeNormal;
            case PipeSize.SMALL -> GTCoreItems.ShapePipeSmall;
            case PipeSize.TINY, PipeSize.VTINY -> GTCoreItems.ShapePipeTiny;
            default -> Items.f_41852_;
        };
    }
}

