/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.machines;

import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gt5r.items.ItemDepletedRod;
import org.gtreimagined.gt5r.items.ItemEnrichedRod;
import org.gtreimagined.gtcore.data.GTCoreFluids;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreMaterials;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.recipe.map.RecipeBuilder;
import org.gtreimagined.gtlib.util.RegistryUtils;

public class CentrifugeLoader {
    public static void init() {
        GTMaterialTypes.IMPURE_DUST.all().forEach(dust -> {
            Material aOreByProduct;
            Material material = aOreByProduct = !dust.getByProducts().isEmpty() ? (Material)dust.getByProducts().get(0) : MaterialTags.MACERATE_INTO.getMapping(dust);
            if (!aOreByProduct.has(new IMaterialTag[]{GTMaterialTypes.DUST})) {
                return;
            }
            RecipeMaps.CENTRIFUGE.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTMaterialTypes.IMPURE_DUST.get(dust), (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)GTMaterialTypes.DUST.get(dust), 1), GTMaterialTypes.TINY_DUST.get(aOreByProduct, 1)}).add("dust_impure_" + dust.getId(), 400L, 2L);
        });
        GTMaterialTypes.PURE_DUST.all().forEach(dust -> {
            Material aOreByProduct;
            Material material = dust.getByProducts().size() > 1 ? (Material)dust.getByProducts().get(1) : (aOreByProduct = !dust.getByProducts().isEmpty() ? (Material)dust.getByProducts().get(0) : MaterialTags.MACERATE_INTO.getMapping(dust));
            if (!aOreByProduct.has(new IMaterialTag[]{GTMaterialTypes.DUST})) {
                return;
            }
            RecipeMaps.CENTRIFUGE.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTMaterialTypes.PURE_DUST.get(dust), (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)GTMaterialTypes.DUST.get(dust), 1), GTMaterialTypes.TINY_DUST.get(aOreByProduct, 1)}).add("dust_pure_" + dust.getId(), dust.getMass(), 2L);
        });
        GT5RMaterialTags.CENT.all().forEach(t -> {
            if (!(t.has(new IMaterialTag[]{GTMaterialTypes.DUST}) || t.has(new IMaterialTag[]{GTMaterialTypes.LIQUID}) || t.has(new IMaterialTag[]{GTMaterialTypes.GAS}))) {
                return;
            }
            FluidStack[] fluids = (FluidStack[])t.getProcessInto().stream().filter(mat -> (mat.m.has(new IMaterialTag[]{GTMaterialTypes.GAS}) || mat.m.has(new IMaterialTag[]{GTMaterialTypes.LIQUID})) && !mat.m.has(new IMaterialTag[]{GTMaterialTypes.DUST})).map(mat -> mat.m.has(new IMaterialTag[]{GTMaterialTypes.GAS}) ? mat.m.getGas(mat.s * 1000) : mat.m.getLiquid(mat.s * 1000)).toArray(FluidStack[]::new);
            if (fluids.length > 6) {
                return;
            }
            for (FluidStack fluid : fluids) {
                if (!fluid.isEmpty()) continue;
                return;
            }
            ItemStack[] items = (ItemStack[])t.getProcessInto().stream().filter(mat -> mat.m.has(new IMaterialTag[]{GTMaterialTypes.DUST})).map(mat -> GTMaterialTypes.DUST.get(mat.m, mat.s)).toArray(ItemStack[]::new);
            int inputAmount = (Integer)((Pair)MaterialTags.PROCESS_INTO.get(t)).getRight() > 0 ? ((Integer)((Pair)MaterialTags.PROCESS_INTO.get(t)).getRight()).intValue() : t.getProcessInto().stream().mapToInt(mat -> mat.s).sum();
            RecipeBuilder b = RecipeMaps.CENTRIFUGE.RB();
            if (t.has(new IMaterialTag[]{GTMaterialTypes.DUST})) {
                b.ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(t, inputAmount)});
            } else {
                b.fi(new FluidStack[]{t.has(new IMaterialTag[]{GTMaterialTypes.LIQUID}) ? t.getLiquid(inputAmount * 1000) : t.getGas(inputAmount * 1000)});
            }
            int euPerTick = t.has(new IMaterialTag[]{GT5RMaterialTags.CENT5}) ? 5 : (t.has(new IMaterialTag[]{GT5RMaterialTags.CENT10}) ? 10 : (t.has(new IMaterialTag[]{GT5RMaterialTags.CENT15}) ? 15 : (t.has(new IMaterialTag[]{GT5RMaterialTags.CENT20}) ? 20 : 16)));
            b.io(items).fo(fluids).add("dust_" + t.getId(), t.getMass() * 4L, (long)euPerTick);
        });
        RecipeMaps.CENTRIFUGE.RB().fi(new FluidStack[]{Materials.Lava.getLiquid(100)}).io(new Item[]{GTMaterialTypes.NUGGET.get(Materials.Copper), GTMaterialTypes.NUGGET.get(Materials.Tin), GTMaterialTypes.NUGGET.get(Materials.Gold), GTMaterialTypes.NUGGET.get(Materials.Silver), GTMaterialTypes.NUGGET.get(Materials.Tantalum), GTMaterialTypes.SMALL_DUST.get(Materials.Tungstate)}).outputChances(new double[]{0.2, 0.1, 0.025, 0.025, 0.025, 0.025}).add("lava", 80L, 80L);
        RecipeMaps.CENTRIFUGE.RB().fi(new FluidStack[]{new FluidStack((Fluid)GTCoreFluids.PAHOEHOE_LAVA.getFluid(), 100)}).io(new Item[]{GTMaterialTypes.NUGGET.get(Materials.Copper), GTMaterialTypes.NUGGET.get(Materials.Tin), GTMaterialTypes.NUGGET.get(Materials.Gold), GTMaterialTypes.NUGGET.get(Materials.Silver), GTMaterialTypes.NUGGET.get(Materials.Tantalum), GTMaterialTypes.SMALL_DUST.get(Materials.Tungstate)}).outputChances(new double[]{0.2, 0.1, 0.025, 0.025, 0.025, 0.025}).add("pahoehoe_lava", 40L, 80L);
        RecipeMaps.CENTRIFUGE.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42525_, (int)10)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Gold, 5), GTMaterialTypes.DUST.get(Materials.Redstone, 5)}).fo(new FluidStack[]{Materials.Helium.getGas(1000)}).add("glowstone_to_helium", 2920L, 16L);
        RecipeMaps.CENTRIFUGE.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42542_, (int)1)}).io(new Item[]{Items.f_42593_, Items.f_42518_}).add("magma_cream", 500L, 5L);
        RecipeMaps.CENTRIFUGE.RB().ii(new ItemLike[]{Items.f_42049_}).io(new Item[]{GTMaterialTypes.SMALL_DUST.get(Materials.Saltpeter), GTMaterialTypes.TINY_DUST.get(Materials.Coal), Items.f_41830_}).outputChances(new double[]{0.8, 0.2, 1.0}).fo(new FluidStack[]{Materials.Oil.getLiquid(40)}).add("oil_from_soulsand", 200L, 80L);
        RecipeMaps.CENTRIFUGE.RB().ii(new ItemLike[]{Items.f_42050_}).io(new Item[]{GTMaterialTypes.TINY_DUST.get(Materials.Coal), Items.f_42329_}).outputChances(new double[]{0.2, 1.0}).fo(new FluidStack[]{Materials.Oil.getLiquid(40)}).add("oil_from_soulsoil", 200L, 80L);
        RecipeMaps.CENTRIFUGE.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.RareEarth, 1)}).io(new Item[]{GTMaterialTypes.SMALL_DUST.get(Materials.Neodymium), GTMaterialTypes.SMALL_DUST.get(Materials.Yttrium), GTMaterialTypes.SMALL_DUST.get(Materials.Cerium), GTMaterialTypes.SMALL_DUST.get(Materials.Cadmium), GTMaterialTypes.SMALL_DUST.get(Materials.Caesium)}).outputChances(new double[]{0.25, 0.25, 0.25, 0.25, 0.25}).add("rare_earth", 64L, 20L);
        RecipeMaps.CENTRIFUGE.RB().fi(new FluidStack[]{Materials.RefineryGas.getGas(800)}).fo(new FluidStack[]{Materials.LPG.getLiquid(400)}).add("refinery_gas", 20L, 5L);
        RecipeMaps.CENTRIFUGE.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.PlatinumGroupSludge, 1)}).io(new Item[]{GTMaterialTypes.TINY_DUST.get(Materials.Platinum), GTMaterialTypes.TINY_DUST.get(Materials.Palladium), GTMaterialTypes.TINY_DUST.get(Materials.Iridium), GTMaterialTypes.TINY_DUST.get(Materials.Osmium)}).outputChances(new double[]{1.0, 0.8, 0.6, 0.6}).add("platinum_group_sludge", 900L, 30L);
        RecipeMaps.CENTRIFUGE.RB().fi(new FluidStack[]{Materials.UraniumHexafluoride.getGas(1400)}).fo(new FluidStack[]{Materials.Uranium238Hexafluoride.getGas(1000), Materials.Uranium235Hexafluoride.getGas(400)}).add("uranium_hexafluoride", 24L, 512L);
        RecipeMaps.CENTRIFUGE.RB().fi(new FluidStack[]{Materials.Water.getLiquid(100000)}).fo(new FluidStack[]{Materials.SemiheavyWater.getLiquid(100), Materials.HeavyWater.getLiquid(10), Materials.TritiatedWater.getLiquid(1)}).add("heavy_water", 64L, 64L);
        RecipeMaps.CENTRIFUGE.RB().fi(new FluidStack[]{Materials.SemiheavyWater.getLiquid(500)}).fo(new FluidStack[]{Materials.HeavyWater.getLiquid(50), Materials.TritiatedWater.getLiquid(5)}).add("heavy_water_2", 32L, 64L);
        RecipeMaps.CENTRIFUGE.RB().ii(new Ingredient[]{GTMaterialTypes.REFINED_ORE.getMaterialIngredient(Materials.Cobalt, 1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Cobalt, 1), GTMaterialTypes.TINY_DUST.get(Materials.Cobalt60, 2)}).add("cobalt_60", 2304L, 512L);
        RecipeMaps.CENTRIFUGE.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Endstone, 1)}).io(new Item[]{GTMaterialTypes.DUST.get(Materials.Sand), GTMaterialTypes.TINY_DUST.get(Materials.Platinum), GTMaterialTypes.TINY_DUST.get(Materials.TungstenTrioxide)}).outputChances(new double[]{0.8, 0.01, 0.03}).fo(new FluidStack[]{Materials.Helium.getGas(120)}).add("endstone_dust", 320L, 20L);
        RecipeMaps.CENTRIFUGE.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Netherrack, 1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Stone, 1), GTMaterialTypes.TINY_DUST.get(Materials.Sulfur, 2), GTMaterialTypes.TINY_DUST.get(Materials.Redstone, 1), GTMaterialTypes.TINY_DUST.get(Materials.Coal, 1), GTMaterialTypes.TINY_DUST.get(Materials.Gold, 1)}).outputChances(new double[]{0.8, 0.05, 0.05, 0.05, 0.01}).add("netherrack_dust", 160L, 20L);
        RecipeMaps.CENTRIFUGE.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_((TagKey)GTCoreTags.RUBBER_LOGS)}).io(new ItemStack[]{new ItemStack((ItemLike)GTCoreItems.StickyResin), new ItemStack((ItemLike)GTCoreItems.Plantball), GTMaterialTypes.DUST.get(Materials.Carbon, 1), GTMaterialTypes.DUST.get(Materials.Wood, 1)}).fo(new FluidStack[]{Materials.Methane.getGas(60)}).outputChances(new double[]{0.5, 0.375, 0.25, 0.25}).add("rubber_logs", 200L, 20L);
        RecipeMaps.CENTRIFUGE.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.StickyResin, (int)1)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.RawRubber, 3), new ItemStack((ItemLike)GTCoreItems.Plantball)}).fo(new FluidStack[]{Materials.Glue.getLiquid(100)}).outputChances(new double[]{1.0, 0.1}).add("sticky_resin", 300L, 5L);
        RecipeMaps.CENTRIFUGE.RB().ii(new ItemLike[]{Items.f_42784_}).io(new Item[]{GTMaterialTypes.DUST.get(GTCoreMaterials.Beeswax)}).fo(new FluidStack[]{Materials.Honey.getLiquid(100)}).add("honeycomb", 128L, 5L);
        CentrifugeLoader.addMethaneRecipe(Items.f_42028_, 9, 72);
        CentrifugeLoader.addMethaneRecipe(Items.f_42406_, 9, 72);
        CentrifugeLoader.addMethaneRecipe(Items.f_42572_, 9, 72);
        CentrifugeLoader.addMethaneRecipe(Items.f_41952_, 18, 144);
        CentrifugeLoader.addMethaneRecipe(Items.f_41953_, 18, 144);
        CentrifugeLoader.addMethaneRecipe(Items.f_42410_, 18, 144);
        CentrifugeLoader.addMethaneRecipe(Items.f_42588_, 18, 144);
        CentrifugeLoader.addMethaneRecipe(Items.f_42591_, 18, 144);
        CentrifugeLoader.addMethaneRecipe(Items.f_42674_, 24, 192);
        CentrifugeLoader.addMethaneRecipe(Items.f_42046_, 36, 288);
        CentrifugeLoader.addMethaneRecipe(Items.f_42580_, 36, 288);
        CentrifugeLoader.addMethaneRecipe(Items.f_42620_, 36, 288);
        CentrifugeLoader.addMethaneRecipe(Items.f_42486_, 36, 288);
        CentrifugeLoader.addMethaneRecipe(Items.f_42583_, 36, 288);
        CentrifugeLoader.addMethaneRecipe(Items.f_42619_, 36, 288);
        CentrifugeLoader.addMethaneRecipe(Items.f_42732_, 36, 288);
        CentrifugeLoader.addMethaneRecipe(Items.f_42531_, 36, 288);
        CentrifugeLoader.addMethaneRecipe(Items.f_42530_, 36, 288);
        CentrifugeLoader.addMethaneRecipe(Items.f_42582_, 36, 288);
        CentrifugeLoader.addMethaneRecipe(Items.f_42659_, 36, 288);
        CentrifugeLoader.addMethaneRecipe(Items.f_42698_, 36, 288);
        CentrifugeLoader.addMethaneRecipe(Items.f_42400_, 36, 288, new ItemStack((ItemLike)Items.f_42399_));
        CentrifugeLoader.addMethaneRecipe(Items.f_42730_, 36, 288);
        CentrifugeLoader.addMethaneRecipe(Items.f_42579_, 48, 384);
        CentrifugeLoader.addMethaneRecipe(Items.f_42581_, 48, 384);
        CentrifugeLoader.addMethaneRecipe(Items.f_42485_, 48, 384);
        CentrifugeLoader.addMethaneRecipe(Items.f_42658_, 48, 384);
        CentrifugeLoader.addMethaneRecipe(Items.f_42697_, 48, 384);
        CentrifugeLoader.addMethaneRecipe(Items.f_42526_, 48, 384);
        CentrifugeLoader.addMethaneRecipe(Items.f_42527_, 48, 384);
        CentrifugeLoader.addMethaneRecipe(Items.f_42529_, 48, 384);
        CentrifugeLoader.addMethaneRecipe(Items.f_42528_, 48, 384);
        CentrifugeLoader.addMethaneRecipe(Items.f_42023_, 48, 384);
        CentrifugeLoader.addMethaneRecipe(Items.f_42022_, 48, 384);
        CentrifugeLoader.addMethaneRecipe(Items.f_42675_, 48, 384);
        CentrifugeLoader.addMethaneRecipe(Items.f_42502_, 72, 576);
        CentrifugeLoader.addMethaneRecipe(Items.f_42436_, 576, 9216, new ItemStack((ItemLike)Items.f_42417_, 7));
        CentrifugeLoader.addMethaneRecipe(Items.f_42437_, 4608, 9216, new ItemStack((ItemLike)Items.f_42417_, 64));
        CentrifugeLoader.addMethaneRecipe(Items.f_42677_, 576, 9216, new ItemStack((ItemLike)Items.f_42587_, 6));
        CentrifugeLoader.addMethaneRecipe(Items.f_42546_, 576, 9216, new ItemStack((ItemLike)Items.f_42587_, 6));
        CentrifugeLoader.addDepletedRodRecipe(GT5RItems.DepletedThorium232Rod, Materials.Uranium);
        CentrifugeLoader.addDepletedRodRecipe(GT5RItems.DepletedUranium238Rod, Materials.Uranium235);
        CentrifugeLoader.addDepletedRodRecipe(GT5RItems.DepletedUranium235Rod, Materials.Plutonium);
        CentrifugeLoader.addDepletedRodRecipe(GT5RItems.DepletedUranium233Rod, Materials.Plutonium243);
        CentrifugeLoader.addDepletedRodRecipe(GT5RItems.DepletedPlutonium244Rod, Materials.Plutonium241);
        CentrifugeLoader.addDepletedRodRecipe(GT5RItems.DepletedPlutonium241Rod, Materials.Plutonium243);
        CentrifugeLoader.addDepletedRodRecipe(GT5RItems.DepletedPlutonium243Rod, Materials.Americium);
        CentrifugeLoader.addDepletedRodRecipe(GT5RItems.DepletedPlutonium239Rod, Materials.Americium241);
        CentrifugeLoader.addDepletedRodRecipe(GT5RItems.DepletedAmericium245Rod, Materials.Americium241);
        CentrifugeLoader.addDepletedRodRecipe(GT5RItems.DepletedAmericium241Rod, Materials.EnrichedNaquadah);
        CentrifugeLoader.addDepletedRodRecipe(GT5RItems.DepletedCobalt60Rod, Materials.Thorium);
        CentrifugeLoader.addDepletedRodRecipe(GT5RItems.DepletedEnrichedNaquadahRod, Materials.Naquadria);
        CentrifugeLoader.addDepletedRodRecipe(GT5RItems.DepletedNaquadriaRod, Materials.Cobalt60);
        CentrifugeLoader.addEnrichedRodRecipe(GT5RItems.Uranium233EnrichedRod, Materials.Thorium);
        CentrifugeLoader.addEnrichedRodRecipe(GT5RItems.Plutonium239EnrichedRod, Materials.Uranium);
        CentrifugeLoader.addEnrichedRodRecipe(GT5RItems.EnrichedNaquadahEnrichedRod, Materials.Naquadah);
    }

    private static void addDepletedRodRecipe(ItemDepletedRod rod, Material secondary) {
        RecipeMaps.CENTRIFUGE.RB().ii(new ItemLike[]{rod}).io(new Item[]{GTMaterialTypes.DUST.get(Materials.Zirconium), GTMaterialTypes.TINY_DUST.get(rod.getMaterial()), GTMaterialTypes.TINY_DUST.get(secondary)}).outputChances(new double[]{1.0, 1.0, 0.75}).add(rod.getId(), 256L, 64L);
    }

    private static void addEnrichedRodRecipe(ItemEnrichedRod rod, Material secondary) {
        RecipeMaps.CENTRIFUGE.RB().ii(new ItemLike[]{rod}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Zirconium, 1), GTMaterialTypes.TINY_DUST.get(rod.getMaterial(), 4), GTMaterialTypes.TINY_DUST.get(secondary, 1)}).outputChances(new double[]{1.0, 1.0, 0.5}).add(rod.getId(), 256L, 64L);
    }

    private static void addMethaneRecipe(Item input, int methane, int ticks) {
        RecipeMaps.CENTRIFUGE.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)input, (int)1)}).fo(new FluidStack[]{Materials.Methane.getGas(methane)}).add(RegistryUtils.getIdFromItem((Item)input).m_135815_() + "_into_methane", (long)ticks, 5L);
    }

    private static void addMethaneRecipe(Item input, int methane, int ticks, ItemStack extra) {
        RecipeMaps.CENTRIFUGE.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)input, (int)1)}).io(new ItemStack[]{extra}).fo(new FluidStack[]{Materials.Methane.getGas(methane)}).add(RegistryUtils.getIdFromItem((Item)input).m_135815_() + "_into_methane", (long)ticks, 5L);
    }
}

