/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.machines;

import java.util.function.ToLongFunction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;

public class BenderLoader {
    public static void init() {
        ToLongFunction<Material> baseDuration = m -> {
            if (m.has(new IMaterialTag[]{GT5RMaterialTags.RECIPE_MASS})) {
                return ((Integer)GT5RMaterialTags.RECIPE_MASS.get(m)).intValue();
            }
            return m.getMass();
        };
        GTMaterialTypes.PLATE.all().forEach(t -> {
            if (!t.has(new IMaterialTag[]{GTMaterialTypes.INGOT}) || t.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS})) {
                return;
            }
            RecipeMaps.BENDER.RB().ii(new Ingredient[]{GTMaterialTypes.INGOT.getMaterialIngredient(t, 1), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).io(new ItemStack[]{GTMaterialTypes.PLATE.get(t, 1)}).add("plate_" + t.getId(), baseDuration.applyAsLong((Material)t), 24L);
        });
        GTMaterialTypes.DENSE_PLATE.all().forEach(t -> {
            if (t.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS})) {
                return;
            }
            if (t.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                RecipeMaps.BENDER.RB().ii(new Ingredient[]{GTMaterialTypes.INGOT.getMaterialIngredient(t, 9), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)9)}).io(new ItemStack[]{GTMaterialTypes.DENSE_PLATE.get(t, 1)}).add("plate_dense_" + t.getId(), baseDuration.applyAsLong((Material)t) * 9L, 96L);
            }
        });
        GTMaterialTypes.FOIL.all().forEach(foil -> {
            if (!foil.has(new IMaterialTag[]{GTMaterialTypes.PLATE}) || foil.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS})) {
                return;
            }
            RecipeMaps.BENDER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(foil, 1), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).io(new ItemStack[]{GTMaterialTypes.FOIL.get(foil, 4)}).add("foil_" + foil.getId(), baseDuration.applyAsLong((Material)foil), 24L);
        });
        GTMaterialTypes.SPRING.all().stream().filter(m -> !m.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS})).forEach(spring -> RecipeMaps.BENDER.RB().ii(new Ingredient[]{GTMaterialTypes.LONG_ROD.getMaterialIngredient(spring, 1), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).io(new Item[]{GTMaterialTypes.SPRING.get(spring)}).add(spring.getId() + "_spring", 200L, 16L));
        GTMaterialTypes.RING.all().stream().filter(m -> !m.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS})).forEach(ring -> RecipeMaps.BENDER.RB().ii(new Ingredient[]{GTMaterialTypes.ROD.getMaterialIngredient(ring, 1), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).io(new ItemStack[]{GTMaterialTypes.RING.get(ring, 2)}).add(ring.getId() + "_ring", 200L, 16L));
        RecipeMaps.BENDER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Tin, 2), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)4)}).io(new ItemStack[]{GT5RItems.CellTin.m_7968_()}).add("tin_cell", 80L, 24L);
        RecipeMaps.BENDER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Steel, 2), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)4)}).io(new ItemStack[]{GT5RItems.CellSteel.m_7968_()}).add("steel_cell", 80L, 96L);
        RecipeMaps.BENDER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.TungstenSteel, 2), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)4)}).io(new ItemStack[]{GT5RItems.CellTungstensteel.m_7968_()}).add("tungstensteel_cell", 80L, 384L);
        RecipeMaps.BENDER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Zirconium, 1), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).io(new Item[]{GT5RItems.EmptyNuclearFuelRod}).add("empty_fuel_rod", 80L, 96L);
        RecipeMaps.BENDER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Iron, 3), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)3)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42446_)}).add("bucket", 200L, 16L);
        RecipeMaps.BENDER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTCoreTags.INGOTS_MIXED_METAL, (int)1).setIgnoreNbt(), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).io(new Item[]{GTCoreItems.AdvancedAlloy}).add("advanced_alloy", 100L, 8L);
    }
}

