/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.machines;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.GT5RConfig;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gt5r.data.GT5RTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtcore.data.GTCoreFluids;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.material.MaterialTypeItem;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.TagUtils;

public class BathLoader {
    public static void init() {
        RecipeMaps.BATH.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTMaterialTypes.DUST.get(Materials.Wood), (int)1)}).fi(new FluidStack[]{Materials.Water.getLiquid(125)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42516_)}).add("paper", 16L);
        RecipeMaps.BATH.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_41909_, (int)1)}).fi(new FluidStack[]{Materials.Water.getLiquid(125)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42516_)}).add("paper_1", 16L);
        RecipeMaps.BATH.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42686_, (int)1)}).fi(new FluidStack[]{Materials.Radon.getGas(1250)}).io(new ItemStack[]{new ItemStack(GT5RItems.QuantumStar)}).add("quantum_star", 1920L);
        RecipeMaps.BATH.RB().ii(new Ingredient[]{GTMaterialTypes.GEM.getMaterialIngredient(Materials.Diamond, 1)}).fi(new FluidStack[]{Materials.Netherite.getLiquid(36)}).io(new Item[]{GTMaterialTypes.GEM.get(Materials.NetherizedDiamond)}).add("netherized_diamond_recipe", 144L);
        RecipeMaps.BATH.RB().fi(new FluidIngredient[]{FluidIngredient.of(GT5RTags.BLUE_DYE, (int)144)}).ii(new ItemLike[]{Items.f_42516_}).io(new Item[]{GTCoreItems.EmptyBlueprint}).add("empty_blueprint", 16L);
        RecipeMaps.BATH.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Tungstate, 7)}).fi(new FluidStack[]{Materials.HydrochloricAcid.getLiquid(4000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.LithiumChloride, 4), GTMaterialTypes.DUST.get(Materials.TungsticAcid, 7)}).add("tungstate", 512L);
        RecipeMaps.BATH.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Scheelite, 6)}).fi(new FluidStack[]{Materials.HydrochloricAcid.getLiquid(4000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.CalciumChloride, 3), GTMaterialTypes.DUST.get(Materials.TungsticAcid, 7)}).add("scheelite", 512L);
        RecipeMaps.BATH.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_((TagKey)GTMaterialTypes.FRAME.getMaterialTag(Materials.Steel))}).fi(new FluidStack[]{Materials.Concrete.getLiquid(144)}).io(new Item[]{GTCoreBlocks.REINFORCED_STONE.m_5456_()}).add("reinforced_stone", 200L, 4L);
        if (GT5RConfig.HARDER_CIRCUITS) {
            RecipeMaps.BATH.RB().ii(new ItemLike[]{GTCoreItems.CarbonFibre}).fi(new FluidStack[]{Materials.EpoxyResin.getLiquid(144)}).io(new Item[]{GTMaterialTypes.PLATE.get(Materials.FiberReinforcedEpoxyResin)}).add("fiber_reinforced_epoxy_resin", 240L);
        }
        if (GT5RConfig.HARDER_ALUMINIUM_PROCESSING.get()) {
            RecipeMaps.BATH.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.SodiumAluminate, 4)}).fi(new FluidStack[]{Materials.Water.getLiquid(6000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.AluminiumHydroxide, 7), GTMaterialTypes.DUST.get(Materials.SodiumHydroxide, 3)}).add("aluminium_hydroxide", 2040L);
            RecipeMaps.BATH.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.SodiumAluminate, 4)}).fi(new FluidStack[]{Materials.DistilledWater.getLiquid(6000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.AluminiumHydroxide, 7), GTMaterialTypes.DUST.get(Materials.SodiumHydroxide, 3)}).add("aluminium_hydroxide_distilled_water", 2040L);
        }
        RecipeMaps.BATH.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Magnesium, 2)}).fi(new FluidStack[]{Materials.TitaniumTetrachloride.getLiquid(5000)}).io(new ItemStack[]{GTMaterialTypes.DUST.get(Materials.Titanium, 1), GTMaterialTypes.DUST.get(Materials.MagnesiumChloride, 6)}).add("titanium", 512L);
        if (GTAPI.isModLoaded((String)"twilightforest")) {
            Materials.FierySteel.getTypes().forEach(t -> {
                if (Materials.Steel.has(new IMaterialTag[]{t})) {
                    if (t instanceof MaterialTypeItem) {
                        MaterialTypeItem typeItem = (MaterialTypeItem)t;
                        BathLoader.addFieryBathing((TagKey<Item>)t.getMaterialTag(Materials.Steel), typeItem.get(Materials.FierySteel), t.getUnitValue());
                    } else {
                        Object patt4602$temp = t.get();
                        if (patt4602$temp instanceof MaterialTypeBlock.IBlockGetter) {
                            MaterialTypeBlock.IBlockGetter getter = (MaterialTypeBlock.IBlockGetter)patt4602$temp;
                            BathLoader.addFieryBathing((TagKey<Item>)t.getMaterialTag(Materials.Steel), getter.get(Materials.FierySteel).asItem(), t.getUnitValue());
                        }
                    }
                }
            });
        }
        for (DyeColor dye : DyeColor.values()) {
            String dyeName = dye.m_41065_() + "_dye";
            TagKey dyeLiquid = TagUtils.getFluidTag((ResourceLocation)new ResourceLocation("gt5r", dyeName));
            RecipeMaps.BATH.RB().fi(new FluidIngredient[]{FluidIngredient.of((TagKey)dyeLiquid, (int)18)}).ii(new ItemLike[]{Items.f_41904_}).io(new Item[]{RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(dye.m_41065_() + "_stained_glass"))}).add(dye.m_41065_() + "_stained_glass", 64L);
            RecipeMaps.BATH.RB().fi(new FluidIngredient[]{FluidIngredient.of((TagKey)dyeLiquid, (int)18)}).ii(new ItemLike[]{Items.f_42027_}).io(new Item[]{RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(dye.m_41065_() + "_stained_glass_pane"))}).add(dye.m_41065_() + "_stained_glass_pane", 64L);
            RecipeMaps.BATH.RB().fi(new FluidIngredient[]{FluidIngredient.of((TagKey)dyeLiquid, (int)18)}).ii(new ItemLike[]{Items.f_42199_}).io(new Item[]{RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(dye.m_41065_() + "_terracotta"))}).add(dye.m_41065_() + "_terracotta", 64L);
            RecipeMaps.BATH.RB().fi(new FluidIngredient[]{FluidIngredient.of((TagKey)dyeLiquid, (int)72)}).ii(new ItemLike[]{Items.f_151065_}).io(new Item[]{RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(dye.m_41065_() + "_candle"))}).add(dye.m_41065_() + "_candle", 64L);
            RecipeMaps.BATH.RB().fake().ii(new ItemLike[]{Items.f_42265_}).fi(new FluidIngredient[]{FluidIngredient.of((TagKey)dyeLiquid, (int)72)}).io(new Item[]{RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(dye.m_41065_() + "_shulker_box"))}).add(dye.m_41065_() + "_shulker_box", 64L);
            RecipeMaps.BATH.RB().fake().ii(new ItemLike[]{RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(dye.m_41065_() + "_shulker_box"))}).fi(new FluidStack[]{Materials.Chlorine.getGas(50)}).io(new Item[]{Items.f_42265_}).add("shulker_box_from_" + dye.m_41065_(), 64L);
            if (dye == DyeColor.WHITE) continue;
            RecipeMaps.BATH.RB().fi(new FluidIngredient[]{FluidIngredient.of((TagKey)dyeLiquid, (int)72)}).ii(new ItemLike[]{Items.f_41870_}).io(new Item[]{RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(dye.m_41065_() + "_wool"))}).add(dye.m_41065_() + "_wool", 64L);
            RecipeMaps.BATH.RB().fi(new FluidStack[]{Materials.Chlorine.getGas(50)}).ii(new ItemLike[]{RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(dye.m_41065_() + "_wool"))}).io(new Item[]{Items.f_41870_}).add("white_wool_from_" + dyeName, 400L);
            RecipeMaps.BATH.RB().fi(new FluidStack[]{Materials.Chlorine.getGas(25)}).ii(new ItemLike[]{RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(dye.m_41065_() + "_carpet"))}).io(new Item[]{Items.f_42130_}).add("white_carpet_from_" + dyeName, 400L);
            RecipeMaps.BATH.RB().fi(new FluidIngredient[]{FluidIngredient.of((TagKey)dyeLiquid, (int)72)}).ii(new ItemLike[]{Items.f_42503_}).io(new Item[]{RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(dye.m_41065_() + "_bed"))}).add(dye.m_41065_() + "_bed", 64L);
            RecipeMaps.BATH.RB().fi(new FluidStack[]{Materials.Chlorine.getGas(50)}).ii(new ItemLike[]{RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(dye.m_41065_() + "_bed"))}).io(new Item[]{Items.f_42503_}).add("white_bed_from_" + dyeName, 400L);
        }
        BathLoader.mercurybathing();
        BathLoader.persulfatebathing();
        RecipeMaps.BATH.RB().ii(new Ingredient[]{GTMaterialTypes.CRUSHED_ORE.getMaterialIngredient(Materials.Cobaltite, 1)}).fi(new FluidStack[]{Materials.SodiumPersulfateSolution.getLiquid(1000)}).io(new Item[]{GTMaterialTypes.PURIFIED_ORE.get(Materials.Cobaltite), GTMaterialTypes.PURIFIED_ORE.get(Materials.Cobalt), GTMaterialTypes.DUST.get(Materials.Stone)}).outputChances(new double[]{1.0, 0.25, 1.0}).add("persulfate_cobaltite", 144L);
        GT5RMaterialTags.VITRIOL.getAll().forEach((ore, vitriol) -> {
            if (vitriol.has(new IMaterialTag[]{GTMaterialTypes.LIQUID}) && ore.has(new IMaterialTag[]{GTMaterialTypes.PURIFIED_ORE})) {
                BathLoader.addVitriolRecipe(ore, vitriol);
            }
        });
        RecipeMaps.BATH.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Ilmenite, 5)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(7000)}).io(new Item[]{GTMaterialTypes.DUST.get(Materials.Rutile)}).fo(new FluidStack[]{Materials.GreenVitriol.getLiquid(6000), Materials.Water.getLiquid(3000)}).add("ilmenite_to_rutile", 512L);
        GT5RMaterialTags.PLATINUM_GROUP_SLUDGE.all().forEach(m -> {
            if (m.has(new IMaterialTag[]{GTMaterialTypes.PURIFIED_ORE})) {
                BathLoader.addPSGRecipe(m);
            }
        });
    }

    public static void mercurybathing() {
        GT5RMaterialTags.BATH_MERCURY.getAll().forEach((main, side) -> RecipeMaps.BATH.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTMaterialTypes.CRUSHED_ORE.get(main), (int)1)}).fi(new FluidStack[]{Materials.Mercury.getLiquid(1000)}).io(new ItemStack[]{new ItemStack((ItemLike)GTMaterialTypes.PURIFIED_ORE.get(main)), new ItemStack((ItemLike)GTMaterialTypes.DUST.get(side)), new ItemStack((ItemLike)GTMaterialTypes.DUST.get(Materials.Stone))}).outputChances(new double[]{1.0, 0.7, 1.0}).add("mercury_" + main.getId(), 800L));
    }

    public static void persulfatebathing() {
        GT5RMaterialTags.BATH_PERSULFATE.getAll().forEach((main, side) -> RecipeMaps.BATH.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTMaterialTypes.CRUSHED_ORE.get(main), (int)1)}).fi(new FluidStack[]{Materials.SodiumPersulfateSolution.getLiquid(1000)}).io(new ItemStack[]{new ItemStack((ItemLike)GTMaterialTypes.PURIFIED_ORE.get(main)), new ItemStack((ItemLike)GTMaterialTypes.DUST.get(side)), new ItemStack((ItemLike)GTMaterialTypes.DUST.get(Materials.Stone))}).outputChances(new double[]{1.0, 0.7, 1.0}).add("persulfate_" + main.getId(), 800L));
    }

    private static void addFieryBathing(TagKey<Item> in, Item out, long materialAmount) {
        int amount = (int)(144L * materialAmount / 18144000L);
        RecipeMaps.BATH.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_(in)}).io(new Item[]{out}).fi(new FluidStack[]{new FluidStack((Fluid)GTCoreFluids.FIERY_TEARS.getFluid(), amount)}).add(in.f_203868_().m_135815_() + "_to_" + RegistryUtils.getIdFromItem((Item)out).m_135815_() + "_tears", (long)amount);
        RecipeMaps.BATH.RB().ii(new Ingredient[]{RecipeIngredient.m_204132_(in)}).io(new Item[]{out}).fi(new FluidStack[]{new FluidStack((Fluid)GTCoreFluids.FIERY_BLOOD.getFluid(), amount)}).add(in.f_203868_().m_135815_() + "_to_" + RegistryUtils.getIdFromItem((Item)out).m_135815_() + "_blood", (long)amount);
    }

    private static void addVitriolRecipe(Material input, Material vitriol) {
        RecipeMaps.BATH.RB().ii(new Ingredient[]{GTMaterialTypes.PURIFIED_ORE.getMaterialIngredient(input, 1)}).fi(new FluidStack[]{Materials.SulfuricAcid.getLiquid(vitriol == Materials.VitriolOfClay ? 10500 : 3500)}).fo(new FluidStack[]{vitriol.getLiquid(vitriol == Materials.VitriolOfClay ? 8500 : 3000), Materials.Hydrogen.getGas(vitriol == Materials.VitriolOfClay ? 3000 : 1000)}).io(new ItemStack[]{GTMaterialTypes.REFINED_ORE.get(input, 1), GTMaterialTypes.SMALL_DUST.get(input, 2)}).add(vitriol.getId() + "_from_" + input.getId(), 256L);
    }

    private static void addPSGRecipe(Material input) {
        RecipeMaps.BATH.RB().ii(new Ingredient[]{GTMaterialTypes.PURIFIED_ORE.getMaterialIngredient(input, 1)}).fi(new FluidStack[]{Materials.AquaRegia.getLiquid(9750)}).fo(new FluidStack[]{Materials.ChloroplatinicAcid.getLiquid(4500), Materials.NitrogenMonoxide.getGas(1500), Materials.Water.getLiquid(4125)}).io(new ItemStack[]{GTMaterialTypes.REFINED_ORE.get(input, 1), GTMaterialTypes.TINY_DUST.get(Materials.PlatinumGroupSludge, 1)}).add("psg_from_" + input.getId(), 256L);
    }
}

