/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.machines;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.GT5Reimagined;
import org.gtreimagined.gt5r.block.BlockCasing;
import org.gtreimagined.gt5r.block.BlockCoil;
import org.gtreimagined.gt5r.block.BlockColoredWall;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.GT5RCovers;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.GT5RMachines;
import org.gtreimagined.gt5r.data.GT5RMaterialTypes;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gt5r.data.TierMaps;
import org.gtreimagined.gt5r.data.ToolTypes;
import org.gtreimagined.gt5r.loader.crafting.Parts;
import org.gtreimagined.gtcore.block.RedstoneWire;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtcore.machine.ChestMachine;
import org.gtreimagined.gtcore.machine.HopperMachine;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.pipe.PipeItemBlock;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.Cable;
import org.gtreimagined.gtlib.pipe.types.Wire;
import org.gtreimagined.gtlib.recipe.ingredient.FluidIngredient;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;
import org.gtreimagined.gtlib.util.RegistryUtils;
import org.gtreimagined.gtlib.util.TagUtils;

public class AssemblerLoader {
    public static void init() {
        AssemblerLoader.batteries();
        AssemblerLoader.casings();
        AssemblerLoader.cables();
        AssemblerLoader.carpet();
        AssemblerLoader.coils();
        AssemblerLoader.frames();
        AssemblerLoader.misc();
        AssemblerLoader.hoppers();
        AssemblerLoader.chests();
        AssemblerLoader.motors();
        AssemblerLoader.pistons();
        AssemblerLoader.pumps();
        AssemblerLoader.rotors();
        AssemblerLoader.turbines();
    }

    private static void batteries() {
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.BatteryAlloy, 1), RecipeIngredient.ofObject((Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.LV, (Object)false), (int)1)}).fi(new FluidStack[]{Materials.Plastic.getLiquid(144)}).io(new ItemStack[]{GT5RItems.BatteryHullSmall.m_7968_()}).add("battery_hull_small", 800L, 1L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.BatteryAlloy, 3), RecipeIngredient.ofObject((Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.MV, (Object)false), (int)2)}).fi(new FluidStack[]{Materials.Plastic.getLiquid(432)}).io(new ItemStack[]{GT5RItems.BatteryHullMedium.m_7968_()}).add("battery_hull_medium", 1600L, 2L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.BatteryAlloy, 9), RecipeIngredient.ofObject((Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.HV, (Object)false), (int)4)}).fi(new FluidStack[]{Materials.Plastic.getLiquid(1296)}).io(new ItemStack[]{GT5RItems.BatteryHullLarge.m_7968_()}).add("battery_hull_large", 3200L, 4L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Tantalum, 1), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Manganese, 1)}).fi(new FluidStack[]{Materials.Plastic.getLiquid(144)}).io(new ItemStack[]{new ItemStack(GT5RItems.BatteryTantalum, 8)}).add("tantalum_capacitor", 100L, 4L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.RawLapotronCrustal}), RecipeIngredient.of((TagKey)GTCoreTags.CIRCUITS_ADVANCED, (int)2)}).io(new Item[]{GT5RItems.LapotronCrystal}).add("lapotron_crystal", 16L, 256L);
    }

    private static void casings() {
        AssemblerLoader.addTierCasing(Tier.ULV);
        AssemblerLoader.addTierCasing(Tier.LV);
        AssemblerLoader.addTierCasing(Tier.MV);
        AssemblerLoader.addTierCasing(Tier.HV);
        AssemblerLoader.addTierCasing(Tier.EV);
        AssemblerLoader.addTierCasing(Tier.IV);
        AssemblerLoader.addTierCasing(Tier.LUV);
        AssemblerLoader.addTierCasing(Tier.ZPM);
        AssemblerLoader.addTierCasing(Tier.UV);
        AssemblerLoader.addTierCasing(Tier.UHV);
        AssemblerLoader.addTierHull(Tier.ULV);
        AssemblerLoader.addTierHull(Tier.LV);
        AssemblerLoader.addTierHull(Tier.MV);
        AssemblerLoader.addTierHull(Tier.HV);
        AssemblerLoader.addTierHull(Tier.EV);
        AssemblerLoader.addTierHull(Tier.IV);
        AssemblerLoader.addTierHull(Tier.LUV);
        AssemblerLoader.addTierHull(Tier.ZPM);
        AssemblerLoader.addTierHull(Tier.UV);
        AssemblerLoader.addTierHull(Tier.UHV);
        AssemblerLoader.addWall(Materials.Steel, GT5RBlocks.STEEL_WALL);
        AssemblerLoader.addWall(Materials.Invar, GT5RBlocks.INVAR_WALL);
        AssemblerLoader.addWall(Materials.StainlessSteel, GT5RBlocks.STAINLESS_STEEL_WALL);
        AssemblerLoader.addWall(Materials.Tungsten, GT5RBlocks.TUNGSTEN_WALL);
        AssemblerLoader.addWall(Materials.Titanium, GT5RBlocks.TITANIUM_WALL);
        AssemblerLoader.addWall(Materials.TungstenSteel, GT5RBlocks.TUNGSTENSTEEL_WALL);
        AssemblerLoader.addWall(Materials.Netherite, GT5RBlocks.NETHERITE_WALL);
        AssemblerLoader.addWall(Materials.Adamantium, GT5RBlocks.ADAMANTIUM_WALL);
        AssemblerLoader.addCasing(Materials.Steel, GT5RBlocks.SOLID_STEEL_CASING);
        AssemblerLoader.addCasing(Materials.StainlessSteel, GT5RBlocks.STAINLESS_STEEL_CASING);
        AssemblerLoader.addCasing(Materials.Titanium, GT5RBlocks.TITANIUM_CASING);
        AssemblerLoader.addCasing(Materials.TungstenSteel, GT5RBlocks.TUNGSTENSTEEL_CASING);
        AssemblerLoader.addCasing(Materials.Invar, GT5RBlocks.HEAT_PROOF_CASING);
        AssemblerLoader.addCasing(Materials.Aluminium, GT5RBlocks.FROST_PROOF_CASING);
        AssemblerLoader.addCasing(Materials.Lead, GT5RBlocks.RADIATION_PROOF_CASING);
        AssemblerLoader.addCasing(Materials.Plastic, GT5RBlocks.PLASTIC_CASING);
        AssemblerLoader.addCasing(Materials.BlackBronze, GT5RBlocks.BLACK_BRONZE_CASING);
        AssemblerLoader.addCasing(Materials.Tungsten, GT5RBlocks.TUNGSTEN_CASING);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RBlocks.SOLID_STEEL_CASING}), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)6)}).fi(new FluidStack[]{Materials.Polytetrafluoroethylene.getLiquid(216)}).io(new Item[]{GT5RBlocks.CHEMICALLY_INERT_CASING.m_5456_()}).add("chemically_inert_casing", 50L, 16L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RBlocks.STEEL_PIPE_CASING})}).fi(new FluidStack[]{Materials.Polytetrafluoroethylene.getLiquid(504)}).io(new Item[]{GT5RBlocks.PTFE_PIPE_CASING.m_5456_()}).add("ptfe_pipe_casing", 50L, 16L);
    }

    private static void cables() {
        GTAPI.all(Wire.class, t -> {
            Cable cable = (Cable)GTAPI.get(Cable.class, (String)("cable_" + t.getMaterial().getId()));
            if (cable == null) {
                return;
            }
            ImmutableSet sizes = t.getSizes();
            sizes.forEach(size -> {
                PipeItemBlock wireItem = t.getBlockItem(size);
                PipeItemBlock cableItem = cable.getBlockItem(size);
                int ct = size.getCableThickness();
                int multiplier = ct == 16 ? 5 : (ct == 12 ? 4 : (ct == 8 ? 3 : (ct == 4 ? 2 : 1)));
                int amount = 144 * multiplier;
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)wireItem, (int)1), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).fi(new FluidStack[]{Materials.Rubber.getLiquid(amount)}).io(new ItemStack[]{new ItemStack((ItemLike)cableItem, 1)}).add("cable_" + t.getMaterial().getId() + "_" + size.getId() + "_rubber", (long)size.getCableThickness() * 20L, 8L);
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)wireItem, (int)1), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).fi(new FluidStack[]{Materials.StyreneButadieneRubber.getLiquid(amount * 3 / 4)}).io(new ItemStack[]{new ItemStack((ItemLike)cableItem, 1)}).add("cable_" + t.getMaterial().getId() + "_" + size.getId() + "_styrene_butadiene_rubber", 100L, 8L);
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)wireItem, (int)1), GTMaterialTypes.SMALL_DUST.getMaterialIngredient(Materials.PolyvinylChloride, multiplier)}).fi(new FluidStack[]{Materials.StyreneButadieneRubber.getLiquid(amount / 4)}).io(new ItemStack[]{new ItemStack((ItemLike)cableItem, 1)}).add("cable_" + t.getMaterial().getId() + "_" + size.getId() + "_styrene_butadiene_rubber_2", 100L, 8L);
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)wireItem, (int)1), GTMaterialTypes.SMALL_DUST.getMaterialIngredient(Materials.Polydimethylsiloxane, multiplier)}).fi(new FluidStack[]{Materials.StyreneButadieneRubber.getLiquid(amount / 4)}).io(new ItemStack[]{new ItemStack((ItemLike)cableItem, 1)}).add("cable_" + t.getMaterial().getId() + "_" + size.getId() + "_styrene_butadiene_rubber_3", 100L, 8L);
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)wireItem, (int)1), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).fi(new FluidStack[]{Materials.SiliconeRubber.getLiquid(amount / 2)}).io(new ItemStack[]{new ItemStack((ItemLike)cableItem, 1)}).add("cable_" + t.getMaterial().getId() + "_" + size.getId() + "_silicone_rubber", 100L, 8L);
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)wireItem, (int)1), GTMaterialTypes.SMALL_DUST.getMaterialIngredient(Materials.PolyvinylChloride, multiplier)}).fi(new FluidStack[]{Materials.SiliconeRubber.getLiquid(amount / 4)}).io(new ItemStack[]{new ItemStack((ItemLike)cableItem, 1)}).add("cable_" + t.getMaterial().getId() + "_" + size.getId() + "_silicone_rubber_2", 100L, 8L);
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)wireItem, (int)1), GTMaterialTypes.SMALL_DUST.getMaterialIngredient(Materials.Polydimethylsiloxane, multiplier)}).fi(new FluidStack[]{Materials.SiliconeRubber.getLiquid(amount / 4)}).io(new ItemStack[]{new ItemStack((ItemLike)cableItem, 1)}).add("cable_" + t.getMaterial().getId() + "_" + size.getId() + "_silicone_rubber_3", 100L, 8L);
            });
        });
        GTAPI.all(RedstoneWire.class).forEach(w -> RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)w.getBlockItem(PipeSize.VTINY), (int)1), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).fi(new FluidStack[]{Materials.Rubber.getLiquid(144)}).io(new Item[]{w.getBlockItem(PipeSize.TINY)}).add("cable_" + w.getMaterial().getId(), 100L, 8L));
    }

    private static void coils() {
        AssemblerLoader.addCoil(GT5RBlocks.CUPRONICKEL_COIL, GT5RBlocks.WIRE_CUPRONICKEL.getBlockItem(PipeSize.TINY));
        AssemblerLoader.addCoil(GT5RBlocks.KANTHAL_COIL, GT5RBlocks.WIRE_KANTHAL.getBlockItem(PipeSize.TINY));
        AssemblerLoader.addCoil(GT5RBlocks.NICHROME_COIL, GT5RBlocks.WIRE_NICHROME.getBlockItem(PipeSize.TINY));
        AssemblerLoader.addCoil(GT5RBlocks.TUNGSTENSTEEL_COIL, GT5RBlocks.WIRE_TUNGSTEN_STEEL.getBlockItem(PipeSize.TINY));
        AssemblerLoader.addCoil(GT5RBlocks.HSSG_COIL, GT5RBlocks.WIRE_HSSG.getBlockItem(PipeSize.TINY));
        AssemblerLoader.addCoil(GT5RBlocks.NAQUADAH_COIL, GT5RBlocks.WIRE_NAQUADAH.getBlockItem(PipeSize.TINY));
        AssemblerLoader.addCoil(GT5RBlocks.NAQUADAH_ALLOY_COIL, GT5RBlocks.WIRE_NAQUADAH_ALLOY.getBlockItem(PipeSize.TINY));
        AssemblerLoader.addCoil(GT5RBlocks.IRIDIUM_COIL, GT5RBlocks.WIRE_IRIDIUM.getBlockItem(PipeSize.TINY));
    }

    private static void frames() {
        GTMaterialTypes.FRAME.all().forEach(m -> {
            MaterialTypeBlock.Container f = ((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.FRAME.get()).get(m);
            RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTMaterialTypes.ROD.get(m), (int)4), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)4)}).io(new Item[]{f.asItem()}).add(RegistryUtils.getIdFromBlock((Block)f.asBlock()).m_135815_(), 40L, 24L);
        });
    }

    private static void misc() {
        RecipeMaps.ASSEMBLER.RB().ii(new ItemLike[]{GT5RItems.PrintedPages, Items.f_42454_}).fi(new FluidStack[]{Materials.Glue.getLiquid(20)}).io(new Item[]{Items.f_42615_}).fake().add("written_book", 32L, 8L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GT5RMachines.TRANSFORMER.getItem(Tier.ULV), (int)8), RecipeIngredient.of((ItemLike)GT5RMachines.TRANSFORMER.getItem(Tier.LV), (int)4), RecipeIngredient.of((ItemLike)GT5RMachines.TRANSFORMER.getItem(Tier.MV), (int)2), RecipeIngredient.of((ItemLike)GT5RMachines.TRANSFORMER.getItem(Tier.HV), (int)1), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.ComputerMonitor}), RecipeIngredient.of(TierMaps.TIER_CIRCUITS.apply(Tier.EV), (int)4)}).io(new Item[]{GT5RMachines.ADJUSTABLE_TRANSFORMER.getItem(Tier.EV)}).add("ev_adjustable_transformer", 50L, 1920L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GT5RMachines.TRANSFORMER.getItem(Tier.EV), (int)1), RecipeIngredient.of((ItemLike)GT5RMachines.ADJUSTABLE_TRANSFORMER.getItem(Tier.EV), (int)2), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.ComputerMonitor}), RecipeIngredient.of(TierMaps.TIER_CIRCUITS.apply(Tier.IV), (int)4)}).io(new Item[]{GT5RMachines.ADJUSTABLE_TRANSFORMER.getItem(Tier.IV)}).add("iv_adjustable_transformer", 50L, 1920L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)ItemTags.f_13168_, (int)8), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)8)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42009_, 1)}).add("chest", 100L, 4L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.EmitterMV}), GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Aluminium, 1)}).io(new ItemStack[]{GT5RCovers.COVER_NEEDS_MAINTENANCE_COVER.getItem()}).add("needs_maintenance_cover", 600L, 24L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTCoreTags.PLATES_IRON_ALUMINIUM, (int)2), RecipeIngredient.of((ItemLike)Items.f_42025_, (int)2)}).io(new ItemStack[]{GT5RCovers.COVER_DRAIN.getItem()}).add("drain", 800L, 16L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTCoreTags.PLATES_IRON_ALUMINIUM, (int)2), RecipeIngredient.of((ItemStack)GT5RCovers.COVER_PUMP.getItem(Tier.LV))}).io(new ItemStack[]{GT5RCovers.COVER_AIR_VENT.getItem()}).add("air_vent", 800L, 16L);
        AssemblerLoader.addCoverRecipe(GT5RCovers.COVER_REDSTONE_MACHINE_CONTROLLER.getItem(), new Ingredient[]{RecipeIngredient.of((TagKey)GTCoreTags.PLATES_IRON_ALUMINIUM, (int)1), RecipeIngredient.of((ItemLike)Items.f_41966_, (int)1)});
        AssemblerLoader.addCoverRecipe(GT5RCovers.COVER_ENERGY_DETECTOR.getItem(), new Ingredient[]{RecipeIngredient.of((TagKey)GTCoreTags.PLATES_IRON_ALUMINIUM, (int)1), RecipeIngredient.of((TagKey)GTCoreTags.CIRCUITS_BASIC, (int)1)});
        AssemblerLoader.addCoverRecipe(GT5RCovers.COVER_FLUID_DETECTOR.getItem(), new Ingredient[]{RecipeIngredient.of((TagKey)GTCoreTags.PLATES_IRON_ALUMINIUM, (int)1), RecipeIngredient.of((ItemLike)Items.f_42151_, (int)1)});
        AssemblerLoader.addCoverRecipe(GT5RCovers.COVER_ITEM_DETECTOR.getItem(), new Ingredient[]{RecipeIngredient.of((TagKey)GTCoreTags.PLATES_IRON_ALUMINIUM, (int)1), RecipeIngredient.of((ItemLike)Items.f_42150_, (int)1)});
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTCoreTags.PLATES_IRON_ALUMINIUM, (int)1), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Plastic, 2)}).io(new ItemStack[]{GT5RCovers.COVER_MUFFLER.getItem()}).add("muffler", 1600L, 2L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTCoreTags.PLATES_IRON_ALUMINIUM, (int)1), GTMaterialTypes.DUST.getMaterialIngredient(Materials.Wood, 2)}).io(new ItemStack[]{GT5RCovers.COVER_MUFFLER.getItem()}).add("muffler_1", 1600L, 2L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.CarbonFibre, (int)2), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)2)}).io(new Item[]{GTCoreItems.CarbonMesh}).add("carbon_mesh", 800L, 2L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.CarbonFibre, (int)4), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Zinc, 16), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)0)}).io(new ItemStack[]{GT5RCovers.COVER_ITEM_FILTER.getItem()}).add("item_filter", 1600L, 32L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Steel, 64), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Zinc, 16), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)0)}).io(new ItemStack[]{GT5RCovers.COVER_ITEM_FILTER.getItem()}).add("item_filter_cheap", 1600L, 32L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.CarbonFibre, (int)4), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Zinc, 16), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).io(new ItemStack[]{GT5RCovers.COVER_FLUID_FILTER.getItem()}).add("fluid_filter", 1600L, 32L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.FINE_WIRE.getMaterialIngredient(Materials.Steel, 64), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Zinc, 16), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)1)}).io(new ItemStack[]{GT5RCovers.COVER_FLUID_FILTER.getItem()}).add("fluid_filter_cheap", 1600L, 32L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTCoreTags.PLATES_IRON_ALUMINIUM, (int)2), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42128_})}).io(new ItemStack[]{new ItemStack((ItemLike)GT5RCovers.COVER_SHUTTER.getItem().m_41720_(), 2)}).add("shutter", 800L, 16L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Invar, 2), RecipeIngredient.of((ItemLike)Items.f_42484_, (int)1)}).io(new Item[]{GTCoreItems.LighterEmpty}).add("empty_lighter", 256L, 16L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTCoreItems.Match, (int)64), RecipeIngredient.of((ItemLike)Items.f_42516_, (int)2)}).fi(new FluidStack[]{Materials.Glue.getLiquid(10)}).io(new Item[]{GTCoreItems.MatchBook}).add("matchbook", 100L, 16L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Iron, 2), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)2)}).io(new Item[]{Items.f_42151_}).add("heavy_weighted_pressure_plate", 800L, 16L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Gold, 2), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)2)}).io(new Item[]{Items.f_42150_}).add("light_weighted_pressure_plate", 800L, 16L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.ROD.getMaterialIngredient(Materials.Iron, 6), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)6)}).io(new ItemStack[]{new ItemStack((ItemLike)Items.f_42025_, 8)}).add("iron_bars", 800L, 16L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Iron, 2), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)6)}).io(new Item[]{Items.f_42341_}).add("iron_door", 800L, 16L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Iron, 4), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)4)}).io(new Item[]{Items.f_42128_}).add("iron_trapdoor", 800L, 16L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Redstone, 1), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{GT5RItems.CellTin})}).io(new Item[]{GT5RItems.EmptySprayCan}).add("empty_spray_can", 800L, 1L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42516_, (int)3), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)3)}).fi(new FluidStack[]{Materials.Glue.getLiquid(1000)}).io(new Item[]{GTCoreItems.Tape}).add("tape", 200L, 16L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Plastic, 3), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)3)}).fi(new FluidStack[]{Materials.Glue.getLiquid(1000)}).io(new Item[]{GTCoreItems.DuctTape}).add("duct_tape", 200L, 16L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Tungsten, 3), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)3)}).fi(new FluidStack[]{Materials.Glue.getLiquid(1000)}).io(new Item[]{GTCoreItems.FALDuctTape}).add("fal_duct_tape", 200L, 16L);
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Graphite, 8), GTMaterialTypes.FOIL.getMaterialIngredient(Materials.Silicon, 1)}).fi(new FluidStack[]{Materials.Glue.getLiquid(250)}).io(new Item[]{GTMaterialTypes.SMALL_DUST.get(Materials.Graphene)}).add("graphene_dust", 480L, 240L);
    }

    private static void hoppers() {
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(Materials.Iron, 5), RecipeIngredient.m_204132_((TagKey)Tags.Items.CHESTS_WOODEN)}).io(new Item[]{Items.f_42155_}).add("hopper", 800L, 2L);
        GTAPI.all(HopperMachine.class).forEach(hopper -> {
            if (!hopper.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.PLATE})) {
                return;
            }
            RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(hopper.getMaterial(), 5), Ingredient.m_204132_((TagKey)Tags.Items.CHESTS_WOODEN)}).io(new Item[]{hopper.getItem(Tier.NONE)}).add(hopper.getId(), 800L, 2L);
        });
    }

    private static void chests() {
        GTAPI.all(ChestMachine.class).forEach(m -> {
            if (m.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.PLATE}) && m.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.RING}) && m.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.ROD})) {
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(m.getMaterial(), 4), GTMaterialTypes.RING.getMaterialIngredient(m.getMaterial(), 2), GTMaterialTypes.ROD.getMaterialIngredient(m.getMaterial(), 1)}).io(new Item[]{m.getItem(Tier.NONE)}).add(m.getId(), 400L, 4L);
            }
        });
    }

    private static void carpet() {
        for (DyeColor dye : DyeColor.values()) {
            String dyeName = dye.m_41065_() + "_dye";
            TagKey dyeLiquid = TagUtils.getFluidTag((ResourceLocation)new ResourceLocation("gt5r", dyeName));
            RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)Items.f_42401_, (int)2), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)2)}).fi(new FluidIngredient[]{FluidIngredient.of((TagKey)dyeLiquid, (int)24)}).io(new ItemStack[]{new ItemStack((ItemLike)RegistryUtils.getItemFromID((ResourceLocation)new ResourceLocation(dye.m_41065_() + "_carpet")), 1)}).add(dye.m_41065_() + "_carpet", 128L, 5L);
        }
    }

    private static void addCoverRecipe(ItemStack cover, Ingredient ... inputs) {
        RecipeMaps.ASSEMBLER.RB().ii(inputs).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(72)}).io(new ItemStack[]{cover}).add(RegistryUtils.getIdFromItem((Item)cover.m_41720_()).m_135815_() + "_soldering_alloy", 800L, 16L);
        RecipeMaps.ASSEMBLER.RB().ii(inputs).fi(new FluidStack[]{Materials.Lead.getLiquid(288)}).io(new ItemStack[]{cover}).add(RegistryUtils.getIdFromItem((Item)cover.m_41720_()).m_135815_() + "_lead", 800L, 16L);
        RecipeMaps.ASSEMBLER.RB().ii(inputs).fi(new FluidStack[]{Materials.Tin.getLiquid(144)}).io(new ItemStack[]{cover}).add(RegistryUtils.getIdFromItem((Item)cover.m_41720_()).m_135815_() + "_tin", 800L, 16L);
    }

    private static void motors() {
        Arrays.stream(Tier.getStandardWithIV()).forEach(t -> {
            Material magnet = t == Tier.ULV || t == Tier.LV ? Materials.IronMagnetic : (t == Tier.EV || t == Tier.IV ? Materials.NeodymiumMagnetic : Materials.SteelMagnetic);
            RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.ofObject((Object)TierMaps.WIRE_GETTER.apply(Parts.fromTier(t), Tier.LV), (int)4), RecipeIngredient.of((ItemLike)GTMaterialTypes.ROD.get((Material)TierMaps.TIER_MATERIALS.get(t)), (int)2), RecipeIngredient.of((ItemLike)GTMaterialTypes.ROD.get(magnet), (int)1), RecipeIngredient.ofObject((Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, t, (Object)false), (int)2)}).io(new ItemStack[]{new ItemStack((ItemLike)GTAPI.get(ItemBasic.class, (String)("motor_" + t.getId()), (String)"gtcore"))}).add("motor_" + t.getId(), 150L, 16L);
            RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GT5RCovers.COVER_PUMP.getItem(t)), RecipeIngredient.of(TierMaps.TIER_CIRCUITS.apply((Tier)t), (int)2)}).io(new ItemStack[]{GT5RCovers.COVER_FLUID_REGULATOR.getItem(t)}).add("fluid_regulator_" + t.getId(), 800L, 8L);
            RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemStack)GT5RCovers.COVER_CONVEYOR.getItem(t)), RecipeIngredient.of(TierMaps.TIER_CIRCUITS.apply((Tier)t), (int)2)}).io(new ItemStack[]{GT5RCovers.COVER_ITEM_REGULATOR.getItem(t)}).add("item_regulator_" + t.getId(), 800L, 8L);
        });
    }

    private static void pistons() {
        Arrays.stream(Tier.getStandardWithIV()).forEach(t -> RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.ofObject((Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, t, (Object)false), (int)2), RecipeIngredient.of((ItemLike)GTMaterialTypes.ROD.get((Material)TierMaps.TIER_MATERIALS.get(t)), (int)2), RecipeIngredient.of((ItemLike)GTMaterialTypes.PLATE.get((Material)TierMaps.TIER_MATERIALS.get(t)), (int)3), RecipeIngredient.of((ItemLike)((ItemLike)GTAPI.get(ItemBasic.class, (String)("motor_" + t.getId()), (String)"gtcore")), (int)1), RecipeIngredient.of((ItemLike)GTMaterialTypes.SMALL_GEAR.get((Material)TierMaps.TIER_MATERIALS.get(t)), (int)1)}).io(new ItemStack[]{new ItemStack((ItemLike)GT5Reimagined.get(ItemBasic.class, "piston_" + t.getId()))}).add("piston_" + t.getId(), 150L, 16L));
    }

    private static void pumps() {
        Arrays.stream(Tier.getStandardWithIV()).forEach(t -> RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.ofObject((Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, t, (Object)false), (int)1), GTMaterialTypes.SCREW.getMaterialIngredient((Material)TierMaps.TIER_ROTORS.get(t), 1), GTMaterialTypes.ROTOR.getMaterialIngredient((Material)TierMaps.TIER_ROTORS.get(t), 1), GTMaterialTypes.RING.getMaterialIngredient(Materials.Rubber, 2), RecipeIngredient.ofObject((Object)TierMaps.PIPE_GETTER.apply(PipeSize.NORMAL, (Tier)t), (int)1), RecipeIngredient.of((ItemLike)((ItemLike)GTAPI.get(ItemBasic.class, (String)("motor_" + t.getId()), (String)"gtcore")), (int)1)}).io(new ItemStack[]{GT5RCovers.COVER_PUMP.getItem(t)}).add("pump_" + t.getId(), 150L, 16L));
    }

    private static void rotors() {
        GTMaterialTypes.ROTOR.all().forEach(r -> RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(r, 4), GTMaterialTypes.RING.getMaterialIngredient(r, 1)}).fi(new FluidStack[]{Materials.SolderingAlloy.getLiquid(144)}).io(new ItemStack[]{new ItemStack((ItemLike)GTMaterialTypes.ROTOR.get(r), 1)}).add(r.getId() + "_rotor", 240L, 24L));
    }

    private static void turbines() {
        MaterialTags.TOOLS.getAll().forEach((m, t) -> {
            if (t.toolTypes().contains(ToolTypes.SMALL_TURBINE_ROTOR)) {
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GT5RMaterialTypes.TURBINE_BLADE.getMaterialIngredient(m, 4), GTMaterialTypes.LONG_ROD.getMaterialIngredient(Materials.Magnalium, 1)}).io(new ItemStack[]{ToolTypes.SMALL_TURBINE_ROTOR.getToolStack(m)}).add(m.getId() + "_small_turbine_rotor", 320L, 16L);
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GT5RMaterialTypes.TURBINE_BLADE.getMaterialIngredient(m, 2), GT5RMaterialTypes.SMALL_BROKEN_TURBINE_ROTOR.getMaterialIngredient(m, 1)}).io(new ItemStack[]{ToolTypes.SMALL_TURBINE_ROTOR.getToolStack(m)}).add(m.getId() + "_small_turbine_rotor_from_broken", 160L, 16L);
            }
            if (t.toolTypes().contains(ToolTypes.TURBINE_ROTOR)) {
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GT5RMaterialTypes.TURBINE_BLADE.getMaterialIngredient(m, 8), GTMaterialTypes.LONG_ROD.getMaterialIngredient(Materials.Titanium, 1)}).io(new ItemStack[]{ToolTypes.TURBINE_ROTOR.getToolStack(m)}).add(m.getId() + "_turbine_rotor", 480L, 64L);
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GT5RMaterialTypes.TURBINE_BLADE.getMaterialIngredient(m, 4), GT5RMaterialTypes.BROKEN_TURBINE_ROTOR.getMaterialIngredient(m, 1)}).io(new ItemStack[]{ToolTypes.TURBINE_ROTOR.getToolStack(m)}).add(m.getId() + "_turbine_rotor_from_broken", 240L, 64L);
            }
            if (t.toolTypes().contains(ToolTypes.LARGE_TURBINE_ROTOR)) {
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GT5RMaterialTypes.TURBINE_BLADE.getMaterialIngredient(m, 12), GTMaterialTypes.LONG_ROD.getMaterialIngredient(Materials.TungstenSteel, 1)}).io(new ItemStack[]{ToolTypes.LARGE_TURBINE_ROTOR.getToolStack(m)}).add(m.getId() + "_large_turbine_rotor", 640L, 64L);
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GT5RMaterialTypes.TURBINE_BLADE.getMaterialIngredient(m, 6), GT5RMaterialTypes.LARGE_BROKEN_TURBINE_ROTOR.getMaterialIngredient(m, 1)}).io(new ItemStack[]{ToolTypes.LARGE_TURBINE_ROTOR.getToolStack(m)}).add(m.getId() + "_large_turbine_rotor_from_broken", 320L, 64L);
            }
            if (t.toolTypes().contains(ToolTypes.HUGE_TURBINE_ROTOR)) {
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GT5RMaterialTypes.TURBINE_BLADE.getMaterialIngredient(m, 16), GTMaterialTypes.LONG_ROD.getMaterialIngredient(Materials.Adamantium, 1)}).io(new ItemStack[]{ToolTypes.HUGE_TURBINE_ROTOR.getToolStack(m)}).add(m.getId() + "_huge_turbine_rotor", 960L, 256L);
                RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GT5RMaterialTypes.TURBINE_BLADE.getMaterialIngredient(m, 8), GT5RMaterialTypes.HUGE_BROKEN_TURBINE_ROTOR.getMaterialIngredient(m, 1)}).io(new ItemStack[]{ToolTypes.HUGE_TURBINE_ROTOR.getToolStack(m)}).add(m.getId() + "_huge_turbine_rotor_from_broken", 480L, 256L);
            }
        });
    }

    private static void addTierCasing(Tier tier) {
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((TagKey)GTMaterialTypes.PLATE.getMaterialTag((Material)TierMaps.TIER_MATERIALS.get((Object)tier)), (int)8), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)8)}).io(new ItemStack[]{new ItemStack((ItemLike)GTAPI.get(BlockCasing.class, (String)("casing_" + tier.getId()), (String)"gt5r"))}).add("casing_" + tier.getId(), 50L, 16L);
    }

    private static void addTierHull(Tier tier) {
        Material liquid = tier == Tier.ZPM || tier == Tier.UV || tier == Tier.UHV ? Materials.Polytetrafluoroethylene : Materials.Plastic;
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.ofObject((Object)TierMaps.CABLE_GETTER.apply((Object)(tier == Tier.UV ? PipeSize.SMALL : PipeSize.VTINY), (Object)tier, (Object)false), (int)2), RecipeIngredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)GTAPI.get(BlockCasing.class, (String)("casing_" + tier.getId()), (String)"gt5r")})}).fi(new FluidStack[]{liquid.getLiquid(288)}).io(new ItemStack[]{new ItemStack((ItemLike)GT5RMachines.HULL.getItem(tier))}).add("hull_" + tier.getId(), 50L, 16L);
    }

    private static void addCasing(Material mat, BlockCasing casing) {
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.FRAME.get()).get(mat).asItem(), (int)1), RecipeIngredient.of((ItemLike)GTMaterialTypes.PLATE.get(mat), (int)6)}).io(new ItemStack[]{new ItemStack((ItemLike)casing, 1)}).add(RegistryUtils.getIdFromBlock((Block)casing).m_135815_(), 80L, 30L);
    }

    private static void addWall(Material mat, BlockColoredWall casing) {
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{GTMaterialTypes.PLATE.getMaterialIngredient(mat, 4), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)24)}).io(new ItemStack[]{new ItemStack((ItemLike)casing, 1)}).add(RegistryUtils.getIdFromBlock((Block)casing).m_135815_(), 80L, 30L);
    }

    private static void addCoil(BlockCoil coil, PipeItemBlock wire) {
        RecipeMaps.ASSEMBLER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)wire, (int)8), (Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)8)}).io(new ItemStack[]{new ItemStack((ItemLike)coil, 1)}).add(RegistryUtils.getIdFromBlock((Block)coil).m_135815_(), 100L, 30L);
    }
}

