/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.machines;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gt5r.GT5RConfig;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.GT5RMaterialTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.RecipeMaps;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreMaterials;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.recipe.ingredient.RecipeIngredient;

public class AlloySmelterLoader {
    public static void init() {
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Lead, (Object)1, (Object)Materials.Redstone, (Object)4), GTCoreMaterials.LeadedRedstone, 1);
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Arsenic, (Object)1, (Object)Materials.Gallium, (Object)1), Materials.GalliumArsenide);
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Tin, (Object)1, (Object)Materials.Iron, (Object)1), Materials.TinAlloy);
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Silver, (Object)1, (Object)Materials.Gold, (Object)1), Materials.Electrum);
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Tin, (Object)9, (Object)Materials.Antimony, (Object)1), Materials.SolderingAlloy);
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Cadmium, (Object)1, (Object)Materials.Indium, (Object)1, (Object)Materials.Silver, (Object)1), Materials.CdInAGAlloy);
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Iron, (Object)2, (Object)Materials.Nickel, (Object)1), Materials.Invar);
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Copper, (Object)1, (Object)Materials.Redstone, (Object)4), Materials.RedAlloy, 1);
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Indium, (Object)1, (Object)Materials.Gallium, (Object)1, (Object)Materials.Phosphor, (Object)1), Materials.IndiumGalliumPhosphide);
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Lead, (Object)4, (Object)Materials.Antimony, (Object)1), Materials.BatteryAlloy);
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Copper, (Object)1, (Object)Materials.Nickel, (Object)1), Materials.Cupronickel);
        if (GTAPI.isModLoaded((String)"tfc")) {
            AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Tin, (Object)1, (Object)Materials.Copper, (Object)9), Materials.Bronze);
            AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Zinc, (Object)1, (Object)Materials.Copper, (Object)9), Materials.Brass);
            AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Bismuth, (Object)2, (Object)Materials.Zinc, (Object)3, (Object)Materials.Copper, (Object)5), Materials.BismuthBronze, 10, 10, "bismuth_bronze_ingot");
        } else {
            AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Tin, (Object)1, (Object)Materials.Copper, (Object)3), Materials.Bronze);
            AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Zinc, (Object)1, (Object)Materials.Copper, (Object)3), Materials.Brass);
            AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Bismuth, (Object)1, (Object)Materials.Brass, (Object)4), Materials.BismuthBronze);
        }
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Copper, (Object)1, (Object)Materials.Gold, (Object)4), Materials.RoseGold);
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Copper, (Object)1, (Object)Materials.Silver, (Object)4), Materials.SterlingSilver);
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Copper, (Object)3, (Object)Materials.Electrum, (Object)2), Materials.BlackBronze);
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Gold, (Object)4, (Object)Materials.NetheriteScrap, (Object)4), Materials.Netherite, 1);
        if (GT5RConfig.HARDER_ALUMINIUM_PROCESSING.get()) {
            AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Magnesium, (Object)1, (Object)Materials.Aluminium, (Object)2), Materials.Magnalium);
            AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Brass, (Object)7, (Object)Materials.Aluminium, (Object)1, (Object)Materials.Cobalt, (Object)1), Materials.CobaltBrass);
        }
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Copper, (Object)1, (Object)Materials.Silver, (Object)2, (Object)Materials.RedAlloy, (Object)5), Materials.Signalum, 8);
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Copper, (Object)1, (Object)Materials.SterlingSilver, (Object)5, (Object)Materials.RedAlloy, (Object)10), Materials.Signalum, 16, -1, "signalum_ingot_extra");
        AlloySmelterLoader.addAlloyRecipes((ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Tin, (Object)3, (Object)Materials.Silver, (Object)1, (Object)Materials.Glowstone, (Object)4), Materials.Lumium, 4);
        RecipeMaps.ALLOY_SMELTER.RB().ii(new Ingredient[]{RecipeIngredient.of((ItemLike)GTMaterialTypes.DUST.get(Materials.RawRubber), (int)3), RecipeIngredient.of((TagKey)GTMaterialTypes.DUST.getMaterialTag(Materials.Sulfur), (int)1)}).io(new ItemStack[]{GTMaterialTypes.INGOT.get(Materials.Rubber, 1)}).add("rubber_via_alloy_smelter", 20L, 10L);
        GTMaterialTypes.PLATE.all().stream().filter(m -> !m.has(new IMaterialTag[]{GT5RMaterialTags.NEEDS_BLAST_FURNACE}) && m.has(new IMaterialTag[]{GTMaterialTypes.INGOT})).forEach(m -> {
            int euPerTick = m.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) ? 8 : 32;
            RecipeMaps.ALLOY_SMELTER.RB().tags(new String[]{"alloy_smelter_molding"}).ii(new Ingredient[]{GTMaterialTypes.INGOT.getMaterialIngredient(m, 2), RecipeIngredient.of((ItemLike)GTCoreItems.MoldPlate, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.PLATE.get(m, 1)}).add(m.getId() + "_plate", m.getMass() * 2L, (long)euPerTick);
            if (m.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS})) {
                RecipeMaps.ALLOY_SMELTER.RB().tags(new String[]{"alloy_smelter_molding"}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(m, 2), RecipeIngredient.of((ItemLike)GTCoreItems.MoldPlate, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.PLATE.get(m, 1)}).add(m.getId() + "_plate_from_dust", m.getMass() * 2L, (long)euPerTick);
            }
        });
        GTMaterialTypes.INGOT.all().stream().filter(m -> !m.has(new IMaterialTag[]{GT5RMaterialTags.NEEDS_BLAST_FURNACE})).forEach(m -> {
            if (m.has(new IMaterialTag[]{GTMaterialTypes.NUGGET})) {
                RecipeMaps.ALLOY_SMELTER.RB().tags(new String[]{"alloy_smelter_molding"}).ii(new Ingredient[]{GTMaterialTypes.NUGGET.getMaterialIngredient(m, 9), RecipeIngredient.of((ItemLike)GTCoreItems.MoldIngot, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.INGOT.get(m, 1)}).add(m.getId() + "_ingot_from_nugget", 200L, 2L);
            }
            if (m.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS})) {
                RecipeMaps.ALLOY_SMELTER.RB().tags(new String[]{"alloy_smelter_molding"}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(m, 1), RecipeIngredient.of((ItemLike)GTCoreItems.MoldIngot, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.INGOT.get(m, 1)}).add(m.getId() + "_ingot_from_dust", m.getMass(), 10L);
            }
        });
        GTMaterialTypes.ITEM_CASING.all().forEach(m -> RecipeMaps.ALLOY_SMELTER.RB().tags(new String[]{"alloy_smelter_molding"}).ii(new Ingredient[]{GTMaterialTypes.INGOT.getMaterialIngredient(m, 2), RecipeIngredient.of((ItemLike)GTCoreItems.MoldCasing, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.ITEM_CASING.get(m, 3)}).add(m.getId() + "_item_casing", Math.max(m.getMass() * 2L / 3L, 1L), 16L));
        GTMaterialTypes.GEAR.all().stream().filter(m -> !m.has(new IMaterialTag[]{GT5RMaterialTags.NEEDS_BLAST_FURNACE}) && m.has(new IMaterialTag[]{GTMaterialTypes.INGOT})).forEach(m -> {
            int euPerTick = m.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS}) ? 8 : 32;
            RecipeMaps.ALLOY_SMELTER.RB().tags(new String[]{"alloy_smelter_molding"}).ii(new Ingredient[]{GTMaterialTypes.INGOT.getMaterialIngredient(m, 8), RecipeIngredient.of((ItemLike)GTCoreItems.MoldGear, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.GEAR.get(m, 1)}).add(m.getId() + "_gear", m.getMass() * 8L, (long)euPerTick);
            if (m.has(new IMaterialTag[]{MaterialTags.RUBBERTOOLS})) {
                RecipeMaps.ALLOY_SMELTER.RB().tags(new String[]{"alloy_smelter_molding"}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(m, 8), RecipeIngredient.of((ItemLike)GTCoreItems.MoldGear, (int)1).setNoConsume()}).io(new ItemStack[]{GTMaterialTypes.GEAR.get(m, 1)}).add(m.getId() + "_gear_from_dust", m.getMass() * 8L, (long)euPerTick);
            }
        });
        RecipeMaps.ALLOY_SMELTER.RB().tags(new String[]{"alloy_smelter_molding"}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Glass, 1), RecipeIngredient.of((ItemLike)GTCoreItems.MoldBall, (int)1).setNoConsume()}).io(new Item[]{GT5RItems.GlassTube}).add("glass_tube", 160L, 8L);
        RecipeMaps.ALLOY_SMELTER.RB().tags(new String[]{"alloy_smelter_molding"}).ii(new Ingredient[]{GTMaterialTypes.DUST.getMaterialIngredient(Materials.Glass, 1), RecipeIngredient.of((ItemLike)GTCoreItems.MoldBottle, (int)1).setNoConsume()}).io(new Item[]{Items.f_42590_}).add("glass_bottle", 64L, 4L);
        RecipeMaps.ALLOY_SMELTER.RB().tags(new String[]{"alloy_smelter_molding"}).ii(new Ingredient[]{GTMaterialTypes.INGOT.getMaterialIngredient(Materials.Iron, 31), RecipeIngredient.of((ItemLike)GTCoreItems.MoldAnvil, (int)1).setNoConsume()}).io(new Item[]{Items.f_42146_}).add("anvil", 512L, 64L);
    }

    public static void addAlloyRecipes(ImmutableMap<Material, Integer> inputs, Material output) {
        AlloySmelterLoader.addAlloyRecipes(inputs, output, inputs.values().stream().mapToInt(i -> i).sum(), -1, output.getId() + "_ingot");
    }

    public static void addAlloyRecipes(ImmutableMap<Material, Integer> inputs, Material output, int amount) {
        AlloySmelterLoader.addAlloyRecipes(inputs, output, amount, -1, output.getId() + "_ingot");
    }

    public static void addAlloyRecipes(ImmutableMap<Material, Integer> inputs, Material output, int amount, int circuit, String id) {
        if (inputs.size() > 1) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            inputs.forEach((m, i) -> {
                ArrayList<TagKey> tags = new ArrayList<TagKey>();
                if (m.has(new IMaterialTag[]{GTMaterialTypes.DUST})) {
                    tags.add(GTMaterialTypes.DUST.getMaterialTag(m));
                }
                if (m.has(new IMaterialTag[]{GTMaterialTypes.INGOT})) {
                    tags.add(GTMaterialTypes.INGOT.getMaterialTag(m));
                }
                if (m == Materials.Copper) {
                    tags.add(GTMaterialTypes.INGOT.getMaterialTag(Materials.AnnealedCopper));
                }
                ingredients.add((Ingredient)RecipeIngredient.of((int)i, (TagKey[])((TagKey[])tags.toArray(TagKey[]::new))));
            });
            if (circuit >= 0) {
                ingredients.add((Ingredient)GTCoreItems.SELECTOR_TAG_INGREDIENTS.get((Object)circuit));
            }
            RecipeMaps.ALLOY_SMELTER.RB().ii(ingredients).io(new ItemStack[]{GTMaterialTypes.INGOT.get(output, amount)}).add(id, 100L, 12L);
        }
    }
}

