/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.crafting;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gtcore.block.RedstoneWire;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.Cable;
import org.gtreimagined.gtlib.pipe.types.Wire;
import org.gtreimagined.gtlib.util.RegistryUtils;

public class WireCablesPlates {
    public static void loadRecipes(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        GTAPI.all(Wire.class, wire -> {
            Cable cable = (Cable)GTAPI.get(Cable.class, (String)("cable_" + wire.getMaterial().getId()));
            ImmutableSet sizes = wire.getSizes();
            Map<PipeSize, Item> wires = sizes.stream().map(s -> new Pair(s, (Object)wire.getBlockItem(s))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
            PipeSize[] val = PipeSize.VALUES;
            for (int i = 1; i < val.length; ++i) {
                int offset;
                int n = offset = val[i] == PipeSize.HUGE ? 1 : 0;
                if (val[i] == PipeSize.LARGE) {
                    provider.shapeless(output, "three_to_one_" + RegistryUtils.getIdFromItem((Item)wires.get(PipeSize.LARGE)).m_135815_(), "wire", new ItemStack((ItemLike)wires.get(val[i]), 1), new Object[]{wires.get(PipeSize.SMALL), wires.get(PipeSize.SMALL), wires.get(PipeSize.SMALL)});
                    provider.shapeless(output, "one_to_three_" + RegistryUtils.getIdFromItem((Item)wires.get(PipeSize.NORMAL)).m_135815_(), "wire", new ItemStack((ItemLike)wires.get(PipeSize.SMALL), 3), new Object[]{wires.get(val[i])});
                    continue;
                }
                WireCablesPlates.twoToOne(wires, val[i - 1 - offset], val[i], output, provider);
                WireCablesPlates.oneToTwo(wires, val[i], val[i - 1 - offset], output, provider);
                if (i <= 1) continue;
                WireCablesPlates.fourToOne(wires, val[i - 2 - offset], val[i], output, provider);
            }
            if (wire.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.PLATE})) {
                provider.shapeless(output, wire.getMaterial().getId() + "_plate_to_wire", "wire", new ItemStack((ItemLike)wires.get(PipeSize.VTINY)), new Object[]{GTTools.WIRE_CUTTER.getTag(), GTMaterialTypes.PLATE.get(wire.getMaterial())});
            }
            if (cable != null) {
                provider.shapeless(output, "gt5r", wire.getId() + "_cable_1x", "cables", new ItemStack((ItemLike)cable.getBlockItem(PipeSize.VTINY)), new Object[]{wire.getBlockItem(PipeSize.VTINY), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber)});
                provider.shapeless(output, "gt5r", wire.getId() + "_cable_2x", "cables", new ItemStack((ItemLike)cable.getBlockItem(PipeSize.TINY)), new Object[]{wire.getBlockItem(PipeSize.TINY), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber)});
                provider.shapeless(output, "gt5r", wire.getId() + "_cable_4x", "cables", new ItemStack((ItemLike)cable.getBlockItem(PipeSize.SMALL)), new Object[]{wire.getBlockItem(PipeSize.SMALL), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber)});
                provider.shapeless(output, "gt5r", wire.getId() + "_cable_8x", "cables", new ItemStack((ItemLike)cable.getBlockItem(PipeSize.NORMAL)), new Object[]{wire.getBlockItem(PipeSize.NORMAL), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber)});
                provider.shapeless(output, "gt5r", wire.getId() + "_cable_12x", "cables", new ItemStack((ItemLike)cable.getBlockItem(PipeSize.LARGE)), new Object[]{wire.getBlockItem(PipeSize.LARGE), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber)});
                provider.shapeless(output, "gt5r", wire.getId() + "_cable_16x", "cables", new ItemStack((ItemLike)cable.getBlockItem(PipeSize.HUGE)), new Object[]{wire.getBlockItem(PipeSize.HUGE), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber), GTMaterialTypes.PLATE.getMaterialTag(Materials.Rubber)});
            }
        });
        GTAPI.all(RedstoneWire.class, wire -> {
            if (wire.getMaterial().has(new IMaterialTag[]{GTMaterialTypes.PLATE})) {
                provider.shapeless(output, wire.getMaterial().getId() + "_plate_to_wire", "wire", new ItemStack((ItemLike)wire.getBlockItem(PipeSize.VTINY)), new Object[]{GTTools.WIRE_CUTTER.getTag(), GTMaterialTypes.PLATE.get(wire.getMaterial())});
            }
        });
    }

    private static void twoToOne(Map<PipeSize, Item> wires, PipeSize from, PipeSize to, Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        provider.shapeless(output, "two_to_one_" + RegistryUtils.getIdFromItem((Item)wires.get(to)).m_135815_(), "wire", new ItemStack((ItemLike)wires.get(to), 1), new Object[]{wires.get(from), wires.get(from)});
    }

    private static void oneToTwo(Map<PipeSize, Item> wires, PipeSize from, PipeSize to, Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        provider.shapeless(output, "one_to_two_" + RegistryUtils.getIdFromItem((Item)wires.get(to)).m_135815_(), "wire", new ItemStack((ItemLike)wires.get(to), 2), new Object[]{wires.get(from)});
    }

    private static void fourToOne(Map<PipeSize, Item> wires, PipeSize from, PipeSize to, Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        provider.shapeless(output, "four_to_one_" + RegistryUtils.getIdFromItem((Item)wires.get(to)).m_135815_(), "wire", new ItemStack((ItemLike)wires.get(to), 1), new Object[]{wires.get(from), wires.get(from), wires.get(from), wires.get(from)});
    }
}

