/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.crafting;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.gtreimagined.gt5r.data.GT5RMaterialTypes;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.ForgeTags;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTypeBlock;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.ItemPipe;
import org.gtreimagined.gtlib.util.Utils;

public class MaterialCrafting {
    public static void loadRecipes(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        if (!GTAPI.isModLoaded((String)"tfc")) {
            MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.Bronze, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Copper, (Object)3, (Object)Materials.Tin, (Object)1));
            MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.Brass, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Copper, (Object)3, (Object)Materials.Zinc, (Object)1));
            MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.BismuthBronze, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Copper, (Object)3, (Object)Materials.Bismuth, (Object)1, (Object)Materials.Zinc, (Object)1));
        }
        MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.BlackBronze, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Copper, (Object)3, (Object)Materials.Silver, (Object)1, (Object)Materials.Gold, (Object)1));
        MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.TinAlloy, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Tin, (Object)1, (Object)Materials.Iron, (Object)1));
        MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.BlackSteel, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Steel, (Object)3, (Object)Materials.BlackBronze, (Object)1, (Object)Materials.Nickel, (Object)1));
        MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.Electrum, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Gold, (Object)1, (Object)Materials.Silver, (Object)1));
        MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.Invar, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Iron, (Object)2, (Object)Materials.Nickel, (Object)1));
        MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.Cupronickel, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Copper, (Object)1, (Object)Materials.Nickel, (Object)1));
        MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.RoseGold, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Gold, (Object)4, (Object)Materials.Copper, (Object)1));
        MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.SterlingSilver, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Silver, (Object)4, (Object)Materials.Copper, (Object)1));
        MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.RedSteel, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.BlackSteel, (Object)4, (Object)Materials.Steel, (Object)2, (Object)Materials.Brass, (Object)1, (Object)Materials.RoseGold, (Object)1));
        MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.BlueSteel, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.BlackSteel, (Object)4, (Object)Materials.Steel, (Object)2, (Object)Materials.BismuthBronze, (Object)1, (Object)Materials.SterlingSilver, (Object)1));
        MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.CobaltBrass, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Brass, (Object)7, (Object)Materials.Aluminium, (Object)1, (Object)Materials.Cobalt, (Object)1));
        MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.GalliumArsenide, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Gallium, (Object)1, (Object)Materials.Arsenic, (Object)1));
        MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.IndiumGalliumPhosphide, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.Indium, (Object)1, (Object)Materials.Gallium, (Object)1, (Object)Materials.Phosphor, (Object)1));
        MaterialCrafting.addShapelessDustRecipe(output, provider, Materials.Signalum, (ImmutableMap<Material, Integer>)ImmutableMap.of((Object)Materials.RedAlloy, (Object)5, (Object)Materials.Silver, (Object)2, (Object)Materials.Copper, (Object)1));
        provider.shapeless(output, "gt5r", "", "dusts", GTMaterialTypes.SMALL_DUST.get(Materials.Clay, 2), new Object[]{GTTools.MORTAR.getTag(), Items.f_42461_});
        provider.addItemRecipe(output, "gt5r", "copper_ingot", "ingots", (ItemLike)GTMaterialTypes.INGOT.get(Materials.Copper), ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.NUGGET.getMaterialTag(Materials.Copper)), new String[]{"III", "III", "III"});
        MaterialCrafting.loadAutoRecipes(output, provider);
        MaterialCrafting.loadMixedMetal(output, provider);
    }

    public static void loadMixedMetal(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider) {
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Iron, Materials.Bronze, Materials.Tin, 1);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Iron, Materials.Bronze, Materials.Zinc, 1);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Iron, Materials.Bronze, Materials.Aluminium, 1);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Iron, Materials.Brass, Materials.Tin, 1);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Iron, Materials.Brass, Materials.Zinc, 1);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Iron, Materials.Brass, Materials.Aluminium, 1);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Nickel, Materials.Bronze, Materials.Tin, 1);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Nickel, Materials.Bronze, Materials.Zinc, 1);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Nickel, Materials.Bronze, Materials.Aluminium, 1);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Nickel, Materials.Brass, Materials.Tin, 1);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Nickel, Materials.Brass, Materials.Zinc, 1);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Nickel, Materials.Brass, Materials.Aluminium, 1);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Invar, Materials.Bronze, Materials.Tin, 2);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Invar, Materials.Bronze, Materials.Zinc, 2);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Invar, Materials.Bronze, Materials.Aluminium, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Invar, Materials.Brass, Materials.Tin, 2);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Invar, Materials.Brass, Materials.Zinc, 2);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Invar, Materials.Brass, Materials.Aluminium, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Steel, Materials.Bronze, Materials.Tin, 2);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Steel, Materials.Bronze, Materials.Zinc, 2);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Steel, Materials.Bronze, Materials.Aluminium, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Steel, Materials.Brass, Materials.Tin, 2);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Steel, Materials.Brass, Materials.Zinc, 2);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Steel, Materials.Brass, Materials.Aluminium, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.StainlessSteel, Materials.Bronze, Materials.Tin, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.StainlessSteel, Materials.Bronze, Materials.Zinc, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.StainlessSteel, Materials.Bronze, Materials.Aluminium, 4);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.StainlessSteel, Materials.Brass, Materials.Tin, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.StainlessSteel, Materials.Brass, Materials.Zinc, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.StainlessSteel, Materials.Brass, Materials.Aluminium, 4);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Titanium, Materials.Bronze, Materials.Tin, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Titanium, Materials.Bronze, Materials.Zinc, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Titanium, Materials.Bronze, Materials.Aluminium, 4);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Titanium, Materials.Brass, Materials.Tin, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Titanium, Materials.Brass, Materials.Zinc, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Titanium, Materials.Brass, Materials.Aluminium, 4);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Tungsten, Materials.Bronze, Materials.Tin, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Tungsten, Materials.Bronze, Materials.Zinc, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Tungsten, Materials.Bronze, Materials.Aluminium, 4);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Tungsten, Materials.Brass, Materials.Tin, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Tungsten, Materials.Brass, Materials.Zinc, 3);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.Tungsten, Materials.Brass, Materials.Aluminium, 4);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.TungstenSteel, Materials.Bronze, Materials.Tin, 5);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.TungstenSteel, Materials.Bronze, Materials.Zinc, 5);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.TungstenSteel, Materials.Bronze, Materials.Aluminium, 6);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.TungstenSteel, Materials.Brass, Materials.Tin, 5);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.TungstenSteel, Materials.Brass, Materials.Zinc, 5);
        MaterialCrafting.mixedMetalRecipe(consumer, provider, Materials.TungstenSteel, Materials.Brass, Materials.Aluminium, 6);
    }

    public static void mixedMetalRecipe(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider, Material top, Material middle, Material bottom, int amount) {
        provider.addStackRecipe(consumer, "gt5r", "mixed_metal_from_" + top.getId() + "_" + middle.getId() + "_" + bottom.getId(), "mixed_metal", Utils.ca((int)amount, (ItemStack)GTCoreItems.MixedMetalIngot.getMixedMetalIngot(top, middle, bottom)), ImmutableMap.of((Object)Character.valueOf('T'), (Object)GTMaterialTypes.PLATE.getMaterialTag(top), (Object)Character.valueOf('M'), (Object)GTMaterialTypes.PLATE.getMaterialTag(middle), (Object)Character.valueOf('B'), (Object)GTMaterialTypes.PLATE.getMaterialTag(bottom)), new String[]{"T", "M", "B"});
    }

    public static void loadAutoRecipes(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider) {
        GTMaterialTypes.DUST.all().forEach(m -> provider.addStackRecipe(consumer, "gt5r", m.getId() + "_small_dust", "gt_materials", GTMaterialTypes.SMALL_DUST.get(m, 4), ImmutableMap.of((Object)Character.valueOf('D'), (Object)GTMaterialTypes.DUST.getMaterialTag(m)), new String[]{" D"}));
        GT5RMaterialTypes.TURBINE_BLADE.all().forEach(m -> provider.addStackRecipe(consumer, "gt5r", "", "gt_materials", GT5RMaterialTypes.TURBINE_BLADE.get(m, 1), ImmutableMap.builder().put((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()).put((Object)Character.valueOf('F'), (Object)GTTools.FILE.getTag()).put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m)).put((Object)Character.valueOf('s'), (Object)GTMaterialTypes.SCREW.getMaterialTag(m)).build(), new String[]{"FPS", "sPs", " P "}));
        GT5RMaterialTypes.CHAMBER.all().forEach(m -> {
            if (!m.has(new IMaterialTag[]{GTMaterialTypes.GEM}) && !m.has(new IMaterialTag[]{GTMaterialTypes.PLATE})) {
                return;
            }
            TagKey input = m == Materials.Quartz ? ForgeTags.GEMS_QUARTZ_ALL : (m.has(new IMaterialTag[]{GTMaterialTypes.GEM}) ? GTMaterialTypes.GEM.getMaterialTag(m) : GTMaterialTypes.PLATE.getMaterialTag(m));
            provider.addItemRecipe(consumer, "chambers", (ItemLike)GT5RMaterialTypes.CHAMBER.get(m), ImmutableMap.of((Object)Character.valueOf('I'), (Object)input, (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()), new String[]{"IHI", "IWI", "III"});
        });
        GTAPI.all(ItemPipe.class, i -> {
            if (i.getSizes().contains((Object)PipeSize.NORMAL)) {
                provider.addStackRecipe(consumer, "gt5r", "", "gt_pipes", new ItemStack((ItemLike)i.getRestrictedBlock(PipeSize.NORMAL), 1), ImmutableMap.of((Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.RING.getMaterialTag(Materials.Steel), (Object)Character.valueOf('P'), (Object)i.getBlock(PipeSize.NORMAL)), new String[]{" H ", "RPR", " R "});
            }
            if (i.getSizes().contains((Object)PipeSize.LARGE)) {
                provider.addStackRecipe(consumer, "gt5r", "", "gt_pipes", new ItemStack((ItemLike)i.getRestrictedBlock(PipeSize.LARGE), 1), ImmutableMap.of((Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.RING.getMaterialTag(Materials.Steel), (Object)Character.valueOf('P'), (Object)i.getBlock(PipeSize.LARGE)), new String[]{"HR ", "RPR", " R "});
            }
            if (i.getSizes().contains((Object)PipeSize.HUGE)) {
                provider.addStackRecipe(consumer, "gt5r", "", "gt_pipes", new ItemStack((ItemLike)i.getRestrictedBlock(PipeSize.HUGE), 1), ImmutableMap.of((Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.RING.getMaterialTag(Materials.Steel), (Object)Character.valueOf('P'), (Object)i.getBlock(PipeSize.HUGE)), new String[]{" H ", "RPR", "RRR"});
            }
        });
        GTMaterialTypes.RAW_ORE_BLOCK.all().forEach(m -> {
            if (m.has(new IMaterialTag[]{GTMaterialTypes.RAW_ORE})) {
                if (GTMaterialTypes.RAW_ORE.hasReplacement(m) && GTMaterialTypes.RAW_ORE_BLOCK.hasReplacement(m)) {
                    return;
                }
                provider.addItemRecipe(consumer, "blocks", (ItemLike)((MaterialTypeBlock.IBlockGetter)GTMaterialTypes.RAW_ORE_BLOCK.get()).get(m).asItem(), ImmutableMap.of((Object)Character.valueOf('I'), (Object)GTMaterialTypes.RAW_ORE.getMaterialTag(m)), new String[]{"III", "III", "III"});
                provider.shapeless(consumer, "", "blocks", GTMaterialTypes.RAW_ORE.get(m, 9), new Object[]{GTMaterialTypes.RAW_ORE_BLOCK.getMaterialTag(m)});
            }
        });
    }

    private static void addShapelessDustRecipe(Consumer<FinishedRecipe> consumer, GTRecipeProvider provider, Material output, ImmutableMap<Material, Integer> inputs) {
        int sum = inputs.values().stream().mapToInt(i -> i).sum();
        if (sum > 9) {
            return;
        }
        Object[] inputArray = new Object[sum];
        int index = 0;
        for (Map.Entry entry : inputs.entrySet()) {
            for (int i2 = 0; i2 < (Integer)entry.getValue(); ++i2) {
                inputArray[index] = GTMaterialTypes.DUST.getMaterialTag((Material)entry.getKey());
                ++index;
            }
        }
        provider.shapeless(consumer, "gt5r", output.getId() + "_dust", "dusts", GTMaterialTypes.DUST.get(output, sum), inputArray);
    }
}

