/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.loader.crafting;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import org.gtreimagined.gt5r.GT5RConfig;
import org.gtreimagined.gt5r.GT5Reimagined;
import org.gtreimagined.gt5r.block.BlockCasing;
import org.gtreimagined.gt5r.data.GT5RBlocks;
import org.gtreimagined.gt5r.data.GT5RCovers;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.GT5RMachines;
import org.gtreimagined.gt5r.data.GT5RMaterialTypes;
import org.gtreimagined.gt5r.data.GT5RTags;
import org.gtreimagined.gt5r.data.Materials;
import org.gtreimagined.gt5r.data.TierMaps;
import org.gtreimagined.gtcore.data.GTCoreBlocks;
import org.gtreimagined.gtcore.data.GTCoreItems;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtcore.machine.BarrelMachine;
import org.gtreimagined.gtcore.machine.BookShelfMachine;
import org.gtreimagined.gtcore.machine.ChestMachine;
import org.gtreimagined.gtcore.machine.LockerMachine;
import org.gtreimagined.gtcore.machine.MassStorageMachine;
import org.gtreimagined.gtcore.machine.MultiblockTankMachine;
import org.gtreimagined.gtcore.machine.WorkbenchMachine;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.data.GTMaterialTypes;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.datagen.providers.GTRecipeProvider;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.item.ItemCover;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.BasicMachine;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.machine.types.MultiMachine;
import org.gtreimagined.gtlib.material.IMaterialTag;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.material.MaterialTags;
import org.gtreimagined.gtlib.pipe.PipeItemBlock;
import org.gtreimagined.gtlib.pipe.PipeSize;
import org.gtreimagined.gtlib.pipe.types.Wire;

public class MachineRecipes {
    public static void loadRecipes(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        MachineRecipes.addBasicMachineRecipes(output, provider);
        MachineRecipes.addHatchRecipes(output, provider);
        MachineRecipes.addMultiblockRecipes(output, provider);
        MachineRecipes.addUtilityBlockRecipes(output, provider);
        MachineRecipes.addStorageTransformerRecipes(output, provider);
    }

    private static void addBasicMachineRecipes(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        Arrays.stream(Tier.getAllElectric()).forEach(tier -> {
            Material magicMaterial;
            PipeItemBlock wire;
            TagKey rotor;
            Item motor = (Item)GTAPI.get(ItemBasic.class, (String)("motor_" + tier.getId()), (String)"gtcore");
            if (motor == null) {
                return;
            }
            Item piston = (Item)GT5Reimagined.get(ItemBasic.class, "piston_" + tier.getId());
            if (piston == null) {
                return;
            }
            Item arm = (Item)GT5Reimagined.get(ItemCover.class, "robot_arm_" + tier.getId());
            if (arm == null) {
                return;
            }
            Item conveyor = (Item)GT5Reimagined.get(ItemCover.class, "conveyor_" + tier.getId());
            if (conveyor == null) {
                return;
            }
            Item pump = (Item)GT5Reimagined.get(ItemCover.class, "pump_" + tier.getId());
            if (pump == null) {
                return;
            }
            Item hull = GT5RMachines.HULL.getItem(tier);
            if (hull == null) {
                return;
            }
            Item sensor = (Item)GT5Reimagined.get(ItemBasic.class, "sensor_" + tier.getId());
            if (sensor == null) {
                return;
            }
            Item emitter = (Item)GT5Reimagined.get(ItemBasic.class, "emitter_" + tier.getId());
            if (emitter == null) {
                return;
            }
            Item field = (Item)GT5Reimagined.get(ItemBasic.class, "field_gen_" + tier.getId());
            if (field == null) {
                return;
            }
            TagKey<Item> circuit = TierMaps.TIER_CIRCUITS.apply((Tier)tier);
            if (circuit == null) {
                return;
            }
            Object cable = TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, tier, (Object)true);
            if (cable == null) {
                return;
            }
            TagKey tagKey = rotor = TierMaps.TIER_ROTORS.get(tier) == null ? null : GTMaterialTypes.ROTOR.getMaterialTag((Material)TierMaps.TIER_ROTORS.get(tier));
            if (rotor == null) {
                return;
            }
            Item glass = Items.f_41904_;
            Item diamond = Items.f_42415_;
            Material material = (Material)TierMaps.TIER_MATERIALS.getOrDefault(tier, (Object)Material.NULL);
            MachineRecipes.add(GT5RMachines.ALLOY_SMELTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), TierMaps.WIRE_GETTER.apply(PipeSize.SMALL, (Tier)tier)).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('G'), cable).build(), new String[]{"CLC", "LHL", "GLG"}));
            MachineRecipes.add(GT5RMachines.ARC_FURNACE, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('W'), (Object)GTMaterialTypes.DUST.get(Materials.Graphite), (Object)Character.valueOf('L'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, tier, (Object)true), (Object)Character.valueOf('H'), (Object)GTMaterialTypes.PLATE.get(material), (Object)Character.valueOf('M'), (Object)hull), new String[]{"LWL", "CMC", "HHH"}));
            MachineRecipes.add(GT5RMachines.ASSEMBLER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('R'), (Object)arm, (Object)Character.valueOf('O'), (Object)conveyor, (Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('H'), (Object)hull), new String[]{"RCR", "OHO", "LCL"}));
            MachineRecipes.add(GT5RMachines.AUTOCLAVE, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('T'), (Object)GTMaterialTypes.PLATE.getMaterialTag(material)).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('P'), (Object)pump).build(), new String[]{"TGT", "THT", "CPC"}));
            MachineRecipes.add(GT5RMachines.AUTOCRAFTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), cable).put((Object)Character.valueOf('R'), (Object)arm).put((Object)Character.valueOf('c'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()).build(), new String[]{"CRC", "RWR", "cHc"}));
            MachineRecipes.add(GT5RMachines.BENDER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('P'), (Object)piston, (Object)Character.valueOf('M'), (Object)motor, (Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('H'), (Object)hull), new String[]{"PLP", "CHC", "MLM"}));
            MachineRecipes.add(GT5RMachines.CANNER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('G'), (Object)glass).build(), new String[]{"LPL", "CHC", "GGG"}));
            MachineRecipes.add(GT5RMachines.CENTRIFUGE, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('M'), (Object)motor, (Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('H'), (Object)hull), new String[]{"CMC", "LHL", "CMC"}));
            MachineRecipes.add(GT5RMachines.CHEMICAL_REACTOR, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('R'), (Object)rotor).put((Object)Character.valueOf('L'), cable).build(), new String[]{"GRG", "LML", "CHC"}));
            MachineRecipes.add(GT5RMachines.COMPRESSOR, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('P'), (Object)piston, (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('H'), (Object)hull), new String[]{"LCL", "PHP", "LCL"}));
            Material chamber = tier == Tier.LV || tier == Tier.MV ? Materials.Quartz : Materials.Iridium;
            MachineRecipes.add(GT5RMachines.CRYSTALLIZATION_CHAMBER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('P'), TierMaps.PIPE_GETTER.apply(PipeSize.NORMAL, (Tier)tier)).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('g'), (Object)GT5RMaterialTypes.CHAMBER.getMaterialTag(chamber)).put((Object)Character.valueOf('W'), TierMaps.WIRE_GETTER.apply(PipeSize.SMALL, (Tier)tier)).build(), new String[]{"CgC", "PHP", "WWW"}));
            MachineRecipes.add(GT5RMachines.CROP_HARVESTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('R'), (Object)arm).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('S'), (Object)sensor).put((Object)Character.valueOf('B'), (Object)GTMaterialTypes.SWORD_BLADE.getMaterialTag(material)).put((Object)Character.valueOf('c'), (Object)conveyor).build(), new String[]{"RCR", "PHS", "BcB"}));
            MachineRecipes.add(GT5RMachines.CUTTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('D'), (Object)GTCoreItems.DiamondSawBlade).put((Object)Character.valueOf('V'), (Object)conveyor).put((Object)Character.valueOf('G'), (Object)glass).build(), new String[]{"LCG", "VHD", "CLM"}));
            MachineRecipes.add(GT5RMachines.DEHYDRATOR, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('W'), TierMaps.WIRE_GETTER.apply(PipeSize.SMALL, (Tier)tier)).put((Object)Character.valueOf('C'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, tier, (Object)true)).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('c'), (Object)circuit).put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(material)).put((Object)Character.valueOf('R'), (Object)pump).build(), new String[]{"WcW", "CHC", "PRP"}));
            MachineRecipes.add(GT5RMachines.DISASSEMBLER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('R'), (Object)arm).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, tier, (Object)false)).build(), new String[]{"RCR", "LHL", "RCR"}));
            MachineRecipes.add(GT5RMachines.DISTILLERY, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('Z'), (Object)Items.f_42585_).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), cable).build(), new String[]{"GZG", "CHC", "LPL"}));
            MachineRecipes.add(GT5RMachines.ELECTRIC_OVEN, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('W'), (Object)TierMaps.WIRE_GETTER.apply(PipeSize.TINY, (Tier)tier), (Object)Character.valueOf('c'), (Object)cable, (Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('H'), (Object)hull), new String[]{"WCW", "WHW", "cCc"}));
            Wire<?> electroWire = tier == Tier.LV ? GT5RBlocks.WIRE_GOLD : (tier == Tier.MV ? GT5RBlocks.WIRE_SILVER : (tier == Tier.HV ? GT5RBlocks.WIRE_ELECTRUM : (tier == Tier.EV ? GT5RBlocks.WIRE_PLATINUM : GT5RBlocks.WIRE_OSMIUM)));
            MachineRecipes.add(GT5RMachines.ELECTROLYZER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('W'), (Object)electroWire.getBlockItem(PipeSize.VTINY), (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('H'), (Object)hull, (Object)Character.valueOf('G'), (Object)glass), new String[]{"WGW", "WHW", "CLC"}));
            PipeItemBlock esWire = tier == Tier.LV ? GT5RBlocks.WIRE_TIN.getBlockItem(PipeSize.TINY) : (tier == Tier.MV ? GT5RBlocks.WIRE_COPPER.getBlockItem(PipeSize.TINY) : (tier == Tier.HV ? GT5RBlocks.WIRE_COPPER.getBlockItem(PipeSize.SMALL) : GT5RBlocks.WIRE_ANNEALED_COPPER.getBlockItem(PipeSize.NORMAL)));
            MachineRecipes.add(GT5RMachines.ELECTROMAGNETIC_SEPARATOR, tier, (arg_0, arg_1) -> MachineRecipes.lambda$addBasicMachineRecipes$18(provider, output, conveyor, cable, (Item)esWire, hull, material, circuit, arg_0, arg_1));
            MachineRecipes.add(GT5RMachines.EXTRACTOR, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('M'), (Object)pump).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"GCG", "PHM", "LCL"}));
            MachineRecipes.add(GT5RMachines.EXTRUDER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('I'), TierMaps.PIPE_GETTER.apply(PipeSize.NORMAL, (Tier)tier)).put((Object)Character.valueOf('W'), TierMaps.WIRE_GETTER.apply(PipeSize.SMALL, (Tier)tier)).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"WWC", "PHI", "WWC"}));
            if (GT5RConfig.COMPLICATED_CHEMICAL_PROCESSING.get()) {
                MachineRecipes.add(GT5RMachines.FERMENTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), cable).build(), new String[]{"LPL", "GHG", "LCL"}));
            }
            MachineRecipes.add(GT5RMachines.FLUID_CANNER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), cable).build(), new String[]{"GCG", "PHP", "LCL"}));
            MachineRecipes.add(GT5RMachines.FLUID_HEATER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('W'), TierMaps.WIRE_GETTER.apply(PipeSize.SMALL, (Tier)tier)).put((Object)Character.valueOf('L'), cable).build(), new String[]{"WGW", "PHP", "LCL"}));
            MachineRecipes.add(GT5RMachines.FLUID_PRESS, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('T'), (Object)piston).put((Object)Character.valueOf('L'), cable).build(), new String[]{"GCG", "PHT", "LCL"}));
            MachineRecipes.add(GT5RMachines.FLUID_SOLIDIFIER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)pump).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('E'), (Object)Tags.Items.CHESTS_WOODEN).put((Object)Character.valueOf('L'), cable).build(), new String[]{"PGP", "LHL", "CEC"}));
            MachineRecipes.add(GT5RMachines.FORGE_HAMMER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('A'), (Object)Items.f_42146_).build(), new String[]{"LPL", "CHC", "LAL"}));
            MachineRecipes.add(GT5RMachines.FORMING_PRESS, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"LPL", "CHC", "LPL"}));
            MachineRecipes.add(GT5RMachines.FURNACE, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('H'), (Object)hull, (Object)Character.valueOf('W'), (Object)TierMaps.WIRE_GETTER.apply(PipeSize.TINY, (Tier)tier)), new String[]{"CWC", "WHW", "LWL"}));
            MachineRecipes.add(GT5RMachines.LATHE, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('D'), diamond).build(), new String[]{"LCL", "MHD", "CLP"}));
            MachineRecipes.add(GT5RMachines.LASER_ENGRAVER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('E'), (Object)emitter).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), cable).build(), new String[]{"PEP", "CHC", "LCL"}));
            TagKey<Item> grindHead = tier == Tier.LV || tier == Tier.MV ? GTMaterialTypes.GEM.getMaterialTag(Materials.Diamond) : GT5RTags.GRIND_HEADS;
            MachineRecipes.add(GT5RMachines.MACERATOR, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('D'), (Object)grindHead).build(), new String[]{"PMD", "LLH", "CCL"}));
            MachineRecipes.add(GT5RMachines.MASS_FABRICATOR, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('F'), (Object)field).put((Object)Character.valueOf('B'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, tier, (Object)true)).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"CFC", "BHB", "CFC"}));
            MachineRecipes.add(GT5RMachines.MIXER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('M'), (Object)motor, (Object)Character.valueOf('R'), (Object)rotor, (Object)Character.valueOf('G'), (Object)glass, (Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('H'), (Object)hull), new String[]{"GRG", "GMG", "CHC"}));
            MachineRecipes.add(GT5RMachines.ORE_WASHER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('G'), (Object)glass).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('R'), (Object)rotor).put((Object)Character.valueOf('L'), cable).build(), new String[]{"RGR", "CMC", "LHL"}));
            MachineRecipes.add(GT5RMachines.PACKAGER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('c'), (Object)conveyor).put((Object)Character.valueOf('R'), (Object)arm).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('S'), (Object)Tags.Items.CHESTS_WOODEN).build(), new String[]{"SCS", "RHc", "LCL"}));
            PipeItemBlock pipeItemBlock = tier == Tier.LV ? GT5RBlocks.WIRE_TIN.getBlockItem(PipeSize.TINY) : (tier == Tier.MV ? GT5RBlocks.WIRE_COPPER.getBlockItem(PipeSize.TINY) : (wire = tier == Tier.HV ? GT5RBlocks.WIRE_COPPER.getBlockItem(PipeSize.SMALL) : GT5RBlocks.WIRE_ANNEALED_COPPER.getBlockItem(PipeSize.NORMAL)));
            Material rodMaterial = tier == Tier.LV ? Materials.Iron : (tier == Tier.MV || tier == Tier.HV ? Materials.Steel : (tier == Tier.EV ? Materials.Neodymium : Materials.VanadiumGallium));
            MachineRecipes.add(GT5RMachines.POLARIZER, tier, (arg_0, arg_1) -> MachineRecipes.lambda$addBasicMachineRecipes$36(provider, output, rodMaterial, (Item)wire, hull, cable, arg_0, arg_1));
            MachineRecipes.add(GT5RMachines.PRINTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), cable).build(), new String[]{"MLM", "CHC", "LML"}));
            MachineRecipes.add(GT5RMachines.PUMP, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('R'), (Object)rotor).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('P'), TierMaps.PIPE_GETTER.apply(PipeSize.LARGE, (Tier)tier)).put((Object)Character.valueOf('C'), (Object)circuit).build(), new String[]{"MCM", "PHP", "RPR"}));
            MachineRecipes.add(GT5RMachines.RECYCLER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('G'), (Object)Items.f_42525_).put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), cable).build(), new String[]{"GCG", "PHP", "LCL"}));
            MachineRecipes.add(GT5RMachines.REPLICATOR, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('F'), (Object)field).put((Object)Character.valueOf('E'), (Object)emitter).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('B'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, tier, (Object)true)).build(), new String[]{"EFE", "CHC", "EBE"}));
            MachineRecipes.add(GT5RMachines.ROASTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('S'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, tier, (Object)true)).put((Object)Character.valueOf('V'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, tier, (Object)true)).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('W'), TierMaps.WIRE_GETTER.apply(PipeSize.TINY, (Tier)tier)).build(), new String[]{"SVS", "CHC", "WWW"}));
            MachineRecipes.add(GT5RMachines.ROCK_BREAKER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('G'), GT5RTags.GRIND_HEADS).put((Object)Character.valueOf('C'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('g'), (Object)glass).build(), new String[]{"PMG", "CHC", "ggg"}));
            MachineRecipes.add(GT5RMachines.SCANNER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('S'), (Object)sensor).put((Object)Character.valueOf('E'), (Object)emitter).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, tier, (Object)false)).build(), new String[]{"CEC", "LHL", "CSC"}));
            TagKey plate = GTMaterialTypes.PLATE.getMaterialTag(tier == Tier.LV ? Materials.Steel : Materials.VanadiumSteel);
            MachineRecipes.add(GT5RMachines.SEISMIC_PROSPECTOR, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('P'), (Object)plate, (Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('H'), (Object)hull, (Object)Character.valueOf('S'), (Object)sensor), new String[]{"PPP", "CHC", "SSS"}));
            MachineRecipes.add(GT5RMachines.SIFTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('P'), (Object)piston).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('F'), (Object)GT5RCovers.COVER_ITEM_FILTER.getItem()).build(), new String[]{"LFL", "PHP", "CFC"}));
            MachineRecipes.add(GT5RMachines.SMELTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('W'), TierMaps.WIRE_GETTER.apply(PipeSize.TINY, (Tier)tier)).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"WWW", "WHW", "WCW"}));
            MachineRecipes.add(GT5RMachines.THERMAL_CENTRIFUGE, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('W'), TierMaps.WIRE_GETTER.apply(tier == Tier.IV ? PipeSize.HUGE : PipeSize.SMALL, (Tier)tier)).put((Object)Character.valueOf('L'), cable).build(), new String[]{"CMC", "WHW", "LML"}));
            MachineRecipes.add(GT5RMachines.UNPACKAGER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('c'), (Object)conveyor).put((Object)Character.valueOf('R'), (Object)arm).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('S'), (Object)Tags.Items.CHESTS_WOODEN).build(), new String[]{"SCS", "cHR", "LCL"}));
            MachineRecipes.add(GT5RMachines.WIRE_MILL, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('M'), (Object)motor, (Object)Character.valueOf('C'), (Object)circuit, (Object)Character.valueOf('L'), (Object)cable, (Object)Character.valueOf('H'), (Object)hull), new String[]{"MLM", "CHC", "MLM"}));
            MachineRecipes.add(GT5RMachines.STEAM_TURBINE, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('R'), (Object)rotor).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('P'), TierMaps.PIPE_GETTER.apply(PipeSize.NORMAL, (Tier)tier)).build(), new String[]{"PCP", "RHR", "MLM"}));
            MachineRecipes.add(GT5RMachines.COMBUSTION_GENERATOR, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.GEAR.getMaterialTag(material)).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('P'), (Object)piston).build(), new String[]{"PCP", "MHM", "GLG"}));
            MachineRecipes.add(GT5RMachines.SEMIFLUID_GENERATOR, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('G'), (Object)Blocks.f_50450_).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Invar)).build(), new String[]{"PCP", "MHM", "GLG"}));
            MachineRecipes.add(GT5RMachines.GAS_TURBINE, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)motor).put((Object)Character.valueOf('L'), cable).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('R'), (Object)rotor).put((Object)Character.valueOf('C'), (Object)circuit).build(), new String[]{"CRC", "RHR", "MLM"}));
            Tier magicTier = Tier.getTier((long)(tier.getVoltage() * 4L * 4L));
            Material finalMagicMaterial = magicMaterial = tier == Tier.LV ? Materials.Platinum : (tier == Tier.MV ? Materials.Iridium : Materials.Neutronium);
            MachineRecipes.add(GT5RMachines.MAGIC_ENERGY_CONVERTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(magicTier)).put((Object)Character.valueOf('F'), (Object)field).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(finalMagicMaterial)).put((Object)Character.valueOf('B'), (Object)Items.f_42065_).build(), new String[]{"CFC", "PHP", "CBC"}));
            Material finalMagicMaterial1 = magicMaterial = tier == Tier.LV ? Materials.Platinum : (tier == Tier.MV ? Materials.Iridium : (tier == Tier.HV ? Materials.Europium : Materials.Neutronium));
            MachineRecipes.add(GT5RMachines.MAGIC_ENERGY_ABSORBER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(magicTier)).put((Object)Character.valueOf('F'), (Object)field).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(finalMagicMaterial1)).put((Object)Character.valueOf('B'), (Object)GT5RMachines.MAGIC_ENERGY_CONVERTER.getItem(tier == Tier.EV ? Tier.HV : tier)).build(), new String[]{"CFC", "PHP", "CBC"}));
        });
        MachineRecipes.add(GT5RMachines.BATH, Tier.NONE, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()).put((Object)Character.valueOf('H'), (Object)GT5RBlocks.CASING_HV).put((Object)Character.valueOf('C'), (Object)GTMaterialTypes.ITEM_CASING.getMaterialTag(Materials.StainlessSteel)).put((Object)Character.valueOf('S'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.StainlessSteel)).build(), new String[]{"CWC", "SHS", "SSS"}));
        provider.addItemRecipe(output, "trash_bin", (ItemLike)GTCoreBlocks.ENDER_GARBAGE_BIN.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('O'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Obsidian), (Object)Character.valueOf('I'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Iron), (Object)Character.valueOf('E'), (Object)Items.f_42545_), new String[]{"OOO", "OEO", "III"});
        provider.addItemRecipe(output, "solar_panels", (ItemLike)GT5RMachines.SOLAR_PANEL.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('S'), GT5RItems.Wafer, (Object)Character.valueOf('G'), (Object)Tags.Items.GLASS_PANES, (Object)Character.valueOf('C'), (Object)GTCoreTags.CIRCUITS_BASIC, (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Carbon), (Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.ULV), (Object)Character.valueOf('W'), (Object)GT5RBlocks.CABLE_SOLDERING_ALLOY.getBlockItem(PipeSize.VTINY)), new String[]{"SGS", "CPC", "WHW"});
        provider.addItemRecipe(output, "solar_panels", (ItemLike)GT5RMachines.SOLAR_PANEL.getItem(Tier.ULV), ImmutableMap.of((Object)Character.valueOf('W'), GT5RItems.Wafer, (Object)Character.valueOf('G'), (Object)Tags.Items.GLASS_PANES, (Object)Character.valueOf('C'), (Object)GTCoreTags.CIRCUITS_ADVANCED, (Object)Character.valueOf('g'), (Object)GT5RBlocks.WIRE_GRAPHENE.getBlock(PipeSize.SMALL), (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.GalliumArsenide), (Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.ULV)), new String[]{"WGW", "CgC", "PHP"});
        provider.addItemRecipe(output, "solar_panels", (ItemLike)GT5RMachines.SOLAR_PANEL.getItem(Tier.LV), ImmutableMap.of((Object)Character.valueOf('W'), GT5RItems.Wafer, (Object)Character.valueOf('G'), (Object)GTCoreBlocks.REINFORCED_GLASS, (Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.IV), (Object)Character.valueOf('g'), (Object)GT5RBlocks.WIRE_GRAPHENE.getBlock(PipeSize.HUGE), (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.IndiumGalliumPhosphide), (Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.LV)), new String[]{"WGW", "CgC", "PHP"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.NUCLEAR_REACTOR_CORE.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.IV), (Object)Character.valueOf('P'), GT5RItems.PistonEV, (Object)Character.valueOf('L'), (Object)((Object)GT5RBlocks.DENSE_LEAD_CASING)), new String[]{"PCP", "CLC", "PCP"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.INVAR_SMALL_HEAT_EXCHANGER.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('L'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Lead), (Object)Character.valueOf('H'), (Object)((Object)GT5RBlocks.HEAT_PROOF_CASING), (Object)Character.valueOf('P'), (Object)GT5RBlocks.FLUID_PIPE_COPPER.getBlock(PipeSize.SMALL), (Object)Character.valueOf('C'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Copper)), new String[]{"LCL", "PHP", "LCL"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.TUNGSTEN_SMALL_HEAT_EXCHANGER.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('L'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Lead), (Object)Character.valueOf('H'), (Object)((Object)GT5RBlocks.TUNGSTEN_CASING), (Object)Character.valueOf('P'), (Object)GT5RBlocks.FLUID_PIPE_COPPER.getBlock(PipeSize.NORMAL), (Object)Character.valueOf('C'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Copper)), new String[]{"LCL", "PHP", "LCL"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.TUNGSTENSTEEL_SMALL_HEAT_EXCHANGER.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('L'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Lead), (Object)Character.valueOf('H'), (Object)((Object)GT5RBlocks.TUNGSTENSTEEL_CASING), (Object)Character.valueOf('P'), (Object)GT5RBlocks.FLUID_PIPE_COPPER.getBlock(PipeSize.NORMAL), (Object)Character.valueOf('C'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Copper)), new String[]{"LCL", "PHP", "LCL"});
    }

    private static void addStorageTransformerRecipes(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        Arrays.stream(Tier.getAllElectric()).forEach(tier -> {
            Item hull = GT5RMachines.HULL.getItem(tier);
            if (hull == null) {
                return;
            }
            MachineRecipes.add(GT5RMachines.BATTERY_BUFFER_ONE, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)Tags.Items.CHESTS_WOODEN).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), (Object)((PipeItemBlock)TierMaps.TIER_WIRES.get(tier)).getPipe().getType().getBlockItem(PipeSize.VTINY)).build(), new String[]{"LCL", "LHL"}));
            MachineRecipes.add(GT5RMachines.BATTERY_BUFFER_FOUR, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)Tags.Items.CHESTS_WOODEN).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), (Object)((PipeItemBlock)TierMaps.TIER_WIRES.get(tier)).getPipe().getType().getBlockItem(PipeSize.SMALL)).build(), new String[]{"LCL", "LHL"}));
            MachineRecipes.add(GT5RMachines.BATTERY_BUFFER_EIGHT, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)Tags.Items.CHESTS_WOODEN).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), (Object)((PipeItemBlock)TierMaps.TIER_WIRES.get(tier)).getPipe().getType().getBlockItem(PipeSize.NORMAL)).build(), new String[]{"LCL", "LHL"}));
            MachineRecipes.add(GT5RMachines.BATTERY_BUFFER_SIXTEEN, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)Tags.Items.CHESTS_WOODEN).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), (Object)((PipeItemBlock)TierMaps.TIER_WIRES.get(tier)).getPipe().getType().getBlockItem(PipeSize.HUGE)).build(), new String[]{"LCL", "LHL"}));
            MachineRecipes.add(GT5RMachines.FLUX_TRANSFORMER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(tier)).put((Object)Character.valueOf('C'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, tier, (Object)false)).put((Object)Character.valueOf('R'), (Object)GTMaterialTypes.DUST.getMaterialTag(Materials.Redstone)).build(), new String[]{" RR", "CH ", " RR"}));
        });
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.TRANSFORMER.getItem(Tier.ULV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.ULV)).put((Object)Character.valueOf('C'), (Object)GT5RBlocks.CABLE_SOLDERING_ALLOY.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('W'), (Object)GT5RBlocks.CABLE_TIN.getBlockItem(PipeSize.VTINY)).build(), new String[]{" CC", "WH ", " CC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.TRANSFORMER.getItem(Tier.LV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.LV)).put((Object)Character.valueOf('C'), (Object)GT5RBlocks.CABLE_TIN.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('W'), (Object)GT5RBlocks.CABLE_COPPER.getBlockItem(PipeSize.VTINY)).build(), new String[]{" CC", "WH ", " CC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.TRANSFORMER.getItem(Tier.MV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.MV)).put((Object)Character.valueOf('C'), (Object)GT5RBlocks.CABLE_COPPER.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('W'), (Object)GT5RBlocks.CABLE_GOLD.getBlockItem(PipeSize.VTINY)).build(), new String[]{" CC", "WH ", " CC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.TRANSFORMER.getItem(Tier.HV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.HV)).put((Object)Character.valueOf('C'), (Object)GT5RBlocks.CABLE_GOLD.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('W'), (Object)GT5RBlocks.CABLE_ALUMINIUM.getBlockItem(PipeSize.VTINY)).build(), new String[]{" CC", "WH ", " CC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.TRANSFORMER.getItem(Tier.EV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.EV)).put((Object)Character.valueOf('C'), (Object)GT5RBlocks.CABLE_ALUMINIUM.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('W'), (Object)GT5RBlocks.CABLE_TUNGSTEN.getBlockItem(PipeSize.VTINY)).build(), new String[]{" CC", "WH ", " CC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.TRANSFORMER.getItem(Tier.IV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.IV)).put((Object)Character.valueOf('C'), (Object)GT5RBlocks.CABLE_TUNGSTEN.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('W'), (Object)GT5RBlocks.CABLE_VANADIUM_GALLIUM.getBlockItem(PipeSize.VTINY)).build(), new String[]{" CC", "WH ", " CC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.TRANSFORMER.getItem(Tier.LUV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.LUV)).put((Object)Character.valueOf('C'), (Object)GT5RBlocks.CABLE_VANADIUM_GALLIUM.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('W'), (Object)GT5RBlocks.CABLE_NAQUADAH.getBlockItem(PipeSize.VTINY)).build(), new String[]{" CC", "WH ", " CC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.TRANSFORMER.getItem(Tier.ZPM), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.ZPM)).put((Object)Character.valueOf('C'), (Object)GT5RBlocks.CABLE_NAQUADAH.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('W'), (Object)GT5RBlocks.WIRE_NAQUADAH_ALLOY.getBlockItem(PipeSize.SMALL)).build(), new String[]{" CC", "WH ", " CC"});
    }

    private static void addUtilityBlockRecipes(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        Arrays.stream(Tier.getAllElectric()).forEach(tier -> {
            Item hull = GT5RMachines.HULL.getItem(tier);
            if (hull == null) {
                return;
            }
            Item conveyor = (Item)GT5Reimagined.get(ItemCover.class, "conveyor_" + tier.getId());
            if (conveyor == null) {
                return;
            }
            MachineRecipes.add(GT5RMachines.SUPER_BUFFER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('D'), GT5RItems.DataOrb).put((Object)Character.valueOf('M'), (Object)hull).put((Object)Character.valueOf('C'), (Object)conveyor).build(), new String[]{"DMC"}));
            MachineRecipes.add(GT5RMachines.SUPER_BUFFER, tier, (m, item) -> provider.addItemRecipe(output, "gt5r", "super_buffer_" + tier.getId() + "_1", "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('D'), GT5RItems.DataStick).put((Object)Character.valueOf('M'), (Object)hull).put((Object)Character.valueOf('C'), (Object)conveyor).build(), new String[]{"DMC", "DDD"}));
            MachineRecipes.add(GT5RMachines.CHEST_BUFFER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('D'), (Object)Tags.Items.CHESTS_WOODEN).put((Object)Character.valueOf('M'), (Object)hull).put((Object)Character.valueOf('C'), (Object)conveyor).put((Object)Character.valueOf('c'), TierMaps.TIER_CIRCUITS.apply(Tier.LV)).build(), new String[]{"DMC", " c "}));
            MachineRecipes.add(GT5RMachines.ELECTRIC_TYPE_FILTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.MV)).put((Object)Character.valueOf('F'), (Object)GT5RCovers.COVER_ITEM_FILTER.getItem()).put((Object)Character.valueOf('E'), (Object)Tags.Items.CHESTS_WOODEN).put((Object)Character.valueOf('c'), (Object)conveyor).build(), new String[]{" F ", "EHc", " C "}));
            MachineRecipes.add(GT5RMachines.ELECTRIC_ITEM_FILTER, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.LV)).put((Object)Character.valueOf('F'), (Object)GT5RCovers.COVER_ITEM_FILTER.getItem()).put((Object)Character.valueOf('E'), (Object)Tags.Items.CHESTS_WOODEN).put((Object)Character.valueOf('c'), (Object)conveyor).build(), new String[]{" F ", "EHc", " C "}));
        });
        provider.addItemRecipe(output, "extenders", (ItemLike)GT5RMachines.INVENTORY_BRIDGE.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GT5RBlocks.ITEM_PIPE_ELECTRUM.getBlockItem(PipeSize.NORMAL), (Object)Character.valueOf('C'), (Object)((Object)GT5RBlocks.SOLID_STEEL_CASING), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"HP ", " C ", " PW"});
        provider.addItemRecipe(output, "extenders", (ItemLike)GT5RMachines.TANK_BRIDGE.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GT5RBlocks.FLUID_PIPE_STEEL.getBlockItem(PipeSize.NORMAL), (Object)Character.valueOf('C'), (Object)((Object)GT5RBlocks.SOLID_STEEL_CASING), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"H  ", "PCP", "  W"});
        provider.addItemRecipe(output, "extenders", (ItemLike)GT5RMachines.INVENTORY_TANK_BRIDGE.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GT5RBlocks.ITEM_PIPE_ELECTRUM.getBlockItem(PipeSize.NORMAL), (Object)Character.valueOf('F'), (Object)GT5RBlocks.FLUID_PIPE_STEEL.getBlockItem(PipeSize.NORMAL), (Object)Character.valueOf('C'), (Object)((Object)GT5RBlocks.SOLID_STEEL_CASING), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"HP ", "FCF", " PW"});
        provider.addItemRecipe(output, "extenders", (ItemLike)GT5RMachines.UNIVERSAL_BRIDGE.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GT5RBlocks.ITEM_PIPE_PLATINUM.getBlockItem(PipeSize.NORMAL), (Object)Character.valueOf('F'), (Object)GT5RBlocks.FLUID_PIPE_STAINLESS_STEEL.getBlockItem(PipeSize.NORMAL), (Object)Character.valueOf('C'), (Object)((Object)GT5RBlocks.STAINLESS_STEEL_CASING), (Object)Character.valueOf('c'), (Object)GTCoreTags.CIRCUITS_ADVANCED, (Object)Character.valueOf('G'), (Object)GTMaterialTypes.GEAR.getMaterialTag(Materials.StainlessSteel), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROTOR.getMaterialTag(Materials.StainlessSteel), (Object)Character.valueOf('S'), (Object)GTMaterialTypes.SPRING.getMaterialTag(Materials.StainlessSteel)), new String[]{"SPR", "FCF", "cPG"});
        provider.addItemRecipe(output, "extenders", (ItemLike)GT5RMachines.INVENTORY_EXTENDER.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GT5RBlocks.ITEM_PIPE_ELECTRUM.getBlockItem(PipeSize.NORMAL), (Object)Character.valueOf('C'), (Object)((Object)GT5RBlocks.SOLID_STEEL_CASING), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{" HP", " C ", "PW "});
        provider.addItemRecipe(output, "extenders", (ItemLike)GT5RMachines.TANK_EXTENDER.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GT5RBlocks.FLUID_PIPE_STEEL.getBlockItem(PipeSize.NORMAL), (Object)Character.valueOf('C'), (Object)((Object)GT5RBlocks.SOLID_STEEL_CASING), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"PH ", " C ", " WP"});
        provider.addItemRecipe(output, "extenders", (ItemLike)GT5RMachines.INVENTORY_TANK_EXTENDER.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GT5RBlocks.ITEM_PIPE_ELECTRUM.getBlockItem(PipeSize.NORMAL), (Object)Character.valueOf('F'), (Object)GT5RBlocks.FLUID_PIPE_STEEL.getBlockItem(PipeSize.NORMAL), (Object)Character.valueOf('C'), (Object)((Object)GT5RBlocks.SOLID_STEEL_CASING), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"FHP", " C ", "PWF"});
        provider.addItemRecipe(output, "extenders", (ItemLike)GT5RMachines.UNIVERSAL_EXTENDER.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GT5RBlocks.ITEM_PIPE_PLATINUM.getBlockItem(PipeSize.NORMAL), (Object)Character.valueOf('F'), (Object)GT5RBlocks.FLUID_PIPE_STAINLESS_STEEL.getBlockItem(PipeSize.NORMAL), (Object)Character.valueOf('C'), (Object)((Object)GT5RBlocks.STAINLESS_STEEL_CASING), (Object)Character.valueOf('c'), (Object)GTCoreTags.CIRCUITS_ADVANCED, (Object)Character.valueOf('G'), (Object)GTMaterialTypes.GEAR.getMaterialTag(Materials.StainlessSteel), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROTOR.getMaterialTag(Materials.StainlessSteel), (Object)Character.valueOf('S'), (Object)GTMaterialTypes.SPRING.getMaterialTag(Materials.StainlessSteel)), new String[]{"FRP", "cCG", "PSF"});
        provider.addItemRecipe(output, "mini_portals", (ItemLike)GT5RMachines.MINIATURE_NETHER_PORTAL.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('O'), (Object)GTMaterialTypes.LONG_ROD.get(Materials.Obsidian), (Object)Character.valueOf('S'), (Object)GTTools.SAW.getTag()), new String[]{"OOO", "OSO", "OOO"});
        provider.addItemRecipe(output, "mini_portals", (ItemLike)GT5RMachines.MINIATURE_END_PORTAL.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('R'), (Object)GTMaterialTypes.LONG_ROD.get(Materials.Endstone), (Object)Character.valueOf('G'), (Object)Items.f_42586_, (Object)Character.valueOf('E'), (Object)Items.f_42545_), new String[]{"ERE", "RGR", "ERE"});
        if (GTAPI.isModLoaded((String)"twilightforest")) {
            provider.addItemRecipe(output, "mini_portals", (ItemLike)GT5RMachines.MINIATURE_TWILIGHT_PORTAL.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('R'), (Object)Items.f_42276_, (Object)Character.valueOf('G'), (Object)Items.f_42447_, (Object)Character.valueOf('E'), (Object)ItemTags.f_13145_), new String[]{"ERE", "RGR", "ERE"});
        }
        if (GT5RMachines.MINIATURE_JAMD_PORTAL != null) {
            provider.addItemRecipe(output, "mini_portals", (ItemLike)GT5RMachines.MINIATURE_JAMD_PORTAL.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('R'), (Object)GTMaterialTypes.LONG_ROD.getMaterialTag(Materials.Obsidian), (Object)Character.valueOf('S'), (Object)GTTools.SAW.getTag(), (Object)Character.valueOf('B'), (Object)Items.f_42018_), new String[]{"BRB", "RSR", "BRB"});
        }
        TagKey circuit = GT5RConfig.HARDER_CIRCUITS ? GTCoreTags.CIRCUITS_ADVANCED : GT5RItems.EngravedCrystalChip;
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.QUANTUM_TANK.getItem(Tier.LV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.LV)).put((Object)Character.valueOf('C'), circuit).put((Object)Character.valueOf('F'), GT5RItems.FieldGenLV).put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.get(Materials.Steel)).build(), new String[]{"CFC", "PHP", "CPC"});
        circuit = GT5RConfig.HARDER_CIRCUITS ? GTCoreTags.CIRCUITS_COMPLEX : GTCoreTags.CIRCUITS_DATA;
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.QUANTUM_TANK.getItem(Tier.MV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.MV)).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('F'), GT5RItems.FieldGenMV).put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.get(Materials.Aluminium)).build(), new String[]{"CFC", "PHP", "CPC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.QUANTUM_TANK.getItem(Tier.HV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.HV)).put((Object)Character.valueOf('C'), (Object)GTCoreTags.CIRCUITS_ELITE).put((Object)Character.valueOf('F'), GT5RItems.FieldGenHV).put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.get(Materials.StainlessSteel)).build(), new String[]{"CFC", "PHP", "CPC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.QUANTUM_TANK.getItem(Tier.EV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.EV)).put((Object)Character.valueOf('C'), (Object)GTCoreTags.CIRCUITS_MASTER).put((Object)Character.valueOf('F'), GT5RItems.FieldGenEV).put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.get(Materials.Titanium)).build(), new String[]{"CFC", "PHP", "CPC"});
        circuit = GT5RConfig.HARDER_CIRCUITS ? GTCoreTags.CIRCUITS_DATA_ORB : GTCoreTags.CIRCUITS_DATA_ORB;
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.QUANTUM_TANK.getItem(Tier.IV), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.IV)).put((Object)Character.valueOf('C'), (Object)circuit).put((Object)Character.valueOf('F'), GT5RItems.FieldGenIV).put((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.get(Materials.TungstenSteel)).build(), new String[]{"CFC", "PHP", "CPC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.LONG_DISTANCE_TRANSFORMER_ENDPOINT.getItem(Tier.EV), ImmutableMap.of((Object)Character.valueOf('T'), (Object)GT5RMachines.TRANSFORMER.getItem(Tier.EV), (Object)Character.valueOf('C'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, (Object)Tier.MV, (Object)false), (Object)Character.valueOf('W'), (Object)GTTools.WIRE_CUTTER.getTag()), new String[]{"CTC", "TWT", "CTC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.LONG_DISTANCE_TRANSFORMER_ENDPOINT.getItem(Tier.IV), ImmutableMap.of((Object)Character.valueOf('T'), (Object)GT5RMachines.TRANSFORMER.getItem(Tier.IV), (Object)Character.valueOf('C'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, (Object)Tier.MV, (Object)false), (Object)Character.valueOf('W'), (Object)GTTools.WIRE_CUTTER.getTag()), new String[]{"CTC", "TWT", "CTC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.LONG_DISTANCE_TRANSFORMER_ENDPOINT.getItem(Tier.LUV), ImmutableMap.of((Object)Character.valueOf('T'), (Object)GT5RMachines.TRANSFORMER.getItem(Tier.LUV), (Object)Character.valueOf('C'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, (Object)Tier.MV, (Object)false), (Object)Character.valueOf('W'), (Object)GTTools.WIRE_CUTTER.getTag()), new String[]{"CTC", "TWT", "CTC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.LONG_DISTANCE_TRANSFORMER_ENDPOINT.getItem(Tier.ZPM), ImmutableMap.of((Object)Character.valueOf('T'), (Object)GT5RMachines.TRANSFORMER.getItem(Tier.ZPM), (Object)Character.valueOf('C'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, (Object)Tier.MV, (Object)false), (Object)Character.valueOf('W'), (Object)GTTools.WIRE_CUTTER.getTag()), new String[]{"CTC", "TWT", "CTC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.LONG_DISTANCE_TRANSFORMER_ENDPOINT.getItem(Tier.UV), ImmutableMap.of((Object)Character.valueOf('T'), (Object)GT5RMachines.TRANSFORMER.getItem(Tier.UV), (Object)Character.valueOf('C'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, (Object)Tier.MV, (Object)false), (Object)Character.valueOf('W'), (Object)GTTools.WIRE_CUTTER.getTag()), new String[]{"CTC", "TWT", "CTC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.LONG_DISTANCE_FLUID_ENDPOINT.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('T'), (Object)GT5RBlocks.FLUID_PIPE_TUNGSTEN.getBlock(PipeSize.NORMAL), (Object)Character.valueOf('C'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Plastic), (Object)Character.valueOf('W'), (Object)((Object)GT5RBlocks.TUNGSTEN_CASING)), new String[]{"CTC", "TWT", "CTC"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.LONG_DISTANCE_ITEM_ENDPOINT.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('T'), (Object)GT5RBlocks.ITEM_PIPE_PLATINUM.getBlock(PipeSize.NORMAL), (Object)Character.valueOf('C'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Plastic), (Object)Character.valueOf('W'), (Object)((Object)GT5RBlocks.PLATINUM_CASING)), new String[]{"CTC", "TWT", "CTC"});
        GTAPI.all(WorkbenchMachine.class).forEach(m -> {
            if (!m.getId().contains("charging")) {
                provider.addItemRecipe(output, "gt5r", m.getId(), "machines", (ItemLike)m.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m.getMaterial()), (Object)Character.valueOf('C'), (Object)Tags.Items.CHESTS_WOODEN, (Object)Character.valueOf('c'), (Object)Items.f_41960_, (Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag()), new String[]{"PSP", "PcP", "PCP"});
            } else {
                provider.addItemRecipe(output, "gt5r", m.getId(), "machines", (ItemLike)m.getItem(Tier.HV), ImmutableMap.of((Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('w'), (Object)GTTools.WIRE_CUTTER.getTag(), (Object)Character.valueOf('W'), (Object)Machine.get((String)m.getId().replace("charging_", ""), (String)"gtcore").map(mch -> mch.getItem(Tier.NONE)).orElse(Items.f_41852_), (Object)Character.valueOf('c'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.SMALL, (Object)Tier.HV, (Object)false), (Object)Character.valueOf('C'), (Object)GTCoreTags.CIRCUITS_ADVANCED, (Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROD.getMaterialTag(m.getMaterial())), new String[]{"RCR", "SWw", "ccc"});
            }
        });
        GTAPI.all(LockerMachine.class).forEach(m -> {
            Material material = m.getMaterial();
            ChestMachine chest = (ChestMachine)GTAPI.get(ChestMachine.class, (String)(material.getId() + "_chest"), (String)"gtcore");
            if (material.has(new IMaterialTag[]{GTMaterialTypes.SCREW}) && chest != null) {
                if (!m.getId().contains("charging")) {
                    provider.addItemRecipe(output, "gt5r", m.getId(), "machines", (ItemLike)m.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('s'), (Object)GTMaterialTypes.SCREW.getMaterialTag(m.getMaterial()), (Object)Character.valueOf('C'), (Object)chest.getItem(Tier.NONE), (Object)Character.valueOf('c'), (Object)((Object)GT5RBlocks.SOLID_STEEL_CASING), (Object)Character.valueOf('S'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROD.getMaterialTag(material), (Object)Character.valueOf('L'), (Object)Items.f_42454_), new String[]{"RSR", "LCL", "scs"});
                } else {
                    provider.addItemRecipe(output, "gt5r", m.getId(), "machines", (ItemLike)m.getItem(Tier.HV), ImmutableMap.of((Object)Character.valueOf('W'), (Object)Machine.get((String)m.getId().replace("charging_", ""), (String)"gtcore").map(mch -> mch.getItem(Tier.NONE)).orElse(Items.f_41852_), (Object)Character.valueOf('c'), (Object)TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.HV, (Object)false), (Object)Character.valueOf('C'), (Object)GTCoreTags.CIRCUITS_ADVANCED), new String[]{"cCc", "cWc", "cCc"});
                }
            }
        });
        GTAPI.all(ChestMachine.class).forEach(m -> {
            Material material = m.getMaterial();
            if (material.has(new IMaterialTag[]{GTMaterialTypes.RING}) && material.has(new IMaterialTag[]{GTMaterialTypes.PLATE})) {
                provider.addItemRecipe(output, "gt5r", m.getId(), "machines", (ItemLike)m.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(material), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROD.getMaterialTag(material), (Object)Character.valueOf('r'), (Object)GTMaterialTypes.RING.getMaterialTag(material), (Object)Character.valueOf('S'), (Object)GTTools.SAW.getTag(), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()), new String[]{"SPW", "rRr", "PPP"});
            }
        });
        GTAPI.all(BarrelMachine.class).forEach(m -> {
            Material material = m.getMaterial();
            if (material.has(new IMaterialTag[]{GTMaterialTypes.ROD}) && material.has(new IMaterialTag[]{GTMaterialTypes.PLATE})) {
                provider.addItemRecipe(output, "gt5r", m.getId(), "machines", (ItemLike)m.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(material), (Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROD.getMaterialTag(material), (Object)Character.valueOf('S'), (Object)GTTools.SAW.getTag(), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()), new String[]{"SPW", "PRP", " P "});
            }
        });
        GTAPI.all(MassStorageMachine.class).forEach(m -> {
            Material material = m.getMaterial();
            ChestMachine chest = (ChestMachine)GTAPI.get(ChestMachine.class, (String)(material.getId() + "_chest"), (String)"gtcore");
            if (material.has(new IMaterialTag[]{GTMaterialTypes.SCREW}) && material.has(new IMaterialTag[]{GTMaterialTypes.PLATE}) && !material.has(new IMaterialTag[]{MaterialTags.WOOD}) && chest != null) {
                provider.addItemRecipe(output, "gt5r", m.getId(), "machines", (ItemLike)m.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('C'), (Object)chest.getItem(Tier.NONE), (Object)Character.valueOf('S'), (Object)GTMaterialTypes.SCREW.getMaterialTag(material), (Object)Character.valueOf('c'), (Object)((Object)GT5RBlocks.SOLID_STEEL_CASING), (Object)Character.valueOf('s'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('W'), (Object)GTTools.WRENCH.getTag()), new String[]{"SCS", "Wcs", "SCS"});
            }
        });
        GTAPI.all(MultiblockTankMachine.class, (String)"gt5r").forEach(m -> {
            if (m.isSmall()) {
                Block block = (Block)GTAPI.get(Block.class, (String)(m.getMaterial().getId() + "_wall"), (String)"gt5r");
                if (block == null) {
                    return;
                }
                Material ringMaterial = m.getMaterial() == Materials.Wood ? Materials.Lead : m.getMaterial();
                TagKey hammer = m.getMaterial() == Materials.Wood ? GTTools.SOFT_HAMMER.getTag() : GTTools.HAMMER.getTag();
                provider.addItemRecipe(output, "gt5r", m.getId(), "multiblock_tanks", (ItemLike)m.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('R'), (Object)GTMaterialTypes.RING.getMaterialTag(ringMaterial), (Object)Character.valueOf('S'), (Object)GTTools.SAW.getTag(), (Object)Character.valueOf('H'), (Object)hammer, (Object)Character.valueOf('W'), (Object)block.m_5456_()), new String[]{" R ", "HWS", " R "});
            } else {
                Block block = (Block)GTAPI.get(Block.class, (String)m.getId().replace("large", "small"), (String)"gt5r");
                if (block == null) {
                    return;
                }
                provider.addItemRecipe(output, "gt5r", m.getId(), "multiblock_tanks", (ItemLike)m.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m.getMaterial()), (Object)Character.valueOf('S'), (Object)GTTools.SAW.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag(), (Object)Character.valueOf('W'), (Object)block.m_5456_()), new String[]{"PPP", "HWS", "PPP"});
            }
        });
        GTAPI.all(BookShelfMachine.class).forEach(m -> {
            if (m.getWoodBlockSupplier() == null) {
                provider.addItemRecipe(output, "bookshelves", (ItemLike)m.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(m.getMaterial()), (Object)Character.valueOf('S'), (Object)GTMaterialTypes.SCREW.getMaterialTag(m.getMaterial()), (Object)Character.valueOf('s'), (Object)GTTools.SAW.getTag(), (Object)Character.valueOf('D'), (Object)GTTools.SCREWDRIVER.getTag(), (Object)Character.valueOf('H'), (Object)GTTools.HAMMER.getTag()), new String[]{"PSP", "sDH", "PSP"});
            }
        });
        provider.addItemRecipe(output, "item_barrels", (ItemLike)GTCoreBlocks.WOOD_ITEM_BARREL.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('S'), (Object)GTTools.SOFT_HAMMER.getTag(), (Object)Character.valueOf('C'), (Object)Tags.Items.CHESTS_WOODEN, (Object)Character.valueOf('R'), (Object)GTMaterialTypes.LONG_ROD.getMaterialTag(Materials.Lead), (Object)Character.valueOf('W'), (Object)ItemTags.f_13168_, (Object)Character.valueOf('s'), (Object)GTTools.SAW.getTag()), new String[]{"SCs", "WRW", "WRW"});
        provider.addItemRecipe(output, "plastic_storage_box", (ItemLike)GTCoreBlocks.PLASTIC_STORAGE_BOX.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('S'), (Object)GTMaterialTypes.SCREW.getMaterialTag(Materials.Plastic), (Object)Character.valueOf('C'), (Object)Tags.Items.CHESTS_WOODEN, (Object)Character.valueOf('P'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Plastic)), new String[]{"SPS", "PCP", "SPS"});
        if (GTCoreBlocks.IRONWOOD_ITEM_BARREL != null) {
            provider.addItemRecipe(output, "item_barrels", (ItemLike)GTCoreBlocks.IRONWOOD_ITEM_BARREL.getItem(Tier.NONE), ImmutableMap.of((Object)Character.valueOf('S'), (Object)GTTools.SOFT_HAMMER.getTag(), (Object)Character.valueOf('C'), (Object)Tags.Items.CHESTS_WOODEN, (Object)Character.valueOf('R'), (Object)GTMaterialTypes.LONG_ROD.getMaterialTag(Materials.Iron), (Object)Character.valueOf('W'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Ironwood), (Object)Character.valueOf('s'), (Object)GTTools.SAW.getTag()), new String[]{"SCs", "WRW", "WRW"});
        }
    }

    private static void addHatchRecipes(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        Arrays.stream(Tier.getAllElectric()).forEach(tier -> {
            Item hull = GT5RMachines.HULL.getItem(tier);
            if (hull == null) {
                return;
            }
            MachineRecipes.add(GT5RMachines.INPUT_BUS, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)Tags.Items.CHESTS_WOODEN).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"C", "H"}));
            MachineRecipes.add(GT5RMachines.INPUT_HATCH, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('G'), (Object)Items.f_41904_).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"G", "H"}));
            MachineRecipes.add(GT5RMachines.HIGH_CAPACITY_INPUT_HATCH, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('I'), (Object)GT5RMachines.INPUT_HATCH.getItem(tier), (Object)Character.valueOf('P'), (Object)TierMaps.HATCH_PIPE_GETTER.apply(PipeSize.LARGE, (Tier)tier)), new String[]{" P ", "PIP", " P "}));
            MachineRecipes.add(GT5RMachines.SECONDARY_INPUT_HATCH, tier, (m, item) -> provider.shapeless(output, "", "machines", new ItemStack((ItemLike)item), new Object[]{GT5RMachines.INPUT_HATCH.getItem(tier)}));
            MachineRecipes.add(GT5RMachines.INPUT_HATCH, tier, (m, item) -> provider.shapeless(output, "gt5r", "input_hatch_" + tier.getId() + "_from_secondary", "machines", new ItemStack((ItemLike)item), new Object[]{GT5RMachines.SECONDARY_INPUT_HATCH.getItem(tier)}));
            MachineRecipes.add(GT5RMachines.OUTPUT_BUS, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)Tags.Items.CHESTS_WOODEN).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"H", "C"}));
            MachineRecipes.add(GT5RMachines.OUTPUT_HATCH, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('G'), (Object)Items.f_41904_).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"H", "G"}));
            MachineRecipes.add(GT5RMachines.HIGH_CAPACITY_OUTPUT_HATCH, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('I'), (Object)GT5RMachines.OUTPUT_HATCH.getItem(tier), (Object)Character.valueOf('P'), (Object)TierMaps.HATCH_PIPE_GETTER.apply(PipeSize.LARGE, (Tier)tier)), new String[]{" P ", "PIP", " P "}));
            MachineRecipes.add(GT5RMachines.SECONDARY_OUTPUT_HATCH, tier, (m, item) -> provider.shapeless(output, "", "machines", new ItemStack((ItemLike)item), new Object[]{GT5RMachines.OUTPUT_HATCH.getItem(tier)}));
            MachineRecipes.add(GT5RMachines.OUTPUT_HATCH, tier, (m, item) -> provider.shapeless(output, "gt5r", "output_hatch_" + tier.getId() + "_from_secondary", "machines", new ItemStack((ItemLike)item), new Object[]{GT5RMachines.SECONDARY_OUTPUT_HATCH.getItem(tier)}));
            MachineRecipes.add(GT5RMachines.ENERGY_HATCH, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, tier, (Object)false)).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"CH"}));
            MachineRecipes.add(GT5RMachines.DYNAMO_HATCH, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, tier, (Object)false)).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"HC"}));
            MachineRecipes.add(GT5RMachines.MUFFLER_HATCH, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), (Object)GT5RBlocks.FLUID_PIPE_STEEL.getBlockItem(PipeSize.NORMAL)).put((Object)Character.valueOf('H'), (Object)hull).build(), new String[]{"H", "C"}));
        });
    }

    private static void addMultiblockRecipes(Consumer<FinishedRecipe> output, GTRecipeProvider provider) {
        if (GT5RConfig.HARD_SETTINGS) {
            MachineRecipes.add(GT5RMachines.ASSEMBLY_LINE, Tier.IV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('A'), (Object)GT5RBlocks.ADVANCED_ASSEMBLER_CASING).put((Object)Character.valueOf('R'), (Object)GT5RCovers.COVER_ROBOT_ARM.getItem(Tier.IV)).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.IV)).put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.IV)).build(), new String[]{"ARA", "CHC", "ARA"}));
        }
        MachineRecipes.add(GT5RMachines.AUTOCRAFTER_ASSEMBLY_LINE, Tier.HV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('A'), (Object)GT5RBlocks.ASSEMBLER_CASING).put((Object)Character.valueOf('R'), (Object)GT5RCovers.COVER_ROBOT_ARM.getItem(Tier.HV)).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.HV)).put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.HV)).build(), new String[]{"ARA", "CHC", "ARA"}));
        MachineRecipes.add(GT5RMachines.BEDROCK_DRILL, Tier.EV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('c'), (Object)GTCoreTags.CIRCUITS_COMPLEX).put((Object)Character.valueOf('C'), (Object)GTCoreTags.CIRCUITS_ELITE).put((Object)Character.valueOf('I'), (Object)GT5RCovers.COVER_CONVEYOR.getItem(Tier.EV)).put((Object)Character.valueOf('H'), (Object)GT5RBlocks.TITANIUM_CASING).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.GEAR.getMaterialTag(Materials.Titanium)).put((Object)Character.valueOf('D'), (Object)GTMaterialTypes.DRILL_BIT.getMaterialTag(Materials.TungstenSteel)).build(), new String[]{"cIc", "CHC", "GDG"}));
        MachineRecipes.add(GT5RMachines.BLAST_FURNACE, Tier.LV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.LV, (Object)true)).put((Object)Character.valueOf('H'), (Object)GT5RBlocks.HEAT_PROOF_CASING).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.LV)).put((Object)Character.valueOf('F'), (Object)Items.f_41962_).build(), new String[]{"FFF", "CHC", "LCL"}));
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.COKE_OVEN.getItem(GT5RMachines.COKE_OVEN.getFirstTier()), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GTCoreItems.FireBrick).build(), new String[]{"HHH", "H H", "HHH"});
        MachineRecipes.add(GT5RMachines.COMBUSTION_ENGINE, Tier.EV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), (Object)GT5RBlocks.CABLE_TUNGSTEN_STEEL.getBlockItem(PipeSize.VTINY)).put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.EV)).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.EV)).put((Object)Character.valueOf('P'), GT5RItems.PistonEV).put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.GEAR.getMaterialTag(Materials.Titanium)).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorEV).build(), new String[]{"PCP", "MHM", "GLG"}));
        MachineRecipes.add(GT5RMachines.CRACKING_UNIT, Tier.HV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)GT5RCovers.COVER_PUMP.getItem(Tier.HV).m_41720_()).put((Object)Character.valueOf('O'), (Object)GT5RBlocks.CUPRONICKEL_COIL).put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.HV)).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.HV)).build(), new String[]{"OPO", "CHC", "OPO"}));
        MachineRecipes.add(GT5RMachines.DISTLLATION_TOWER, Tier.HV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)GT5RCovers.COVER_PUMP.getItem(Tier.HV).m_41720_()).put((Object)Character.valueOf('I'), (Object)GT5RBlocks.FLUID_PIPE_STAINLESS_STEEL.getBlock(PipeSize.LARGE)).put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.HV)).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.HV)).build(), new String[]{"CIC", "PHP", "CIC"}));
        MachineRecipes.add(GT5RMachines.CRYO_DISTLLATION_TOWER, Tier.HV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)GT5RCovers.COVER_PUMP.getItem(Tier.HV).m_41720_()).put((Object)Character.valueOf('I'), (Object)GT5RBlocks.FLUID_PIPE_COPPER.getBlock(PipeSize.LARGE)).put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.HV)).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.HV)).build(), new String[]{"CIC", "PHP", "CIC"}));
        MachineRecipes.add(GT5RMachines.LARGE_HEAT_EXCHANGER, Tier.NONE, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)GT5RCovers.COVER_PUMP.getItem(Tier.EV).m_41720_()).put((Object)Character.valueOf('I'), (Object)GT5RBlocks.FLUID_PIPE_TITANIUM.getBlock(PipeSize.NORMAL)).put((Object)Character.valueOf('H'), (Object)GT5RBlocks.TITANIUM_PIPE_CASING).build(), new String[]{"PIP", "IHI", "PIP"}));
        MachineRecipes.add(GT5RMachines.IMPLOSION_COMPRESSOR, Tier.HV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.HV, (Object)true)).put((Object)Character.valueOf('O'), (Object)Items.f_41999_).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.HV)).put((Object)Character.valueOf('S'), (Object)GT5RBlocks.SOLID_STEEL_CASING).build(), new String[]{"OOO", "CSC", "LCL"}));
        MachineRecipes.add(GT5RMachines.LARGE_AUTOCLAVE, Tier.HV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('W'), (Object)GT5RBlocks.STAINLESS_STEEL_CASING).put((Object)Character.valueOf('D'), (Object)GTMaterialTypes.DENSE_PLATE.getMaterialTag(Materials.StainlessSteel)).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.IV)).put((Object)Character.valueOf('c'), TierMaps.TIER_CIRCUITS.apply(Tier.EV)).build(), new String[]{"cCc", "DWD", "DDD"}));
        MachineRecipes.add(GT5RMachines.LARGE_BATHING_VAT, Tier.NONE, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('W'), (Object)GT5RBlocks.STAINLESS_STEEL_WALL).put((Object)Character.valueOf('D'), (Object)GTMaterialTypes.DENSE_PLATE.getMaterialTag(Materials.StainlessSteel)).put((Object)Character.valueOf('R'), (Object)GT5RCovers.COVER_ROBOT_ARM.getItem(Tier.MV)).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.IV)).put((Object)Character.valueOf('c'), TierMaps.TIER_CIRCUITS.apply(Tier.EV)).build(), new String[]{"cCc", "DWD", "RDR"}));
        MachineRecipes.add(GT5RMachines.LARGE_CENTRIFUGE, Tier.HV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorEV).put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.IV)).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.HV)).build(), new String[]{"CMC", "MHM", "CMC"}));
        MachineRecipes.add(GT5RMachines.LARGE_CHEMICAL_REACTOR, Tier.HV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.HV)).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorHV).put((Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROTOR.getMaterialTag(Materials.StainlessSteel)).put((Object)Character.valueOf('P'), (Object)GT5RBlocks.FLUID_PIPE_PVC.getBlockItem(PipeSize.LARGE)).put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.HV)).build(), new String[]{"CRC", "PMP", "CHC"}));
        MachineRecipes.add(GT5RMachines.LARGE_ELECTROLYZER, Tier.HV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), (Object)GT5RBlocks.WIRE_PLATINUM.getBlockItem(PipeSize.SMALL)).put((Object)Character.valueOf('O'), (Object)GT5RBlocks.NICHROME_COIL).put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.HV)).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.EV)).build(), new String[]{"OPO", "CHC", "OPO"}));
        MachineRecipes.add(GT5RMachines.LARGE_PULVERIZER, Tier.HV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('P'), GT5RItems.PistonIV).put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorIV).put((Object)Character.valueOf('T'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.TungstenCarbide)).put((Object)Character.valueOf('G'), GT5RTags.GRIND_HEADS).put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.IV)).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.IV)).build(), new String[]{"TGT", "PHP", "MCM"}));
        MachineRecipes.add(GT5RMachines.LARGE_ORE_WASHER, Tier.EV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('G'), (Object)GTMaterialTypes.GEAR.getMaterialTag(Materials.Titanium)).put((Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROD.getMaterialTag(Materials.Titanium)).put((Object)Character.valueOf('W'), (Object)GT5RBlocks.TITANIUM_WALL).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.IV)).put((Object)Character.valueOf('c'), TierMaps.TIER_CIRCUITS.apply(Tier.EV)).build(), new String[]{"GGG", "RWR", "cCc"}));
        MachineRecipes.add(GT5RMachines.LARGE_SIFTER, Tier.EV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.IV), (Object)Character.valueOf('M'), (Object)GTCoreItems.MotorHV, (Object)Character.valueOf('c'), (Object)GT5RCovers.COVER_CONVEYOR.getItem(Tier.HV), (Object)Character.valueOf('T'), (Object)((Object)GT5RBlocks.TITANIUM_CASING)), new String[]{"McM", "cTc", "MCM"}));
        Arrays.stream(Tier.getStandard()).forEach(tier -> {
            BlockCasing firebox;
            BlockCasing blockCasing = tier == Tier.LV ? GT5RBlocks.BRONZE_FIREBOX_CASING : (tier == Tier.MV ? GT5RBlocks.STEEL_FIREBOX_CASING : (firebox = tier == Tier.HV ? GT5RBlocks.TITANIUM_FIREBOX_CASING : GT5RBlocks.TUNGSTENSTEEL_FIREBOX_CASING));
            Tier circuitTier = tier == Tier.LV ? tier : (tier == Tier.MV ? Tier.HV : (tier == Tier.HV ? Tier.EV : Tier.IV));
            MachineRecipes.add(GT5RMachines.LARGE_BOILER, tier, (arg_0, arg_1) -> MachineRecipes.lambda$addMultiblockRecipes$111(provider, output, tier, (Block)firebox, circuitTier, arg_0, arg_1));
        });
        Arrays.stream(new Tier[]{Tier.HV, Tier.EV, Tier.IV}).forEach(tier -> {
            Material gear = tier == Tier.HV ? Materials.Steel : (tier == Tier.EV ? Materials.StainlessSteel : (tier == Tier.IV ? Materials.Titanium : Materials.TungstenSteel));
            Tier pipe = tier == Tier.UV ? Tier.IV : Tier.getTier((long)(tier.getVoltage() / 4L));
            MachineRecipes.add(GT5RMachines.LARGE_TURBINE, tier, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.of((Object)Character.valueOf('G'), (Object)GTMaterialTypes.GEAR.getMaterialTag(gear), (Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(tier), (Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply((Tier)tier), (Object)Character.valueOf('P'), (Object)TierMaps.PIPE_GETTER.apply(PipeSize.LARGE, pipe)), new String[]{"CGC", "GHG", "PGP"}));
        });
        MachineRecipes.add(GT5RMachines.MULTI_SMELTER, Tier.HV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.HV, (Object)false)).put((Object)Character.valueOf('F'), (Object)Items.f_41962_).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.HV)).put((Object)Character.valueOf('H'), (Object)GT5RBlocks.HEAT_PROOF_CASING).build(), new String[]{"FFF", "CHC", "LCL"}));
        MachineRecipes.add(GT5RMachines.OIL_DRILLING_RIG, Tier.MV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorMV).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.MV)).put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.MV)).put((Object)Character.valueOf('F'), (Object)GTMaterialTypes.FRAME.getMaterialTag(Materials.Steel)).build(), new String[]{"FFF", "CHC", "MMM"}));
        MachineRecipes.add(GT5RMachines.ORE_MINING_RIG, Tier.EV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('M'), (Object)GTCoreItems.MotorEV).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.EV)).put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.EV)).put((Object)Character.valueOf('F'), (Object)GTMaterialTypes.FRAME.getMaterialTag(Materials.Titanium)).build(), new String[]{"FFF", "CHC", "MMM"}));
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.PRIMITIVE_BLAST_FURNACE.getItem(GT5RMachines.PRIMITIVE_BLAST_FURNACE.getFirstTier()), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GTCoreItems.FireBrick).put((Object)Character.valueOf('C'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Iron)).build(), new String[]{"HHH", "HCH", "HHH"});
        MachineRecipes.add(GT5RMachines.PROCESSING_ARRAY, Tier.EV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.LUV)).put((Object)Character.valueOf('R'), (Object)GT5RCovers.COVER_ROBOT_ARM.getItem(Tier.EV)).put((Object)Character.valueOf('L'), GT5RItems.BatteryEnergyOrb).put((Object)Character.valueOf('M'), (Object)GT5RMachines.HULL.getItem(Tier.EV)).put((Object)Character.valueOf('S'), (Object)GT5RBlocks.FLUID_PIPE_STAINLESS_STEEL.getBlockItem(PipeSize.LARGE)).build(), new String[]{"CLC", "RMR", "CSC"}));
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.PYROLYSE_OVEN.getItem(GT5RMachines.PYROLYSE_OVEN.getFirstTier()), ImmutableMap.builder().put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.MV)).put((Object)Character.valueOf('C'), (Object)GTCoreTags.CIRCUITS_GOOD).put((Object)Character.valueOf('P'), (Object)GT5RCovers.COVER_PUMP.getItem(Tier.MV).m_41720_()).put((Object)Character.valueOf('W'), (Object)GT5RBlocks.WIRE_CUPRONICKEL.getBlockItem(PipeSize.SMALL)).put((Object)Character.valueOf('B'), GT5RItems.PistonMV).build(), new String[]{"BCW", "CHC", "BPW"});
        provider.addItemRecipe(output, "machines", (ItemLike)GT5RMachines.TREE_GROWTH_SIMULATOR.getItem(Tier.LV), ImmutableMap.builder().put((Object)Character.valueOf('E'), GT5RItems.EmitterLV).put((Object)Character.valueOf('S'), GT5RItems.SensorLV).put((Object)Character.valueOf('H'), (Object)GT5RBlocks.BLACK_BRONZE_CASING).put((Object)Character.valueOf('R'), (Object)GTCoreItems.DiamondSawBlade).put((Object)Character.valueOf('P'), (Object)GT5RBlocks.FLUID_PIPE_PLASTIC.getBlockItem(PipeSize.SMALL)).put((Object)Character.valueOf('N'), (Object)GTMaterialTypes.PLATE.getMaterialTag(Materials.Nickel)).build(), new String[]{"ERE", "NHN", "SPS"});
        MachineRecipes.add(GT5RMachines.VACUUM_FREEZER, Tier.HV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)Tier.HV, (Object)true)).put((Object)Character.valueOf('F'), (Object)GT5RBlocks.FROST_PROOF_CASING).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.HV)).put((Object)Character.valueOf('P'), (Object)GT5RCovers.COVER_PUMP.getItem(Tier.HV).m_41720_()).build(), new String[]{"PPP", "CFC", "LCL"}));
        MachineRecipes.add(GT5RMachines.FUSION_REACTOR, Tier.LUV, (m, item) -> provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(Tier.LUV)).put((Object)Character.valueOf('F'), GT5RItems.FieldGenIV).put((Object)Character.valueOf('H'), (Object)GT5RMachines.HULL.getItem(Tier.LUV)).build(), new String[]{"CFC", "FHF", "CFC"}));
    }

    private static <T extends Machine<T>> void add(T machine, Tier tier, BiConsumer<T, Item> callback) {
        Item item = machine.getItem(tier);
        if (item != null) {
            callback.accept(machine, item);
        }
    }

    private static /* synthetic */ void lambda$addMultiblockRecipes$111(GTRecipeProvider provider, Consumer output, Tier tier, Block firebox, Tier circuitTier, MultiMachine m, Item item) {
        provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('L'), TierMaps.CABLE_GETTER.apply((Object)PipeSize.VTINY, (Object)tier, (Object)true)).put((Object)Character.valueOf('H'), (Object)firebox).put((Object)Character.valueOf('C'), TierMaps.TIER_CIRCUITS.apply(circuitTier)).build(), new String[]{"LCL", "CHC", "LCL"});
    }

    private static /* synthetic */ void lambda$addBasicMachineRecipes$36(GTRecipeProvider provider, Consumer output, Material rodMaterial, Item wire, Item hull, Object cable, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROD.getMaterialTag(rodMaterial)).put((Object)Character.valueOf('W'), (Object)wire).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('L'), cable).build(), new String[]{"WRW", "LHL", "WRW"});
    }

    private static /* synthetic */ void lambda$addBasicMachineRecipes$18(GTRecipeProvider provider, Consumer output, Item conveyor, Object cable, Item esWire, Item hull, Material material, TagKey circuit, BasicMachine m, Item item) {
        provider.addItemRecipe(output, "machines", (ItemLike)item, ImmutableMap.builder().put((Object)Character.valueOf('c'), (Object)conveyor).put((Object)Character.valueOf('W'), cable).put((Object)Character.valueOf('w'), (Object)esWire).put((Object)Character.valueOf('H'), (Object)hull).put((Object)Character.valueOf('R'), (Object)GTMaterialTypes.ROD.getMaterialTag(material)).put((Object)Character.valueOf('C'), (Object)circuit).build(), new String[]{"cWw", "WHR", "CWw"});
    }
}

