/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityNuclearReactorCore;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.items.IItemReactorRod;
import org.gtreimagined.gtlib.Ref;
import org.gtreimagined.gtlib.item.ItemBasic;
import org.gtreimagined.gtlib.material.IMaterialObject;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.texture.Texture;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class ItemComponentRod
extends ItemBasic<ItemComponentRod>
implements IItemReactorRod,
IMaterialObject {
    private final Material material;
    private final int tooltips;

    public ItemComponentRod(String domain, String id, Material material, int tooltips) {
        super(domain, id, new Item.Properties().m_41487_(16).m_41491_(Ref.TAB_ITEMS));
        this.material = material;
        this.tooltips = tooltips;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        for (int i = 0; i < this.tooltips; ++i) {
            tooltipComponents.add((Component)Utils.translatable((String)("tooltip." + this.getDomain() + "." + this.getId().replace("/", ".") + "." + i), (Object[])new Object[0]).m_130940_(ChatFormatting.AQUA));
        }
    }

    public Texture[] getTextures() {
        if (this == GT5RItems.EmptyNuclearFuelRod) {
            return new Texture[]{new Texture("gt5r", "item/basic/empty_nuclear_fuel_rod")};
        }
        return new Texture[]{new Texture("gt5r", "item/basic/nuclear_fuel_rod"), new Texture("gt5r", "item/basic/empty_nuclear_fuel_rod")};
    }

    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        if (i == 0 && this.material != Material.NULL) {
            return this.material.getRGB();
        }
        return IItemReactorRod.super.getItemColor(stack, block, i);
    }

    @Override
    public boolean isReactorRod(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isModerated(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        return this == GT5RItems.NeutronModeratorRod;
    }

    @Override
    public void updateModeration(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
    }

    @Override
    public int getReactorRodNeutronEmission(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        return 0;
    }

    @Override
    public boolean getReactorRodNeutronReaction(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        if (this == GT5RItems.NeutronAbsorberRod) {
            reactor.heatHandler.ifPresent(h -> h.insertInternal(reactor.oNeutronCounts[slot] * 2, false));
            return true;
        }
        if (this == GT5RItems.NeutronModeratorRod && reactor.m_58904_().m_46467_() % 20L == 19L) {
            short moderation = stack.m_41783_() == null || !stack.m_41783_().m_128441_("moderation") ? (short)0 : stack.m_41783_().m_128448_("moderation");
            stack.m_41784_().m_128376_("oldModeration", moderation);
            stack.m_41784_().m_128376_("moderation", (short)0);
        }
        return false;
    }

    @Override
    public int getReactorRodNeutronReflection(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack, int neutrons, boolean moderated) {
        if (this == GT5RItems.NeutronAbsorberRod) {
            int n = slot;
            reactor.mNeutronCounts[n] = reactor.mNeutronCounts[n] + neutrons;
        }
        if (this == GT5RItems.NeutronModeratorRod) {
            int oldModeration;
            int n = oldModeration = stack.m_41783_() == null || !stack.m_41783_().m_128441_("oldModeration") ? 0 : (int)stack.m_41783_().m_128448_("oldModeration");
            if (neutrons > 0) {
                short moderation = stack.m_41783_() == null || !stack.m_41783_().m_128441_("moderation") ? (short)0 : (short)stack.m_41783_().m_128448_("moderation");
                moderation = (short)(moderation + 1);
                stack.m_41784_().m_128376_("moderation", moderation);
            }
            return oldModeration * neutrons;
        }
        if (this == GT5RItems.NeutronReflectorRod) {
            return neutrons;
        }
        return 0;
    }

    @Override
    public int getReactorRodNeutronMaximum(BlockEntityNuclearReactorCore reactor, int slot, ItemStack stack) {
        return 0;
    }

    public Material getMaterial() {
        return this.material;
    }
}

