/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityCoalBoiler;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.gui.GuiInstance;
import org.gtreimagined.gtlib.gui.ICanSyncData;
import org.gtreimagined.gtlib.gui.IGuiElement;
import org.gtreimagined.gtlib.gui.Widget;
import org.gtreimagined.gtlib.gui.container.ContainerMachine;
import org.gtreimagined.gtlib.gui.widget.WidgetSupplier;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.mixin.client.AbstractContainerScreenAccessor;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoalBoilerFuelWidget
extends Widget {
    private int fuel = 0;
    private int maxFuel = 0;

    protected CoalBoilerFuelWidget(@NotNull GuiInstance gui, @Nullable IGuiElement parent) {
        super(gui, parent);
    }

    public static WidgetSupplier build() {
        return CoalBoilerFuelWidget.builder(CoalBoilerFuelWidget::new);
    }

    public void init() {
        super.init();
        this.gui.syncInt(() -> ((BlockEntityCoalBoiler)((ContainerMachine)this.gui.container).getTile()).getFuel(), i -> {
            this.fuel = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
        this.gui.syncInt(() -> ((BlockEntityCoalBoiler)((ContainerMachine)this.gui.container).getTile()).getMaxFuel(), i -> {
            this.maxFuel = i;
        }, ICanSyncData.SyncDirection.SERVER_TO_CLIENT);
    }

    public void render(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        if (this.fuel > 0) {
            int lvl;
            float per = (float)this.fuel / (float)this.maxFuel;
            if (per > 1.0f) {
                per = 1.0f;
            }
            if ((lvl = (int)(per * 18.0f)) < 0) {
                return;
            }
            int y = this.realY() + 18 - lvl;
            this.drawTexture(stack, this.gui.handler.getGuiTexture(), this.realX(), y, ((AbstractContainerScreenAccessor)this.gui.screen).getImageWidth(), 18 - lvl, 18, lvl);
        }
    }

    public void mouseOver(PoseStack stack, double mouseX, double mouseY, float partialTicks) {
        super.mouseOver(stack, mouseX, mouseY, partialTicks);
        this.renderTooltip(stack, "Show Recipes", mouseX, mouseY, 0, 0, 18, 18);
        this.renderTooltip(stack, "Fuel: " + this.fuel, mouseX, mouseY + 10.0, 0, 10, 18, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderTooltip(PoseStack matrixStack, String text, double mouseX, double mouseY, int x, int y, int w, int h) {
        if (this.isInside(x, y, w, h, mouseX, mouseY)) {
            this.renderTooltip(matrixStack, (Component)Utils.literal((String)text), mouseX, mouseY);
        }
    }

    public boolean isInside(int x, int y, int w, int h, double mouseX, double mouseY) {
        int realX = this.realX() + x;
        int realY = this.realY() + y;
        return mouseX >= (double)realX && mouseX <= (double)(realX + w) && mouseY >= (double)realY && mouseY <= (double)(realY + h);
    }

    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        IGuiHandler iGuiHandler = this.gui.handler;
        if (iGuiHandler instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)iGuiHandler;
            GTLibXEIPlugin.showCategory((Machine)machine.getMachineType(), (Tier)machine.getMachineTier());
        }
    }
}

