/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.fluids.FluidStack;
import org.gtreimagined.gt5r.blockentity.single.BlockEntityCoalBoiler;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.gui.container.ContainerMachine;
import org.gtreimagined.gtlib.gui.screen.ScreenMachine;
import org.gtreimagined.gtlib.integration.xei.GTLibXEIPlugin;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;

public class ScreenCoalBoiler<T extends ContainerMachine<BlockEntityCoalBoiler>>
extends ScreenMachine<BlockEntityCoalBoiler, T> {
    public ScreenCoalBoiler(T container, Inventory inv, Component name) {
        super(container, inv, name);
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
        this.drawTitle(stack, mouseX, mouseY);
        if (((BlockEntityCoalBoiler)this.container.getTile()).has("recipe")) {
            this.drawTooltipInArea(stack, "Show Recipes", mouseX, mouseY, 115, 43, 18, 18);
        }
        if (((BlockEntityCoalBoiler)this.container.getTile()).has("fluid")) {
            ((BlockEntityCoalBoiler)this.container.getTile()).fluidHandler.ifPresent(t -> {
                FluidStack[] outputs;
                int steam;
                FluidStack[] inputs = t.getInputs();
                int water = inputs[0].getAmount();
                if (water >= 1) {
                    this.drawTooltipInArea(stack, "Water: " + water + " MB", mouseX, mouseY, 84, 25, 10, 54);
                }
                if ((steam = (outputs = t.getOutputs())[0].getAmount()) >= 1) {
                    this.drawTooltipInArea(stack, "Steam: " + steam + " MB", mouseX, mouseY, 70, 25, 10, 54);
                }
            });
            if (this.container.getTile() != null) {
                BlockEntityCoalBoiler tile = (BlockEntityCoalBoiler)this.container.getTile();
                this.drawTooltipInArea(stack, "Heat: " + tile.getHeat() + "K out of " + tile.getMaxHeat(), mouseX, mouseY, 96, 25, 10, 54);
                this.drawTooltipInArea(stack, "Fuel: " + tile.getFuel(), mouseX, mouseY + 10, 115, 53, 18, 18);
            }
        }
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(stack, partialTicks, mouseX, mouseY);
        this.drawTitle(stack, mouseX, mouseY);
        ResourceLocation gui = this.container.source().handler.getGuiTexture();
        if (((BlockEntityCoalBoiler)this.container.getTile()).has("fluid")) {
            ((BlockEntityCoalBoiler)this.container.getTile()).fluidHandler.ifPresent(t -> {
                FluidStack[] outputs;
                int steam;
                FluidStack[] inputs = t.getInputs();
                int water = inputs[0].getAmount();
                if (water >= 1) {
                    int lvl;
                    float per = (float)water / 16000.0f;
                    if (per > 1.0f) {
                        per = 1.0f;
                    }
                    if ((lvl = (int)(per * 54.0f)) < 0) {
                        return;
                    }
                    int y = this.f_97736_ + 25 + 54 - lvl;
                    this.drawTexture(stack, gui, this.f_97735_ + 83, y, this.f_97726_ + 28, 54 - lvl, 10, lvl);
                }
                if ((steam = (outputs = t.getOutputs())[0].getAmount()) >= 1) {
                    int lvl;
                    float per = (float)steam / 16000.0f;
                    if (per > 1.0f) {
                        per = 1.0f;
                    }
                    if ((lvl = (int)(per * 54.0f)) < 0) {
                        return;
                    }
                    int y = this.f_97736_ + 25 + 54 - lvl;
                    this.drawTexture(stack, gui, this.f_97735_ + 70, y, this.f_97726_ + 18, 54 - lvl, 10, lvl);
                }
            });
            if (this.container.getTile() instanceof BlockEntityCoalBoiler) {
                int fuel;
                BlockEntityCoalBoiler tile = (BlockEntityCoalBoiler)this.container.getTile();
                int heat = tile.getHeat();
                if (heat >= 1) {
                    int lvl;
                    float per = (float)heat / (float)tile.getMaxHeat();
                    if (per > 1.0f) {
                        per = 1.0f;
                    }
                    if ((lvl = (int)(per * 54.0f)) < 0) {
                        return;
                    }
                    int y = this.f_97736_ + 25 + 54 - lvl;
                    this.drawTexture(stack, gui, this.f_97735_ + 96, y, this.f_97726_ + 38, 54 - lvl, 10, lvl);
                }
                if ((fuel = tile.getFuel()) > 0) {
                    int lvl;
                    float per = (float)fuel / (float)tile.getMaxFuel();
                    if (per > 1.0f) {
                        per = 1.0f;
                    }
                    if ((lvl = (int)(per * 18.0f)) < 0) {
                        return;
                    }
                    int y = this.f_97736_ + 42 + 18 - lvl;
                    this.drawTexture(stack, gui, this.f_97735_ + 115, y, this.f_97726_, 18 - lvl, 18, lvl);
                }
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (!GTAPI.isModLoaded((String)"jei") && !GTAPI.isModLoaded((String)"roughlyenoughitems") || !((BlockEntityCoalBoiler)this.container.getTile()).has("recipe")) {
            return super.m_6375_(mouseX, mouseY, mouseButton);
        }
        if (this.isInGui(this.f_97726_ / 2 - 10, 24, 20, 18, mouseX, mouseY)) {
            return false;
        }
        if (this.isInGui(115, 43, 18, 18, mouseX, mouseY)) {
            GTLibXEIPlugin.showCategory((Machine)((BlockEntityCoalBoiler)this.container.getTile()).getMachineType(), (Tier)((BlockEntityCoalBoiler)this.container.getTile()).getMachineTier());
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }
}

