/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.data;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.gtreimagined.gt5r.data.GT5RItems;
import org.gtreimagined.gt5r.data.GT5RMaterialTypes;
import org.gtreimagined.gt5r.items.ItemPortableScanner;
import org.gtreimagined.gt5r.items.ItemTurbineRotor;
import org.gtreimagined.gtcore.data.GTCoreTags;
import org.gtreimagined.gtcore.data.GTCoreTools;
import org.gtreimagined.gtcore.item.ItemPowerUnit;
import org.gtreimagined.gtlib.GTAPI;
import org.gtreimagined.gtlib.behaviour.IBehaviour;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.item.ItemBattery;
import org.gtreimagined.gtlib.machine.BlockMachine;
import org.gtreimagined.gtlib.material.Material;
import org.gtreimagined.gtlib.pipe.BlockPipe;
import org.gtreimagined.gtlib.recipe.ingredient.PropertyIngredient;
import org.gtreimagined.gtlib.recipe.material.MaterialRecipe;
import org.gtreimagined.gtlib.registration.IGTObject;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.tool.IGTTool;
import org.gtreimagined.gtlib.tool.behaviour.BehaviourExtendedHighlight;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;
import org.gtreimagined.tesseract.api.forge.TesseractCaps;
import org.jetbrains.annotations.NotNull;

public class ToolTypes {
    public static final GTToolType SMALL_TURBINE_ROTOR = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gt5r", "small_turbine_rotor", 1, 1, 1, -1.0f, 0.0f, false))).setHasSecondary(false).setMaterialTypeItem(GT5RMaterialTypes.SMALL_BROKEN_TURBINE_ROTOR).setTag(new ResourceLocation("gtlib", "turbine_rotor")).setToolSupplier(ItemTurbineRotor::new);
    public static final GTToolType TURBINE_ROTOR = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gt5r", "turbine_rotor", 1, 1, 1, 1.5f, 0.0f, false))).setHasSecondary(false).setMaterialTypeItem(GT5RMaterialTypes.BROKEN_TURBINE_ROTOR).setDurabilityMultiplier(2.0f).setToolSupplier(ItemTurbineRotor::new);
    public static final GTToolType LARGE_TURBINE_ROTOR = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gt5r", "large_turbine_rotor", 1, 1, 1, 4.0f, 0.0f, false))).setHasSecondary(false).setMaterialTypeItem(GT5RMaterialTypes.LARGE_BROKEN_TURBINE_ROTOR).setTag(new ResourceLocation("gtlib", "turbine_rotor")).setDurabilityMultiplier(3.0f).setToolSupplier(ItemTurbineRotor::new);
    public static final GTToolType HUGE_TURBINE_ROTOR = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gt5r", "huge_turbine_rotor", 1, 1, 1, 2.0f, 0.0f, false))).setHasSecondary(false).setMaterialTypeItem(GT5RMaterialTypes.HUGE_BROKEN_TURBINE_ROTOR).setTag(new ResourceLocation("gtlib", "turbine_rotor")).setDurabilityMultiplier(4.0f).setToolSupplier(ItemTurbineRotor::new);
    public static final GTToolType PINCERS = ((GTToolType)GTAPI.register(GTToolType.class, (IGTObject)new GTToolType("gt5r", "pincers", 1, 2, 10, 5.0f, 0.0f, false))).setRepairable(false);
    public static final MaterialRecipe.Provider SCANNER_BUILDER = MaterialRecipe.registerProvider((String)"portable-scanner", (String)"gt5r", id -> new MaterialRecipe.ItemBuilder(){

        public ItemStack build(CraftingContainer inv, MaterialRecipe.Result mats) {
            Tuple battery = (Tuple)mats.mats.get("battery");
            ItemStack scanner = new ItemStack((ItemLike)GT5RItems.PortableScanner);
            scanner.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).ifPresent(i -> i.setEnergy(((Long)battery.m_14418_()).longValue()));
            return scanner;
        }

        public Map<String, Object> getFromResult(@NotNull ItemStack stack) {
            CompoundTag nbt = stack.m_41698_("ied");
            return ImmutableMap.of((Object)"energy", (Object)ToolTypes.getEnergy(stack).m_14418_(), (Object)"maxEnergy", (Object)ToolTypes.getEnergy(stack).m_14419_());
        }
    });
    public static final MaterialRecipe.Provider POWERED_TOOL_BUILDER = MaterialRecipe.registerProvider((String)"powered-tool", (String)"gt5r", id -> new MaterialRecipe.ItemBuilder(){

        public ItemStack build(CraftingContainer inv, MaterialRecipe.Result mats) {
            Material m = (Material)mats.mats.get("secondary");
            Tuple battery = (Tuple)mats.mats.get("battery");
            String domain = "gtlib";
            IGTTool type = (IGTTool)GTAPI.get(IGTTool.class, (String)id.replace('-', '_'), (String)"gtcore");
            return type.resolveStack((Material)mats.mats.get("primary"), m == null ? Material.NULL : m, ((Long)battery.m_14418_()).longValue(), ((Long)battery.m_14419_()).longValue());
        }

        public Map<String, Object> getFromResult(@NotNull ItemStack stack) {
            CompoundTag nbt = stack.m_41698_("td");
            Material primary = (Material)GTAPI.get(Material.class, (String)nbt.m_128461_("m"));
            Material secondary = (Material)GTAPI.get(Material.class, (String)nbt.m_128461_("sm"));
            return ImmutableMap.of((Object)"primary", (Object)primary, (Object)"secondary", (Object)secondary, (Object)"energy", (Object)ToolTypes.getEnergy(stack).m_14418_(), (Object)"maxEnergy", (Object)ToolTypes.getEnergy(stack).m_14419_());
        }
    });
    public static final MaterialRecipe.Provider UNIT_POWERED_TOOL_BUILDER = MaterialRecipe.registerProvider((String)"powered-tool-from-unit", (String)"gt5r", id -> new MaterialRecipe.ItemBuilder(){

        public ItemStack build(CraftingContainer inv, MaterialRecipe.Result mats) {
            Tuple t = (Tuple)mats.mats.get("secondary");
            IGTTool type = (IGTTool)GTAPI.get(IGTTool.class, (String)id.replace('-', '_'), (String)"gtcore");
            ((Tuple)t.m_14419_()).m_14419_();
            return type.resolveStack((Material)mats.mats.get("primary"), (Material)((Tuple)t.m_14419_()).m_14419_(), ((Long)t.m_14418_()).longValue(), ((Long)((Tuple)t.m_14419_()).m_14418_()).longValue());
        }

        public Map<String, Object> getFromResult(@NotNull ItemStack stack) {
            return ImmutableMap.of();
        }
    });

    public static void init() {
        if (FMLEnvironment.dist.isClient()) {
            GTCoreTools.ELECTRIC_WRENCH_ALT.addBehaviour(new IBehaviour[]{new BehaviourExtendedHighlight(b -> b instanceof BlockMachine || b instanceof BlockPipe && b.m_204297_().m_203656_(GTTools.WRENCH.getToolType()) || b.m_49966_().m_61138_((Property)BlockStateProperties.f_61373_) || b.m_49966_().m_61138_((Property)BlockStateProperties.f_61374_), BehaviourExtendedHighlight.PIPE_FUNCTION)});
        }
    }

    public static Tuple<Long, Long> getEnergy(ItemStack stack) {
        IGTTool tool;
        Item item = stack.m_41720_();
        if (item instanceof ItemBattery) {
            ItemBattery battery = (ItemBattery)item;
            long energy = stack.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).map(IEnergyHandler::getEnergy).orElse(0L);
            long maxEnergy = stack.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).map(IEnergyHandler::getCapacity).orElse(battery.getCapacity());
            return new Tuple((Object)energy, (Object)maxEnergy);
        }
        if (stack.m_41720_() instanceof ItemPortableScanner) {
            long energy = stack.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).map(IEnergyHandler::getEnergy).orElse(0L);
            long maxEnergy = stack.getCapability(TesseractCaps.ENERGY_HANDLER_CAPABILITY_ITEM).map(IEnergyHandler::getCapacity).orElse(400000L);
            return new Tuple((Object)energy, (Object)maxEnergy);
        }
        Item energy = stack.m_41720_();
        if (energy instanceof IGTTool && (tool = (IGTTool)energy).getGTToolType().isPowered()) {
            long currentEnergy = tool.getCurrentEnergy(stack);
            long maxEnergy = tool.getMaxEnergy(stack);
            return new Tuple((Object)currentEnergy, (Object)maxEnergy);
        }
        return null;
    }

    public static Tuple<Long, Tuple<Long, Material>> getEnergyAndMat(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ItemPowerUnit) {
            ItemPowerUnit tool = (ItemPowerUnit)item;
            long currentEnergy = tool.getCurrentEnergy(stack);
            long maxEnergy = tool.getMaxEnergy(stack);
            return new Tuple((Object)currentEnergy, (Object)new Tuple((Object)maxEnergy, (Object)tool.getMaterial(stack)));
        }
        return null;
    }

    static {
        PropertyIngredient.addGetter((ResourceLocation)GTCoreTags.BATTERIES_LV.f_203868_(), ToolTypes::getEnergy);
        PropertyIngredient.addGetter((ResourceLocation)GTCoreTags.BATTERIES_MV.f_203868_(), ToolTypes::getEnergy);
        PropertyIngredient.addGetter((ResourceLocation)GTCoreTags.BATTERIES_HV.f_203868_(), ToolTypes::getEnergy);
        PropertyIngredient.addGetter((ResourceLocation)GT5RItems.BatteryMediumLithium.getLoc(), ToolTypes::getEnergy);
        PropertyIngredient.addGetter((ResourceLocation)GTCoreTags.POWER_UNIT_LV.f_203868_(), ToolTypes::getEnergyAndMat);
        PropertyIngredient.addGetter((ResourceLocation)GTCoreTags.POWER_UNIT_MV.f_203868_(), ToolTypes::getEnergyAndMat);
        PropertyIngredient.addGetter((ResourceLocation)GTCoreTags.POWER_UNIT_HV.f_203868_(), ToolTypes::getEnergyAndMat);
        PropertyIngredient.addGetter((ResourceLocation)GTCoreTags.POWER_UNIT_SMALL.f_203868_(), ToolTypes::getEnergyAndMat);
        PropertyIngredient.addGetter((ResourceLocation)GTCoreTags.POWER_UNIT_JACKHAMMER.f_203868_(), ToolTypes::getEnergyAndMat);
    }
}

