/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover.redstone;

import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gt5r.blockentity.multi.BlockEntityLargeTurbine;
import org.gtreimagined.gt5r.cover.base.CoverBasicRedstoneOutput;
import org.gtreimagined.gt5r.items.ItemTurbineRotor;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverNeedsMaintenance
extends CoverBasicRedstoneOutput {
    ScaledMode mode = ScaledMode.SCALED;

    public CoverNeedsMaintenance(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverNeedsMaintenance.getBasicModel();
    }

    public void onUpdate() {
        BlockEntity blockEntity = this.handler.getTile();
        if (blockEntity instanceof BlockEntityLargeTurbine) {
            BlockEntityLargeTurbine turbine = (BlockEntityLargeTurbine)blockEntity;
            turbine.itemHandler.ifPresent(i -> {
                ItemStack rotor = i.getHandler(SlotType.STORAGE).getStackInSlot(0);
                Item patt1679$temp = rotor.m_41720_();
                if (patt1679$temp instanceof ItemTurbineRotor) {
                    ItemTurbineRotor rotor1 = (ItemTurbineRotor)patt1679$temp;
                    if (!this.mode.scaled) {
                        this.setOutputRedstone(this.mode.inverted ? 15 : 0);
                    } else {
                        long scale = (long)rotor.m_41776_() / 15L;
                        long damage = rotor.m_41776_() - rotor.m_41773_();
                        if (scale > 0L) {
                            this.setOutputRedstone(this.mode.inverted ? (int)(damage / scale) : (int)(15L - damage / scale));
                        } else {
                            this.setOutputRedstone(this.mode.inverted ? 15 : 0);
                        }
                    }
                } else {
                    this.setOutputRedstone(this.mode.inverted ? 0 : 15);
                }
            });
        }
    }

    @Override
    public InteractionResult onInteract(Player player, InteractionHand hand, Direction side, @Nullable GTToolType type) {
        if (type != null && type.getTag() == GTTools.SCREWDRIVER.getTag()) {
            this.mode = player.m_6144_() ? this.mode.previous() : this.mode.next();
            this.handler.getTile().m_6596_();
            player.m_6352_((Component)Utils.translatable((String)("message.gt5r.needs_maintenance." + (this.mode.scaled ? "scaled" : "unscaled") + "." + (this.mode.inverted ? "inverted" : "normal")), (Object[])new Object[0]), player.m_142081_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static enum ScaledMode {
        SCALED(false, true),
        SCALED_INVERTED(true, true),
        UNSCALED(false, false),
        UNSCALED_INVERTED(true, false);

        final boolean inverted;
        final boolean scaled;

        private ScaledMode(boolean inverted, boolean scaled) {
            this.inverted = inverted;
            this.scaled = scaled;
        }

        public ScaledMode next() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case SCALED -> SCALED_INVERTED;
                case SCALED_INVERTED -> UNSCALED;
                case UNSCALED -> UNSCALED_INVERTED;
                case UNSCALED_INVERTED -> SCALED;
            };
        }

        public ScaledMode previous() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case UNSCALED_INVERTED -> UNSCALED;
                case UNSCALED -> SCALED_INVERTED;
                case SCALED_INVERTED -> SCALED;
                case SCALED -> UNSCALED_INVERTED;
            };
        }
    }
}

