/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover.base;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gt5r.cover.ICoverRedstoneSensitive;
import org.gtreimagined.gt5r.cover.ImportExportMode;
import org.gtreimagined.gt5r.cover.RedstoneMode;
import org.gtreimagined.gt5r.cover.base.CoverBasicRedstone;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.machine.Tier;
import org.jetbrains.annotations.Nullable;

public abstract class CoverBasicTransport
extends CoverBasicRedstone
implements ICoverRedstoneSensitive {
    protected ImportExportMode exportMode;
    int coverModeInt;

    public CoverBasicTransport(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
        this.exportMode = source.getTile() instanceof BlockEntityPipe ? ImportExportMode.IMPORT : ImportExportMode.EXPORT;
        this.redstoneMode = RedstoneMode.NO_WORK;
        this.coverModeInt = this.exportMode.ordinal();
        this.addButtons();
    }

    protected void addButtons() {
        this.addGuiCallback(t -> {
            t.addCycleButton(70, 34, 16, 16, h -> ((CoverBasicRedstone)h).redstoneMode.ordinal(), true, i -> "tooltip.gt5r.redstone_mode." + i, new ButtonOverlay[]{ButtonOverlay.TORCH_OFF, ButtonOverlay.TORCH_ON, ButtonOverlay.REDSTONE});
            t.addCycleButton(88, 34, 16, 16, h -> ((CoverBasicTransport)h).exportMode.ordinal(), true, i -> "tooltip.gt5r.export_mode." + i, new ButtonOverlay[]{ButtonOverlay.EXPORT, ButtonOverlay.IMPORT, ButtonOverlay.EXPORT_IMPORT, ButtonOverlay.IMPORT_EXPORT});
        });
    }

    public String getDomain() {
        return "gt5r";
    }

    public void onPlace() {
        super.onPlace();
        if (this.handler.getTile().m_58904_() == null) {
            return;
        }
        BlockEntity blockEntity = this.handler.getTile();
        if (blockEntity instanceof BlockEntityPipe) {
            BlockEntityPipe pipe = (BlockEntityPipe)blockEntity;
            pipe.setConnection(this.side);
        }
    }

    public <T> boolean blocksInput(Class<T> cap, @Nullable Direction side) {
        return this.exportMode == ImportExportMode.EXPORT;
    }

    public <T> boolean blocksOutput(Class<T> cap, @Nullable Direction side) {
        return this.exportMode == ImportExportMode.IMPORT;
    }

    @Override
    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        super.onGuiEvent(event, playerEntity);
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            GuiEvents.GuiEvent ev = (GuiEvents.GuiEvent)event;
            if (ev.data[1] == 1) {
                this.exportMode = ev.data[0] == 0 ? this.exportMode.next() : this.exportMode.previous();
                this.handler.getTile().m_6596_();
            }
        }
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128405_("coverMode", this.exportMode.ordinal());
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        if (nbt.m_128441_("coverMode")) {
            this.coverModeInt = nbt.m_128451_("coverMode");
            if (this.coverModeInt > 3) {
                this.coverModeInt = 2;
            }
            this.exportMode = ImportExportMode.values()[this.coverModeInt];
        }
    }
}

