/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover.base;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.BaseCover;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.data.GTTools;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.tool.GTToolType;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverBasicRedstoneOutput
extends BaseCover {
    protected boolean inverted = false;
    int outputRedstone = 0;

    public CoverBasicRedstoneOutput(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    protected void setOutputRedstone(int outputRedstone) {
        boolean update = this.outputRedstone != outputRedstone;
        this.outputRedstone = outputRedstone;
        if (update) {
            this.markAndNotifySource();
            BlockPos neighbor = this.source().getTile().m_58899_().m_142300_(this.side);
            BlockState neighborState = this.source().getTile().m_58904_().m_8055_(neighbor);
            this.source().getTile().m_58904_().m_46590_(neighbor, neighborState.m_60734_(), this.side.m_122424_());
        }
    }

    public InteractionResult onInteract(Player player, InteractionHand hand, Direction side, @Nullable GTToolType type) {
        if (type != null && type.getTag() == GTTools.SCREWDRIVER.getTag()) {
            this.inverted = !this.inverted;
            player.m_6352_((Component)Utils.translatable((String)("message.gt5r.redstone_mode." + (this.inverted ? "inverted" : "normal")), (Object[])new Object[0]), player.m_142081_());
            return InteractionResult.SUCCESS;
        }
        return super.onInteract(player, hand, side, type);
    }

    public int getWeakPower() {
        return this.outputRedstone;
    }

    public int getStrongPower() {
        return this.outputRedstone;
    }

    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128379_("inverted", this.inverted);
        return nbt;
    }

    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.inverted = nbt.m_128471_("inverted");
    }

    public List<String> getInfo(boolean simple) {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Inverted: " + this.inverted);
        return info;
    }
}

