/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import org.gtreimagined.gt5r.cover.CoverItemFilter;
import org.gtreimagined.gt5r.data.GT5RCovers;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityPipe;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.IFilterableHandler;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.cover.BaseCover;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverItemDetector
extends BaseCover
implements IFilterableHandler {
    boolean inverted = false;
    int outputRedstone = 0;
    private final CoverItemFilter filter;

    public CoverItemDetector(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
        this.filter = new CoverItemFilter(source, null, side, GT5RCovers.COVER_ITEM_FILTER);
        this.filter.onCreate();
        this.addGuiCallback(t -> t.addSwitchButton(70, 34, 16, 16, ButtonOverlay.TORCH_OFF, ButtonOverlay.TORCH_ON, h -> this.inverted, true, b -> "tooltip.gt5r.redstone_mode." + (b != false ? "inverted" : "normal")));
        this.gui.getSlots().add(SlotType.STORAGE, 88, 34);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canPlace() {
        BlockEntity blockEntity = this.handler.getTile();
        if (!(blockEntity instanceof BlockEntityMachine)) return false;
        BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
        if (!machine.itemHandler.side(this.side).isPresent()) return false;
        return true;
    }

    public String getId() {
        return "item_detector";
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverItemDetector.getBasicModel();
    }

    public boolean hasGui() {
        return true;
    }

    public void onUpdate() {
        if (this.handler.getTile().m_58904_() == null || this.handler.getTile().m_58904_().f_46443_) {
            return;
        }
        BlockEntity blockEntity = this.handler.getTile();
        if (blockEntity instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
            if (machine.itemHandler.side(this.side).isPresent()) {
                IItemHandler itemContainer = (IItemHandler)machine.itemHandler.side(this.side).resolve().get();
                int oldRedstone = this.outputRedstone;
                int all = 0;
                int full = 0;
                for (int i = 0; i < itemContainer.getSlots(); ++i) {
                    int slotLimit = itemContainer.getSlotLimit(i);
                    all += slotLimit;
                    ItemStack stack = itemContainer.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    if (slotLimit > 64) {
                        full += stack.m_41613_();
                        continue;
                    }
                    full += stack.m_41613_() * slotLimit / stack.m_41741_();
                }
                if ((all /= 14) > 0 && full > 0) {
                    this.outputRedstone = this.inverted ? 15 - (full / all + 1) : full / all + 1;
                } else {
                    int n = this.outputRedstone = this.inverted ? 15 : 0;
                }
                if (this.outputRedstone != oldRedstone) {
                    this.markAndNotifySource();
                }
            }
        }
    }

    public int getWeakPower() {
        return this.outputRedstone;
    }

    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128365_("filter", (Tag)this.filter.serialize());
        nbt.m_128379_("inverted", this.inverted);
        return nbt;
    }

    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            GuiEvents.GuiEvent ev = (GuiEvents.GuiEvent)event;
            if (ev.data[1] == 0) {
                this.inverted = !this.inverted;
                BlockEntity blockEntity = this.handler.getTile();
                if (blockEntity instanceof BlockEntityPipe) {
                    BlockEntityPipe pipe = (BlockEntityPipe)blockEntity;
                    pipe.onBlockUpdate(pipe.m_58899_().m_142300_(this.side));
                }
                if ((blockEntity = this.handler.getTile()) instanceof BlockEntityMachine) {
                    BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
                    machine.onBlockUpdate(machine.m_58899_().m_142300_(this.side));
                }
            }
        }
    }

    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        if (nbt.m_128441_("filter")) {
            this.filter.deserialize(nbt.m_128469_("filter"));
        }
        this.inverted = nbt.m_128471_("inverted");
    }

    public void onMachineEvent(IGuiHandler tile, IMachineEvent event, int ... data) {
        if (tile == this && event == SlotType.STORAGE) {
            ItemStack slotStack = this.getInventory(SlotType.STORAGE).getStackInSlot(data[0]);
            if (slotStack.m_41619_()) {
                this.filter.clearFilter();
            } else {
                this.filter.addInfoFromStack(slotStack);
            }
        }
        super.onMachineEvent(tile, event, data);
    }

    public void addInfoFromStack(ItemStack stack) {
        super.addInfoFromStack(stack);
        this.onMachineEvent((IGuiHandler)this, (IMachineEvent)SlotType.STORAGE, 0);
    }

    public boolean test(SlotType<?> slotType, int slot, ItemStack stack) {
        return stack.m_41720_() == GT5RCovers.COVER_ITEM_FILTER.getItem().m_41720_();
    }

    public List<String> getInfo(boolean simple) {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Inverted: " + this.inverted);
        return info;
    }
}

