/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gt5r.cover.CoverPump;
import org.gtreimagined.gt5r.cover.ImportExportMode;
import org.gtreimagined.gt5r.cover.RedstoneMode;
import org.gtreimagined.gt5r.cover.base.CoverBasicTransport;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityFluidPipe;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.gui.ButtonOverlay;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.gui.widget.SyncableTextWidget;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class CoverFluidRegulator
extends CoverBasicTransport {
    public static String ID = "pump";
    int fluidLimit;
    int usedFluidLimitIn = 0;
    int usedFluidLimitOut = 0;
    boolean transferring = false;

    public CoverFluidRegulator(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
        Objects.requireNonNull(tier);
        this.fluidLimit = CoverPump.speeds.get(tier);
        this.addGuiCallback(t -> {
            t.addButton(52, 53, ButtonOverlay.MINUS, true);
            t.addButton(106, 53, ButtonOverlay.PLUS, true);
            t.addWidget(SyncableTextWidget.build(i -> {
                CoverFluidRegulator itemRegulator = (CoverFluidRegulator)i;
                if (itemRegulator.fluidLimit == 0) {
                    return "N/A";
                }
                return String.valueOf(itemRegulator.fluidLimit);
            }, (int)0x404040, (boolean)true).setSize(61, 58, 36, 18));
        });
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverFluidRegulator.getBasicDepthModel();
    }

    public boolean onTransfer(Object object, boolean inputSide, boolean simulate) {
        if (this.transferring) {
            return false;
        }
        if (this.fluidLimit <= 0) {
            return false;
        }
        if (object instanceof FluidStack) {
            BlockEntity blockEntity;
            FluidStack stack = (FluidStack)object;
            if (this.exportMode.isExport() && !inputSide && (blockEntity = this.handler.getTile()) instanceof BlockEntityFluidPipe) {
                BlockEntity neighbor;
                BlockEntityFluidPipe fluidPipe = (BlockEntityFluidPipe)blockEntity;
                int unusedFluidLimit = this.fluidLimit - this.usedFluidLimitOut;
                if (unusedFluidLimit <= 0) {
                    return true;
                }
                if (!simulate && (neighbor = fluidPipe.getCachedBlockEntity(this.side)) != null) {
                    LazyOptional cap = neighbor.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.side.m_122424_());
                    this.transferring = true;
                    boolean transfer = this.transferFluid(stack, (IFluidHandler)cap.orElse(null), this.usedFluidLimitOut, false, i -> this.usedFluidLimitOut += i.intValue());
                    this.transferring = false;
                    return transfer;
                }
            }
            if (!this.exportMode.isExport() && inputSide) {
                BlockEntityFluidPipe fluidPipe;
                IFluidHandler handler1 = null;
                BlockEntity blockEntity2 = this.handler.getTile();
                if (blockEntity2 instanceof BlockEntityMachine) {
                    BlockEntityMachine machine = (BlockEntityMachine)blockEntity2;
                    if (machine.fluidHandler.isPresent()) {
                        handler1 = (IFluidHandler)machine.fluidHandler.side(this.side).orElse(null);
                    }
                }
                if ((blockEntity2 = this.handler.getTile()) instanceof BlockEntityFluidPipe && (fluidPipe = (BlockEntityFluidPipe)blockEntity2).getFluidHandler().isPresent()) {
                    handler1 = (IFluidHandler)fluidPipe.getFluidHandler().get();
                }
                if (stack.isEmpty()) {
                    return true;
                }
                this.transferring = true;
                boolean transfer = this.transferFluid(stack, handler1, this.usedFluidLimitIn, simulate, i -> this.usedFluidLimitIn += i.intValue());
                this.transferring = false;
                return transfer;
            }
        }
        return super.onTransfer(object, inputSide, simulate);
    }

    private boolean transferFluid(FluidStack stack, IFluidHandler destination, int usedFluidLimit, boolean simulate, Consumer<Integer> usedFluidLimitSetter) {
        int unusedFluidLimit = this.fluidLimit - usedFluidLimit;
        if (unusedFluidLimit <= 0) {
            return true;
        }
        FluidStack toInsert = Utils.ca((int)unusedFluidLimit, (FluidStack)stack);
        if (destination == null) {
            return true;
        }
        int inserted = destination.fill(toInsert, IFluidHandler.FluidAction.SIMULATE);
        if (inserted > 0) {
            if (!simulate) {
                destination.fill(toInsert, IFluidHandler.FluidAction.EXECUTE);
                usedFluidLimitSetter.accept(inserted);
            }
            stack.setAmount(stack.getAmount() - inserted);
        }
        return true;
    }

    public <T> boolean blocksCapability(Class<T> cap, Direction side) {
        return cap != IFluidHandler.class;
    }

    public void onUpdate() {
        if (this.handler.getTile().m_58904_().f_46443_) {
            return;
        }
        if (this.handler.getTile() == null) {
            return;
        }
        BlockPos from = this.handler.getTile().m_58899_();
        BlockPos to = this.handler.getTile().m_58899_().m_142300_(this.side);
        Direction fromSide = this.side;
        if (this.exportMode == ImportExportMode.IMPORT || this.exportMode == ImportExportMode.IMPORT_EXPORT) {
            from = this.handler.getTile().m_58899_().m_142300_(this.side);
            to = this.handler.getTile().m_58899_();
            fromSide = this.side.m_122424_();
        }
        BlockPos finalTo = to;
        if (this.canMove(this.side)) {
            Direction finalFromSide = fromSide;
            FluidUtils.getFluidHandler((Level)this.handler.getTile().m_58904_(), (BlockPos)from, (Direction)fromSide).ifPresent(ih -> FluidUtils.getFluidHandler((Level)this.handler.getTile().m_58904_(), (BlockPos)finalTo, (Direction)finalFromSide.m_122424_()).ifPresent(other -> Utils.transferFluids((IFluidHandler)ih, (IFluidHandler)other, (int)(this.fluidLimit > 0 ? this.fluidLimit : CoverPump.speeds.get(this.tier)))));
        }
        this.usedFluidLimitIn = 0;
        this.usedFluidLimitOut = 0;
    }

    protected boolean canMove(Direction side) {
        if (this.redstoneMode != RedstoneMode.NO_WORK) {
            boolean powered = this.isPowered(side);
            return this.redstoneMode == RedstoneMode.INVERTED != powered;
        }
        return true;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.fluidLimit = nbt.m_128451_("fluidLimit");
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128405_("fluidLimit", this.fluidLimit);
        return nbt;
    }

    @Override
    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        super.onGuiEvent(event, playerEntity);
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            boolean shiftHold;
            GuiEvents.GuiEvent ev = (GuiEvents.GuiEvent)event;
            int button = ev.data[1];
            boolean bl = shiftHold = ev.data[0] != 0;
            if (button == 2 && this.fluidLimit > 0) {
                this.fluidLimit -= shiftHold ? 16 : 1;
                if (this.fluidLimit < 0) {
                    this.fluidLimit = 0;
                }
                this.handler.getTile().m_6596_();
            }
            if (button == 3 && this.fluidLimit < CoverPump.speeds.get(this.tier)) {
                this.fluidLimit += shiftHold ? 16 : 1;
                if (this.fluidLimit > CoverPump.speeds.get(this.tier)) {
                    this.fluidLimit = CoverPump.speeds.get(this.tier);
                }
                this.handler.getTile().m_6596_();
            }
        }
    }
}

