/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover;

import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.gtreimagined.gt5r.cover.base.CoverBasicRedstoneOutput;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.tesseract.api.eu.IEnergyHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverEnergyDetector
extends CoverBasicRedstoneOutput {
    public CoverEnergyDetector(@NotNull ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canPlace() {
        BlockEntity blockEntity = this.handler.getTile();
        if (!(blockEntity instanceof BlockEntityMachine)) return false;
        BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
        if (!machine.energyHandler.isPresent()) return false;
        return true;
    }

    public String getId() {
        return "energy_detector";
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverEnergyDetector.getBasicModel();
    }

    public void onUpdate() {
        if (this.handler.getTile().m_58904_() == null || this.handler.getTile().m_58904_().f_46443_) {
            return;
        }
        BlockEntity blockEntity = this.handler.getTile();
        if (blockEntity instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)blockEntity;
            if (machine.energyHandler.isPresent()) {
                IEnergyHandler energyHandler = (IEnergyHandler)machine.energyHandler.get();
                long scale = energyHandler.getCapacity() / 15L;
                if (scale > 0L) {
                    this.setOutputRedstone(this.inverted ? (int)(15L - energyHandler.getEnergy() / scale) : (int)(energyHandler.getEnergy() / scale));
                } else {
                    this.setOutputRedstone(this.inverted ? 15 : 0);
                }
            }
        }
    }
}

