/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.pipe.BlockEntityFluidPipe;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.cover.BaseCover;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class CoverDrain
extends BaseCover {
    public static String ID = "drain";
    FluidStack contained = FluidStack.EMPTY;
    boolean receivedBlockUpdate = false;

    public CoverDrain(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
    }

    public String getDomain() {
        return "gt5r";
    }

    public void onUpdate() {
        BlockEntity tile = this.handler.getTile();
        if (tile == null) {
            return;
        }
        if (tile.m_58904_().f_46443_) {
            return;
        }
        Level world = tile.m_58904_();
        Optional cap = Optional.empty();
        if (tile instanceof BlockEntityFluidPipe) {
            BlockEntityFluidPipe pipe = (BlockEntityFluidPipe)tile;
            cap = pipe.getPipeCapHolder().side(this.side).resolve();
        } else if (tile instanceof BlockEntityMachine) {
            BlockEntityMachine machine = (BlockEntityMachine)tile;
            cap = machine.fluidHandler.side(this.side).resolve();
        }
        BlockPos offset = tile.m_58899_().m_142300_(this.side);
        if (this.side == Direction.UP && world.m_46758_(offset) && world.m_46467_() % 60L == 0L && this.contained.isEmpty()) {
            cap.ifPresent(f -> {
                FluidStack toInsert;
                long filled;
                for (int i = 0; i < f.getTanks() && (filled = (long)f.fill(toInsert = new FluidStack((Fluid)Fluids.f_76193_, 4), IFluidHandler.FluidAction.EXECUTE)) <= 0L; ++i) {
                }
            });
        }
        if (!this.contained.isEmpty()) {
            cap.ifPresent(f -> {
                int filled = f.fill(this.contained.copy(), IFluidHandler.FluidAction.SIMULATE);
                if (filled > 0) {
                    f.fill(Utils.ca((int)filled, (FluidStack)this.contained), IFluidHandler.FluidAction.EXECUTE);
                    this.contained.setAmount(this.contained.getAmount() - filled);
                    if (this.contained.getAmount() <= 0) {
                        this.contained = FluidStack.EMPTY;
                    }
                }
            });
        }
        if (!this.receivedBlockUpdate && world.m_46467_() % 20L != 5L) {
            return;
        }
        if (!this.contained.isEmpty()) {
            if (!this.receivedBlockUpdate) {
                this.receivedBlockUpdate = true;
            }
            return;
        }
        BlockState blockState = world.m_8055_(offset);
        FluidState state = world.m_6425_(offset);
        if (state.m_76152_() == Fluids.f_76191_ || !state.m_76152_().m_7444_(state)) {
            return;
        }
        Fluid fluid = state.m_76152_();
        this.contained = new FluidStack(fluid, 1000);
        Holder biome = world.m_204166_(offset);
        if (fluid != Fluids.f_76193_ || !biome.m_203656_(BiomeTags.f_207602_) && !biome.m_203656_(BiomeTags.f_207603_) && !biome.m_203656_(BiomeTags.f_207605_)) {
            BlockState newState = Blocks.f_50016_.m_49966_();
            if (fluid == Fluids.f_76193_ && blockState.m_60734_() != Blocks.f_49990_ && blockState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                newState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
            }
            world.m_46597_(offset, newState);
        }
        if (this.receivedBlockUpdate) {
            this.receivedBlockUpdate = false;
        }
    }

    public void onBlockUpdate() {
        super.onBlockUpdate();
        this.receivedBlockUpdate = true;
    }

    public String getId() {
        return ID;
    }

    protected String getRenderId() {
        return ID;
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverDrain.getBasicModel();
    }

    public CompoundTag serialize() {
        CompoundTag tag = super.serialize();
        if (!this.contained.isEmpty()) {
            tag.m_128365_("contained", (Tag)this.contained.writeToNBT(new CompoundTag()));
        }
        return tag;
    }

    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        if (nbt.m_128441_("contained")) {
            this.contained = FluidUtils.fromTag((CompoundTag)nbt.m_128469_("contained"));
        }
    }
}

