/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.cover;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.gtreimagined.gt5r.cover.CoverItemFilter;
import org.gtreimagined.gt5r.cover.ImportExportMode;
import org.gtreimagined.gt5r.cover.RedstoneMode;
import org.gtreimagined.gt5r.cover.base.CoverBasicTransport;
import org.gtreimagined.gt5r.data.GT5RCovers;
import org.gtreimagined.gtlib.blockentity.BlockEntityBase;
import org.gtreimagined.gtlib.capability.ICoverHandler;
import org.gtreimagined.gtlib.capability.IFilterableHandler;
import org.gtreimagined.gtlib.capability.IGuiHandler;
import org.gtreimagined.gtlib.cover.CoverFactory;
import org.gtreimagined.gtlib.gui.SlotType;
import org.gtreimagined.gtlib.gui.event.GuiEvents;
import org.gtreimagined.gtlib.gui.event.IGuiEvent;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.event.IMachineEvent;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.Nullable;

public class CoverConveyor
extends CoverBasicTransport
implements IFilterableHandler {
    public static String ID = "conveyor";
    private boolean extracting = true;
    private final CoverItemFilter filter;
    public static final Map<Tier, Integer> speeds = ImmutableMap.builder().put((Object)Tier.LV, (Object)400).put((Object)Tier.MV, (Object)100).put((Object)Tier.HV, (Object)20).put((Object)Tier.EV, (Object)10).put((Object)Tier.IV, (Object)1).build();

    public CoverConveyor(ICoverHandler<?> source, @Nullable Tier tier, Direction side, CoverFactory factory) {
        super(source, tier, side, factory);
        this.filter = new CoverItemFilter(source, null, side, GT5RCovers.COVER_ITEM_FILTER);
        this.filter.onCreate();
        Objects.requireNonNull(tier);
        this.gui.getSlots().add(SlotType.STORAGE, 79, 53);
    }

    public boolean onTransfer(Object object, boolean inputSide, boolean simulate) {
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            if (this.getInventory(SlotType.STORAGE).getStackInSlot(0).m_41619_()) {
                return false;
            }
            return this.filter.onTransfer(stack, inputSide, simulate);
        }
        return super.onTransfer(object, inputSide, simulate);
    }

    public <T> boolean blocksCapability(Class<T> cap, Direction side) {
        return cap != IItemHandler.class;
    }

    public ResourceLocation getModel(String type, Direction dir) {
        if (type.equals("pipe")) {
            return PIPE_COVER_MODEL;
        }
        return CoverConveyor.getBasicDepthModel();
    }

    public void onUpdate() {
        BlockEntityBase base;
        block10: {
            block9: {
                BlockEntity blockEntity;
                if (this.handler.getTile().m_58904_().f_46443_ || !((blockEntity = this.handler.getTile()) instanceof BlockEntityBase)) break block9;
                base = (BlockEntityBase)blockEntity;
                if (this.handler.getTile().m_58904_().m_46467_() % (long)speeds.get(this.tier).intValue() == 0L) break block10;
            }
            return;
        }
        BlockState state = this.handler.getTile().m_58904_().m_8055_(this.handler.getTile().m_58899_().m_142300_(this.side));
        if (state == Blocks.f_50016_.m_49966_() && this.exportMode.isExport() && this.canMove(this.side)) {
            Level world = this.handler.getTile().m_58904_();
            BlockPos pos = this.handler.getTile().m_58899_();
            ItemStack stack = this.handler.getTile().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.side).map(Utils::extractAny).orElse(ItemStack.f_41583_);
            if (stack.m_41619_()) {
                return;
            }
            double x = (double)(pos.m_123341_() + this.side.m_122429_()) + 0.5;
            double y = (double)(pos.m_123342_() + this.side.m_122430_()) + 0.5;
            double z = (double)(pos.m_123343_() + this.side.m_122431_()) + 0.5;
            ItemEntity entity = new ItemEntity(world, x, y, z, stack, 0.0, 0.0, 0.0);
            world.m_7967_((Entity)entity);
        }
        if (!state.m_155947_()) {
            return;
        }
        BlockEntity adjTile = base.getCachedBlockEntity(this.side);
        if (adjTile == null) {
            return;
        }
        BlockEntity from = this.handler.getTile();
        BlockEntity to = adjTile;
        Direction fromSide = this.side;
        if (this.exportMode == ImportExportMode.IMPORT || this.exportMode == ImportExportMode.IMPORT_EXPORT) {
            from = adjTile;
            to = this.handler.getTile();
            fromSide = this.side.m_122424_();
        }
        BlockEntity finalTo = to;
        if (this.canMove(this.side)) {
            Direction finalFromSide = fromSide;
            from.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, fromSide).ifPresent(ih -> finalTo.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, finalFromSide.m_122424_()).ifPresent(oh -> Utils.transferItems((IItemHandler)ih, (IItemHandler)oh, (boolean)true)));
        }
    }

    protected boolean canMove(Direction side) {
        if (this.redstoneMode != RedstoneMode.NO_WORK) {
            boolean powered = this.isPowered(side);
            return this.redstoneMode == RedstoneMode.INVERTED != powered;
        }
        return true;
    }

    public boolean test(SlotType<?> slotType, int slot, ItemStack stack) {
        return stack.m_41720_() == GT5RCovers.COVER_ITEM_FILTER.getItem().m_41720_();
    }

    public void onMachineEvent(IGuiHandler tile, IMachineEvent event, int ... data) {
        if (tile == this && event == SlotType.STORAGE) {
            ItemStack slotStack = this.getInventory(SlotType.STORAGE).getStackInSlot(data[0]);
            if (slotStack.m_41619_()) {
                this.filter.clearFilter();
            } else {
                this.filter.addInfoFromStack(slotStack);
            }
        }
        super.onMachineEvent(tile, event, data);
    }

    @Override
    public void onGuiEvent(IGuiEvent event, Player playerEntity) {
        super.onGuiEvent(event, playerEntity);
        if (event.getFactory() == GuiEvents.EXTRA_BUTTON) {
            GuiEvents.GuiEvent ev = (GuiEvents.GuiEvent)event;
            if (ev.data[1] == 2) {
                this.filter.openGui(playerEntity, this.side);
            }
        }
    }

    public void addInfoFromStack(ItemStack stack) {
        super.addInfoFromStack(stack);
        this.onMachineEvent((IGuiHandler)this, (IMachineEvent)SlotType.STORAGE, 0);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        if (nbt.m_128441_("filter")) {
            this.filter.deserialize(nbt.m_128469_("filter"));
        }
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128365_("filter", (Tag)this.filter.serialize());
        return nbt;
    }
}

