/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single.bridge;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.gtreimagined.gt5r.blockentity.single.extender.BlockEntityExtender;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.blockentity.IExtendingBlockEntity;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityBridge
extends BlockEntityMachine<BlockEntityBridge>
implements IExtendingBlockEntity {
    public BlockEntityBridge(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public BlockEntity getExtendedBlockEntity(Direction side) {
        BlockEntity entity = this.getCachedBlockEntity(side);
        return this.canBridgeBlockEntity(entity) && this.isNotExtendingBlockEntity(entity) ? entity : null;
    }

    private boolean isNotExtendingBlockEntity(BlockEntity entity) {
        return !(entity instanceof BlockEntityBridge) && !(entity instanceof BlockEntityExtender);
    }

    protected abstract boolean canBridgeBlockEntity(BlockEntity var1);

    protected abstract <U> boolean canBridgeCapability(Capability<U> var1);

    @NotNull
    public <U> LazyOptional<U> getCapability(@NotNull Capability<U> cap, @Nullable Direction side) {
        BlockEntity neighbor;
        if (side != null && this.canBridgeCapability(cap) && this.isNotExtendingBlockEntity(neighbor = this.getCachedBlockEntity(side.m_122424_())) && neighbor != null) {
            return neighbor.getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    public void onBlockUpdate(BlockPos neighbor) {
        super.onBlockUpdate(neighbor);
        Direction facing = Utils.getOffsetFacing((BlockPos)this.m_58899_(), (BlockPos)neighbor);
        BlockPos offset = this.m_58899_().m_142300_(facing.m_122424_());
        this.m_58904_().m_46586_(offset, this.m_58904_().m_8055_(offset).m_60734_(), this.m_58899_());
    }
}

