/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.machine.MachineEnergyHandler;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.Tier;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.jetbrains.annotations.NotNull;

public class BlockEntitySolarPanel
extends BlockEntityMachine<BlockEntitySolarPanel> {
    public BlockEntitySolarPanel(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.energyHandler.set(() -> new MachineEnergyHandler<BlockEntitySolarPanel>(this, 0L, (this.getMachineTier() == Tier.NONE ? 2L : this.getMachineTier().getVoltage()) * 40L, 0L, this.getMachineTier() == Tier.LV ? 32L : 8L, 0, 1){

            public boolean canOutput(Direction direction) {
                return direction == Direction.DOWN;
            }
        });
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        this.energyHandler.ifPresent(e -> {
            long generation;
            long l = generation = this.getMachineTier() == Tier.NONE ? 1L : this.getMachineTier().getVoltage();
            if (this.skyBlockCheck(level, pos) && this.isSunVisible(level, pos.m_7494_()) && e.insertInternal(generation, true) == generation) {
                e.insertInternal(generation, false);
                if (this.getMachineState() != MachineState.ACTIVE) {
                    this.setMachineState(MachineState.ACTIVE);
                }
            } else if (this.getMachineState() == MachineState.ACTIVE) {
                this.setMachineState(MachineState.IDLE);
            }
        });
    }

    protected boolean allowExplosionsInRain() {
        return false;
    }

    public boolean toggleMachine() {
        return false;
    }

    public boolean skyBlockCheck(Level level, BlockPos pos) {
        return level.m_46861_(pos.m_7494_()) && level.m_6042_().m_63935_();
    }

    public boolean isSunVisible(@NotNull Level world, BlockPos pos) {
        if (!world.m_46461_()) {
            return false;
        }
        Holder biome = world.m_204166_(pos);
        return ((Biome)biome.m_203334_()).m_47530_() == Biome.Precipitation.NONE || !world.m_46471_() && !world.m_46470_();
    }
}

