/*
 * Decompiled with CFR 0.152.
 */
package org.gtreimagined.gt5r.blockentity.single;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.gtreimagined.gtlib.blockentity.BlockEntityMachine;
import org.gtreimagined.gtlib.capability.machine.MachineFluidHandler;
import org.gtreimagined.gtlib.machine.MachineState;
import org.gtreimagined.gtlib.machine.types.Machine;
import org.gtreimagined.gtlib.util.FluidUtils;
import org.gtreimagined.gtlib.util.Utils;

public class BlockEntityPump
extends BlockEntityMachine<BlockEntityPump> {
    int nextCheck = 0;
    byte mDir = 0;
    public ArrayList<BlockPos> mCheckList = new ArrayList();
    public LinkedList<BlockPos> mPumpList = new LinkedList();
    public Set<BlockPos> mChecked = new HashSet<BlockPos>();
    public List<Fluid> mPumpedFluids = new ArrayList<Fluid>();

    public BlockEntityPump(Machine<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidHandler.set(() -> new MachineFluidHandler((BlockEntityMachine)this, 8000 * this.getMachineTier().getIntegerId(), 0, 1));
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.getMachineState() == MachineState.DISABLED) {
            return;
        }
        if (this.energyHandler.map(e -> e.getEnergy() < this.getMachineTier().getVoltage() / 2L).orElse(false).booleanValue()) {
            if (this.getMachineState() == MachineState.ACTIVE) {
                this.setMachineState(MachineState.IDLE);
            }
            return;
        }
        --this.nextCheck;
        if (this.getMachineState() == MachineState.IDLE) {
            this.setMachineState(MachineState.ACTIVE);
        }
        this.exportFluid();
        if (this.mCheckList.isEmpty()) {
            if (this.nextCheck < 0) {
                this.scanForFluid(this.m_58899_().m_142300_(this.getFacing()));
                this.nextCheck = 3000;
            } else if (this.mPumpList.isEmpty()) {
                if (this.nextCheck > 20) {
                    this.nextCheck = 20;
                }
            } else {
                if (level.m_46467_() % ((long)(6 - this.getMachineTier().getIntegerId()) * 20L) != 0L) {
                    return;
                }
                Boolean bool = this.drainFluid(this.mPumpList.removeLast());
                if (bool == null) {
                    if (this.getMachineState() == MachineState.ACTIVE) {
                        this.setMachineState(MachineState.IDLE);
                    }
                } else if (!bool.booleanValue()) {
                    this.nextCheck = 0;
                }
            }
        } else {
            this.scanForFluid(this.offsetX(), this.offsetZ());
            this.nextCheck = 3000;
        }
    }

    private Boolean drainFluid(BlockPos aCoords) {
        FluidState state = this.f_58857_.m_6425_(aCoords);
        Fluid fluid = state.m_76152_();
        BlockState blockState = this.f_58857_.m_8055_(aCoords);
        if (!this.mPumpedFluids.contains(fluid)) {
            return false;
        }
        if (state.m_76170_()) {
            FluidStack stack = new FluidStack(fluid, 1000);
            if (this.fluidHandler.map(f -> f.fillOutput(stack, IFluidHandler.FluidAction.SIMULATE) != 1000).orElse(false).booleanValue()) {
                return null;
            }
            this.fluidHandler.ifPresent(f -> f.fillOutput(stack, IFluidHandler.FluidAction.EXECUTE));
        }
        BlockState newState = Blocks.f_50016_.m_49966_();
        if (fluid == Fluids.f_76193_ && blockState.m_60734_() != Blocks.f_49990_ && blockState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            newState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
        }
        if (!this.f_58857_.m_7731_(aCoords, newState, 11)) {
            return false;
        }
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_183324_().m_193234_(BoundingBox.m_162375_((Vec3i)aCoords.m_142082_(-2, -2, -2), (Vec3i)aCoords.m_142082_(2, 2, 2)));
        }
        this.energyHandler.ifPresent(e -> e.extractEu(this.getMachineTier().getVoltage() / 2L, false));
        if (this.mPumpedFluids.contains(this.f_58857_.m_6425_(aCoords).m_76152_())) {
            return false;
        }
        return !this.mPumpedFluids.contains(this.f_58857_.m_6425_(aCoords.m_142082_(1, 0, 0)).m_76152_()) || !this.mPumpedFluids.contains(this.f_58857_.m_6425_(aCoords.m_142082_(-1, 0, 0)).m_76152_()) || !this.mPumpedFluids.contains(this.f_58857_.m_6425_(aCoords.m_142082_(0, 0, 1)).m_76152_()) || !this.mPumpedFluids.contains(this.f_58857_.m_6425_(aCoords.m_142082_(0, 0, -1)).m_76152_());
    }

    public void exportFluid() {
        if (this.fluidHandler.map(f -> f.getOutputTanks().isEmpty()).orElse(false).booleanValue()) {
            return;
        }
        Arrays.stream(Direction.values()).filter(f -> f != this.getFacing()).collect(Collectors.toList()).forEach(this::exportFluidFromMachineToSide);
    }

    public void exportFluidFromMachineToSide(Direction side) {
        if (this.fluidHandler.map(f -> f.getOutputTanks().isEmpty()).orElse(false).booleanValue()) {
            return;
        }
        LazyOptional cap = FluidUtils.getFluidHandler((Level)this.m_58904_(), (BlockPos)this.m_58899_().m_142300_(side), (BlockEntity)this.getCachedBlockEntity(side), (Direction)side.m_122424_());
        this.fluidHandler.ifPresent(f -> cap.ifPresent(other -> Utils.transferFluids((IFluidHandler)f.getOutputTanks(), (IFluidHandler)other, (int)1000)));
    }

    private void scanForFluid(int aX, int aZ) {
        BlockPos[] tNeedsToBeChecked = (BlockPos[])this.mCheckList.toArray(BlockPos[]::new);
        this.mCheckList.clear();
        for (BlockPos tPos : tNeedsToBeChecked) {
            if (this.mDir != 0 && this.mPumpedFluids.contains(this.f_58857_.m_6425_(tPos.m_142082_(0, (int)this.mDir, 0)).m_76152_())) {
                this.mPumpList = new LinkedList();
                this.mCheckList.clear();
                this.mChecked.clear();
                this.addToList(tPos.m_123341_(), tPos.m_123342_() + this.mDir, tPos.m_123343_());
                return;
            }
            if (tPos.m_123341_() < aX + 64) {
                this.addToList(tPos.m_123341_() + 1, tPos.m_123342_(), tPos.m_123343_());
            }
            if (tPos.m_123341_() > aX - 64) {
                this.addToList(tPos.m_123341_() - 1, tPos.m_123342_(), tPos.m_123343_());
            }
            if (tPos.m_123343_() < aZ + 64) {
                this.addToList(tPos.m_123341_(), tPos.m_123342_(), tPos.m_123343_() + 1);
            }
            if (tPos.m_123343_() <= aZ - 64) continue;
            this.addToList(tPos.m_123341_(), tPos.m_123342_(), tPos.m_123343_() - 1);
        }
    }

    private int offsetX() {
        return this.m_58899_().m_123341_() + this.getFacing().m_122429_();
    }

    private int offsetZ() {
        return this.m_58899_().m_123343_() + this.getFacing().m_122431_();
    }

    private void scanForFluid(BlockPos offset) {
        Fluid fluid;
        this.mPumpList = new LinkedList();
        this.mCheckList.clear();
        this.mChecked.clear();
        this.mPumpedFluids.clear();
        FluidState aBlock = this.f_58857_.m_6425_(offset);
        if (aBlock.m_76178_() || !((fluid = aBlock.m_76152_()) instanceof FlowingFluid)) {
            this.energyHandler.ifPresent(e -> e.extractEu(2L, false));
            return;
        }
        FlowingFluid fluid2 = (FlowingFluid)fluid;
        this.mPumpedFluids.add(fluid2.m_5613_());
        this.mPumpedFluids.add(fluid2.m_5615_());
        this.mDir = (byte)(FluidUtils.isFluidGaseous((Fluid)aBlock.m_76152_()) ? -1 : 1);
        this.addToList(offset.m_123341_(), offset.m_123342_(), offset.m_123343_());
    }

    private boolean addToList(int aX, int aY, int aZ) {
        BlockPos tCoordinate = new BlockPos(aX, aY, aZ);
        if (this.mChecked.add(tCoordinate) && this.mPumpedFluids.contains(this.f_58857_.m_6425_(tCoordinate).m_76152_())) {
            this.mPumpList.add(tCoordinate);
            this.mCheckList.add(tCoordinate);
            return true;
        }
        return false;
    }
}

